/*
 * Decompiled with CFR 0.152.
 */
package org.jd.ide.eclipse;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JavaDecompilerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jd.ide.eclipse";
    private static final String EDITOR_ID = "jd.ide.eclipse.editors.JDClassFileEditor";
    public static final String VERSION_JD_ECLIPSE = "2.0.0";
    public static final String VERSION_JD_CORE = "1.0.7";
    public static final String PREF_ESCAPE_UNICODE_CHARACTERS = "jd.ide.eclipse.prefs.EscapeUnicodeCharacters";
    public static final String PREF_REALIGN_LINE_NUMBERS = "jd.ide.eclipse.prefs.RealignLineNumbers";
    public static final String PREF_SHOW_LINE_NUMBERS = "jd.ide.eclipse.prefs.ShowLineNumbers";
    public static final String PREF_SHOW_METADATA = "jd.ide.eclipse.prefs.ShowMetadata";
    public static final String URL_JDECLIPSE = "https://github.com/java-decompiler/jd-eclipse";
    private static JavaDecompilerPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Display.getDefault().syncExec((Runnable)new SetupClassFileAssociationRunnable());
    }

    public void stop(BundleContext context) throws Exception {
        plugin.savePluginPreferences();
        plugin = null;
        super.stop(context);
    }

    public static JavaDecompilerPlugin getDefault() {
        return plugin;
    }

    protected static class SetupClassFileAssociationRunnable
    implements Runnable {
        protected SetupClassFileAssociationRunnable() {
        }

        @Override
        public void run() {
            EditorRegistry registry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            IFileEditorMapping[] mappings = registry.getFileEditorMappings();
            IFileEditorMapping c = null;
            IFileEditorMapping cws = null;
            for (IFileEditorMapping iFileEditorMapping : mappings) {
                if (iFileEditorMapping.getExtension().equals("class")) {
                    c = iFileEditorMapping;
                    continue;
                }
                if (!iFileEditorMapping.getExtension().equals("class without source")) continue;
                cws = iFileEditorMapping;
            }
            if (c != null && cws != null) {
                IEditorDescriptor defaultClassFileEditor;
                for (IFileEditorMapping iFileEditorMapping : c.getEditors()) {
                    if (!iFileEditorMapping.getId().equals(JavaDecompilerPlugin.EDITOR_ID)) continue;
                    ((FileEditorMapping)c).removeEditor((IEditorDescriptor)((EditorDescriptor)iFileEditorMapping));
                    registry.setDefaultEditor("." + cws.getExtension(), iFileEditorMapping.getId());
                    break;
                }
                if ((defaultClassFileEditor = registry.findEditor("org.eclipse.jdt.ui.ClassFileEditor")) != null) {
                    registry.setDefaultEditor("." + c.getExtension(), "org.eclipse.jdt.ui.ClassFileEditor");
                }
                registry.setFileEditorMappings((FileEditorMapping[])mappings);
                registry.saveAssociations();
            }
        }
    }
}

