/*
 * Decompiled with CFR 0.152.
 */
package org.jd.ide.eclipse.editors;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jd.ide.eclipse.JavaDecompilerPlugin;
import org.jd.ide.eclipse.editors.JDSourceMapper;

public class JDClassFileEditor
extends ClassFileEditor
implements IPropertyChangeListener {
    public JDClassFileEditor() {
        JavaDecompilerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            if (file instanceof IClassFile) {
                IClassFile classFile = (IClassFile)file;
                JDClassFileEditor.cleanupBuffer(classFile);
                this.setupSourceMapper(classFile);
            }
        } else if (input instanceof IClassFileEditorInput) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
            IClassFile classFile = classFileEditorInput.getClassFile();
            JDClassFileEditor.cleanupBuffer(classFile);
            this.setupSourceMapper(classFile);
        }
        super.doSetInput(input);
    }

    protected static void cleanupBuffer(IClassFile file) {
        IBuffer buffer = BufferManager.getDefaultBufferManager().getBuffer((IOpenable)file);
        if (buffer != null) {
            try {
                Method method = BufferManager.class.getDeclaredMethod("removeBuffer", IBuffer.class);
                method.setAccessible(true);
                method.invoke((Object)BufferManager.getDefaultBufferManager(), buffer);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "jd.ide.eclipse", 0, e.getMessage(), (Throwable)e));
            }
        }
    }

    protected void setupSourceMapper(IClassFile classFile) {
        try {
            IJavaElement packageFragment = classFile.getParent();
            IJavaElement packageFragmentRoot = packageFragment.getParent();
            if (packageFragmentRoot instanceof PackageFragmentRoot) {
                String sourceRootPath;
                IPath sourceAttachmentRootPath;
                IPath sourcePath;
                PackageFragmentRoot root = (PackageFragmentRoot)packageFragmentRoot;
                IPath basePath = root.getPath();
                File baseFile = basePath.makeAbsolute().toFile();
                if (!baseFile.exists()) {
                    IResource resource = root.getCorrespondingResource();
                    basePath = resource.getLocation();
                    baseFile = basePath.makeAbsolute().toFile();
                }
                String classPath = classFile.getElementName();
                String packageName = packageFragment.getElementName();
                if (packageName != null && packageName.length() > 0) {
                    classPath = packageName.replace('.', '/') + '/' + classPath;
                }
                if ((sourcePath = root.getSourceAttachmentPath()) == null) {
                    sourcePath = basePath;
                }
                if ((sourceAttachmentRootPath = root.getSourceAttachmentRootPath()) == null) {
                    sourceRootPath = null;
                } else {
                    sourceRootPath = sourceAttachmentRootPath.toString();
                    if (sourceRootPath != null && sourceRootPath.length() == 0) {
                        sourceRootPath = null;
                    }
                }
                Map options = root.getJavaProject().getOptions(true);
                root.setSourceMapper((SourceMapper)new JDSourceMapper(baseFile, sourcePath, sourceRootPath, options));
            }
        }
        catch (CoreException e) {
            JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "jd.ide.eclipse", 0, e.getMessage(), (Throwable)e));
        }
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return false;
    }

    public void dispose() {
        JavaDecompilerPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getSourceViewer() != null) {
            this.setInput(this.getEditorInput());
        }
    }
}

