/*
 * Decompiled with CFR 0.152.
 */
package org.jd.ide.eclipse.editors;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jd.core.v1.ClassFileToJavaSourceDecompiler;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.printer.Printer;
import org.jd.ide.eclipse.JavaDecompilerPlugin;
import org.jd.ide.eclipse.util.loader.DirectoryLoader;
import org.jd.ide.eclipse.util.loader.ZipLoader;
import org.jd.ide.eclipse.util.printer.LineNumberStringBuilderPrinter;

public class JDSourceMapper
extends SourceMapper {
    private static final String JAVA_CLASS_SUFFIX = ".class";
    private static final String JAVA_SOURCE_SUFFIX = ".java";
    private static final int JAVA_SOURCE_SUFFIX_LENGTH = 5;
    private static final ClassFileToJavaSourceDecompiler DECOMPILER = new ClassFileToJavaSourceDecompiler();
    private File basePath;
    private LineNumberStringBuilderPrinter printer = new LineNumberStringBuilderPrinter();

    public JDSourceMapper(File basePath, IPath sourcePath, String sourceRootPath, Map options) {
        super(sourcePath, sourceRootPath, options);
        this.basePath = basePath;
    }

    public char[] findSource(String javaSourcePath) {
        char[] source = null;
        if (this.rootPaths == null) {
            source = super.findSource(javaSourcePath);
        } else {
            Iterator iterator = this.rootPaths.iterator();
            while (iterator.hasNext() && source == null) {
                String sourcesRootPath = (String)iterator.next();
                source = super.findSource(sourcesRootPath + '/' + javaSourcePath);
            }
        }
        if (source == null && javaSourcePath.toLowerCase().endsWith(JAVA_SOURCE_SUFFIX)) {
            String internalTypeName = javaSourcePath.substring(0, javaSourcePath.length() - 5);
            try {
                source = this.decompile(this.basePath.getAbsolutePath(), internalTypeName);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "jd.ide.eclipse", 0, e.getMessage(), (Throwable)e));
            }
        }
        return source;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected char[] decompile(String basePath, String internalTypeName) throws Exception {
        void var9_12;
        IPreferenceStore store = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean realignmentLineNumber = store.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        boolean unicodeEscape = store.getBoolean("jd.ide.eclipse.prefs.EscapeUnicodeCharacters");
        boolean showLineNumbers = store.getBoolean("jd.ide.eclipse.prefs.ShowLineNumbers");
        boolean showMetaData = store.getBoolean("jd.ide.eclipse.prefs.ShowMetadata");
        HashMap<String, Boolean> configuration = new HashMap<String, Boolean>();
        configuration.put("realignLineNumbers", realignmentLineNumber);
        File base = new File(basePath);
        if (base.isFile()) {
            if (!basePath.toLowerCase().endsWith(".jar") && !basePath.toLowerCase().endsWith(".zip")) {
                JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "jd.ide.eclipse", "Unexpected container type file: " + basePath));
                return null;
            }
            ZipLoader zipLoader = new ZipLoader(base);
        } else {
            DirectoryLoader directoryLoader = new DirectoryLoader(base);
        }
        this.printer.setRealignmentLineNumber(realignmentLineNumber);
        this.printer.setUnicodeEscape(unicodeEscape);
        this.printer.setShowLineNumbers(showLineNumbers);
        DECOMPILER.decompile((Loader)var9_12, (Printer)this.printer, internalTypeName, configuration);
        StringBuilder stringBuffer = this.printer.getStringBuffer();
        if (showMetaData) {
            stringBuffer.append("\n\n/* Location:              ");
            String classPath = internalTypeName + JAVA_CLASS_SUFFIX;
            String location = base.isFile() ? base.getPath() + "!/" + classPath : new File(base, classPath).getPath();
            stringBuffer.append(location.replaceAll("(^|[^\\\\])\\\\u", "\\\\\\\\u"));
            int majorVersion = this.printer.getMajorVersion();
            if (majorVersion >= 45) {
                stringBuffer.append("\n * Java compiler version: ");
                if (majorVersion >= 49) {
                    stringBuffer.append(majorVersion - 44);
                } else {
                    stringBuffer.append(majorVersion - 44);
                }
                stringBuffer.append(" (");
                stringBuffer.append(majorVersion);
                stringBuffer.append('.');
                stringBuffer.append(this.printer.getMinorVersion());
                stringBuffer.append(')');
            }
            stringBuffer.append("\n * JD-Core Version:       ");
            stringBuffer.append("1.0.7");
            stringBuffer.append("\n */");
        }
        return stringBuffer.toString().toCharArray();
    }
}

