/*
 * Decompiled with CFR 0.152.
 */
package org.jd.ide.eclipse.util.loader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.loader.LoaderException;

public class ZipLoader
implements Loader {
    protected HashMap<String, byte[]> map = new HashMap();

    public ZipLoader(File zip) throws LoaderException {
        byte[] buffer = new byte[2048];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int read = zis.read(buffer);
                    while (read > 0) {
                        out.write(buffer, 0, read);
                        read = zis.read(buffer);
                    }
                    this.map.put(ze.getName(), out.toByteArray());
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        catch (IOException e) {
            throw new LoaderException((Throwable)e);
        }
    }

    public byte[] load(String internalName) throws LoaderException {
        return this.map.get(internalName + ".class");
    }

    public boolean canLoad(String internalName) {
        return this.map.containsKey(internalName + ".class");
    }
}

