/*
 * Decompiled with CFR 0.152.
 */
package org.jd.ide.eclipse.util.printer;

import org.jd.core.v1.api.printer.Printer;

public class StringBuilderPrinter
implements Printer {
    protected static final String TAB = "  ";
    protected static final String NEWLINE = "\n";
    protected StringBuilder stringBuffer = new StringBuilder(10240);
    protected boolean unicodeEscape = true;
    protected boolean realignmentLineNumber = false;
    protected int majorVersion = 0;
    protected int minorVersion = 0;
    protected int indentationCount;

    public void setUnicodeEscape(boolean unicodeEscape) {
        this.unicodeEscape = unicodeEscape;
    }

    public void setRealignmentLineNumber(boolean realignmentLineNumber) {
        this.realignmentLineNumber = realignmentLineNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public StringBuilder getStringBuffer() {
        return this.stringBuffer;
    }

    protected void escape(String s) {
        if (this.unicodeEscape && s != null) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c == '\t') {
                    this.stringBuffer.append(c);
                    continue;
                }
                if (c < ' ') {
                    this.stringBuffer.append("\\0");
                    this.stringBuffer.append((char)(48 + (c >> 3)));
                    this.stringBuffer.append((char)(48 + (c & 7)));
                    continue;
                }
                if (c > '\u007f') {
                    this.stringBuffer.append("\\u");
                    int z = c >> 12;
                    this.stringBuffer.append((char)(z <= 9 ? 48 + z : 55 + z));
                    z = c >> 8 & 0xF;
                    this.stringBuffer.append((char)(z <= 9 ? 48 + z : 55 + z));
                    z = c >> 4 & 0xF;
                    this.stringBuffer.append((char)(z <= 9 ? 48 + z : 55 + z));
                    z = c & 0xF;
                    this.stringBuffer.append((char)(z <= 9 ? 48 + z : 55 + z));
                    continue;
                }
                this.stringBuffer.append(c);
            }
        } else {
            this.stringBuffer.append(s);
        }
    }

    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        this.stringBuffer.setLength(0);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.indentationCount = 0;
    }

    public void end() {
    }

    public void printText(String text) {
        this.escape(text);
    }

    public void printNumericConstant(String constant) {
        this.escape(constant);
    }

    public void printStringConstant(String constant, String ownerInternalName) {
        this.escape(constant);
    }

    public void printKeyword(String keyword) {
        this.stringBuffer.append(keyword);
    }

    public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
        this.escape(name);
    }

    public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
        this.escape(name);
    }

    public void indent() {
        ++this.indentationCount;
    }

    public void unindent() {
        if (this.indentationCount > 0) {
            --this.indentationCount;
        }
    }

    public void startLine(int lineNumber) {
        for (int i = 0; i < this.indentationCount; ++i) {
            this.stringBuffer.append(TAB);
        }
    }

    public void endLine() {
        this.stringBuffer.append(NEWLINE);
    }

    public void extraLine(int count) {
        if (this.realignmentLineNumber) {
            while (count-- > 0) {
                this.stringBuffer.append(NEWLINE);
            }
        }
    }

    public void startMarker(int type) {
    }

    public void endMarker(int type) {
    }
}

