# JD-Eclipse

JD-Eclipse, a Java decompiler plug-in for the Eclipse platform.

![](http://java-decompiler.github.io/img/screenshot8.png)

- Java Decompiler projects home page: [http://java-decompiler.github.io](http://java-decompiler.github.io)
- Java Decompiler Wikipedia page: [http://en.wikipedia.org/wiki/Java_Decompiler](http://en.wikipedia.org/wiki/Java_Decompiler)
- JD-Eclipse source code: [https://github.com/java-decompiler/jd-eclipse](https://github.com/java-decompiler/jd-eclipse)

## Description
JD-Eclipse is a plug-in for the Eclipse platform. It allows you to 
display all the Java sources during your debugging process, even if 
you do not have them all.

## How to build JD-Eclipse ?
### With Gradle:
```
> ./gradlew installSiteDist
```
generate _"build/install/jd-eclipse-site"_
### With Eclipse:
- Download dependencies
```
> ./gradlew downloadDependencies
```
- Launch _Eclipse_,
- Import the 3 _"Existing Projects into Workspace"_ by selecting the parent project folder,
- Export _"Deployable features"_,
- Copy _"site.xml"_ to the destination directory.

## How to install JD-Eclipse ?
1. Build or download & unzip _"jd-eclipse-site-x.y.z.zip"_,
2. Launch _Eclipse_,
3. Click on _"Help > Install New Software..."_,
4. Click on button _"Add..."_ to add an new repository,
5. Enter _"JD-Eclipse Update Site"_ and select the local site directory,
6. Check _"Java Decompiler Eclipse Plug-in"_,
7. Next, next, next... and restart.

## How to check the file associations ?
Click on _"Window > Preferences > General > Editors > File Associations"_
- _"*.class"_ : _Eclipse_ _"Class File Viewer"_ is selected by default.
- _"*.class without source"_ : _"JD Class File Viewer"_ is selected by default.

## How to configure JD-Eclipse ?
Click on _"Window > Preferences > Java > Decompiler"_

## How to uninstall JD-Eclipse ?
1. Click on _"Help > About Eclipse > Installation Details"_,
2. Select _"JD-Eclipse Plug-in"_,
3. Click on _"Uninstall..."_.

## License
Released under the [GNU GPL v3](LICENSE).

## Donations
Did JD-GUI help you to solve a critical situation? Do you use JD-Eclipse daily? What about making a donation?

[![paypal](https://raw.githubusercontent.com/java-decompiler/jd-eclipse/master/src/website/img/btn_donate_euro.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=C88ZMVZ78RF22) [![paypal](https://raw.githubusercontent.com/java-decompiler/jd-eclipse/master/src/website/img/btn_donate_usd.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=CRMXT4Y4QLQGU)
