
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/yasuo.zip" ),
}
local prefabs = {}
local max_upgrades = 10
local function applyupgrades(inst)

        
        local upgrades = math.min(inst.level, max_upgrades)

        local hunger_percent = inst.components.hunger:GetPercent()
        local health_percent = inst.components.health:GetPercent()
        local sanity_percent = inst.components.sanity:GetPercent()

        inst.components.hunger.max = math.ceil (80 + upgrades * 4)
        inst.components.health.maxhealth = math.ceil (60 + upgrades * 6)
        inst.components.sanity.max = math.ceil (90 + upgrades * 3)
        inst.components.locomotor.walkspeed =  math.ceil (5 + upgrades / 10)
        inst.components.locomotor.runspeed = math.ceil (7 + upgrades / 5)
        inst.components.combat.damagemultiplier = math.ceil (0.9 + upgrades / 20)

        inst.components.talker:Say("Wind Up! : ".. (inst.level))
        
        if inst.level >9 then
                inst.components.talker:Say("Wind : Max!")
        end

        inst.components.hunger:SetPercent(hunger_percent)
        inst.components.health:SetPercent(health_percent)
        inst.components.sanity:SetPercent(sanity_percent)
end

local function onkill(inst, data)
    local chance1 = 0.01
    local chance2 = 0.03
    local iflevelup = false
    if data.cause == inst.prefab and not data.inst:HasTag("companion") then
        if math.random() < chance1 and data.inst:HasTag("prey") then
            iflevelup = true
        elseif math.random() < chance2 and not data.inst:HasTag("prey") and not data.inst:HasTag("insect") then
            iflevelup = true
        end
    end

    if iflevelup and inst.level < max_upgrades then
        inst.level = inst.level + 1
        applyupgrades(inst) 
        inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")

        --icon pulse while upgrading
        inst.HUD.controls.status.heart:PulseGreen()
        inst.HUD.controls.status.stomach:PulseGreen()
        inst.HUD.controls.status.brain:PulseGreen()
            
        inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
    end
end


local function onpreload(inst, data)
        if data then
                if data.level then
                        inst.level = data.level
                        applyupgrades(inst)
                        --re-set these from the save data, because of load-order clipping issues
                        if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
                        if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
                        if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
                        inst.components.health:DoDelta(0)
                        inst.components.hunger:DoDelta(0)
                        inst.components.sanity:DoDelta(0)
                end
        end

end

local function onsave(inst, data)
        data.level = inst.level
end




local fn = function(inst)
	inst.soundsname = "wolfgang"
	inst.MiniMapEntity:SetIcon( "yasuo.tex" )
        
        inst.level = 0
        applyupgrades(inst)

-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 0.9
    
    -- Movement speed (optional)
    inst.components.locomotor.walkspeed = 5
    inst.components.locomotor.runspeed = 7

    inst.OnSave = onsave
    inst.OnPreLoad = onpreload

    -- lower profit from non-meat food

    inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())




end


return MakePlayerCharacter("yasuo", prefabs, assets, fn)
