local assets=
{
	Asset("ANIM", "anim/yaoshui.zip"),
	
	Asset("ATLAS", "images/inventoryimages/yaoshui.xml"),
    Asset("IMAGE", "images/inventoryimages/yaoshui.tex"),
}

local function fn()
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	--inst.entity:AddSoundEmitter()
	--inst.entity:AddPhysics()
	inst.entity:AddNetwork()
	inst.entity:AddLight()
	
    MakeInventoryPhysics(inst)
	RemovePhysicsColliders(inst)

    inst.AnimState:SetBank("yaoshui")
    inst.AnimState:SetBuild("yaoshui")
    inst.AnimState:PlayAnimation("idle")


	
	
	inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("edible")
    inst.components.edible.healthvalue = 20
    inst.components.edible.hungervalue = 10
    inst.components.edible.foodtype = FOODTYPE.VEGGIE
    --inst:AddComponent("tradable")
    
    inst:AddComponent("inspectable")
	

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "yaoshui"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/yaoshui.xml"
  
    return inst
end

return Prefab( "common/inventory/yaoshui", fn, assets) 
