local Wharang_Stats = GetModConfigData("wharang_stat")

PrefabFiles = {
	"wharang",
	"wharang_none",
	"wharang_fur",
	"wharang_fan1",
	"wharang_fan2",
	"wharang_dango",
	"wharang_foxhat",
	"wharang_onggi",
	"wharang_shrine",
	"wharang_veggies",
	"wharang_foxfire",
	"wharang_fx",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/wharang.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wharang.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wharang.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wharang.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/wharang_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wharang_silho.xml" ),

    Asset( "IMAGE", "bigportraits/wharang.tex" ),
    Asset( "ATLAS", "bigportraits/wharang.xml" ),
	
	Asset( "IMAGE", "images/map_icons/wharang.tex" ),
	Asset( "ATLAS", "images/map_icons/wharang.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_wharang.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_wharang.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_wharang.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_wharang.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_wharang.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_wharang.xml" ),
	
	Asset( "IMAGE", "images/names_wharang.tex" ),
    Asset( "ATLAS", "images/names_wharang.xml" ),
	
    Asset( "IMAGE", "bigportraits/wharang_none.tex" ),
    Asset( "ATLAS", "bigportraits/wharang_none.xml" ),
	
	----
	
	Asset( "IMAGE", "images/map_icons/wharang_fan1.tex" ),
	Asset( "ATLAS", "images/map_icons/wharang_fan1.xml" ),
	Asset( "IMAGE", "images/map_icons/wharang_fan2.tex" ),
	Asset( "ATLAS", "images/map_icons/wharang_fan2.xml" ),
	Asset( "IMAGE", "images/map_icons/wharang_onggi.tex" ),
	Asset( "ATLAS", "images/map_icons/wharang_onggi.xml" ),
	Asset( "IMAGE", "images/map_icons/wharang_shrine.tex" ),
	Asset( "ATLAS", "images/map_icons/wharang_shrine.xml" ),
	
	Asset( "IMAGE", "images/yinyangtab.tex" ),
    Asset( "ATLAS", "images/yinyangtab.xml" ),
	
	Asset( "ANIM", "anim/wharang_sanity_badge.zip" ),
	
	
	Asset("ANIM", "anim/wharang.zip"),
	Asset("ANIM", "anim/wharang_white.zip"),
	Asset("ANIM", "anim/ghost_wharang_build.zip"),
	
    Asset("ANIM", "anim/wharang_dango.zip"),
	Asset("ATLAS", "images/inventoryimages/wharang_dango.xml"),
	
    Asset("ANIM", "anim/wharang_fan1.zip"),
    Asset("ANIM", "anim/wharang_swap_fan1.zip"),
    Asset("ATLAS", "images/inventoryimages/wharang_fan1.xml"),

	Asset("ANIM", "anim/wharang_foxfire.zip"),
	
    Asset("ANIM", "anim/wharang_fur.zip"),
	Asset("ATLAS", "images/inventoryimages/wharang_fur.xml"),
	
	Asset( "ANIM", "anim/wharang_swap_sakurahat.zip" ),
	
    Asset("ANIM", "anim/wharang_fan2.zip"),
    Asset("ANIM", "anim/wharang_swap_fan2.zip"),
    Asset("ATLAS", "images/inventoryimages/wharang_fan2.xml"),
	
    Asset("ANIM", "anim/wharang_foxhat.zip"),
	Asset("ANIM", "anim/wharang_swap_foxhat.zip"),
	Asset("ATLAS", "images/inventoryimages/wharang_foxhat.xml"),
	
	Asset("ANIM", "anim/wharang_ground_fire_fx.zip"),
	Asset("ANIM", "anim/attune_fx.zip"),
	
	Asset("ANIM", "anim/wharang_onggi.zip"),
	Asset("ANIM", "anim/ui_chest_4x4.zip"),
	Asset("ATLAS", "images/inventoryimages/wharang_onggi.xml"),
	
    Asset("ANIM", "anim/wharang_shrine.zip"),
	Asset("ATLAS", "images/inventoryimages/wharang_shrine.xml"),
	
	Asset("ANIM", "anim/wharang_flamefruit.zip" ),
	Asset("ATLAS", "images/inventoryimages/wharang_flamefruit_seeds.xml"),
	Asset("ATLAS", "images/inventoryimages/wharang_flamefruit.xml"),
	Asset("ATLAS", "images/inventoryimages/wharang_flamefruit_cooked.xml"),
	
	Asset( "SOUND" , "sound/milleniumfox.fsb" ),
	Asset( "SOUNDPACKAGE" , "sound/milleniumfox.fev" ),

}

AddModCharacter("wharang", "FEMALE")

RemapSoundEvent("dontstarve/characters/wharang/talk_LP","dontstarve/characters/winnie/talk_LP")
RemapSoundEvent("dontstarve/characters/wharang/hurt","dontstarve/characters/winnie/hurt")
RemapSoundEvent("dontstarve/characters/wharang/death_voice","dontstarve/characters/wendy/death_voice")
RemapSoundEvent("dontstarve/characters/wharang/emote","dontstarve/characters/willow/emote")
RemapSoundEvent("dontstarve/characters/wharang/yawn","dontstarve/characters/willow/yawn")
RemapSoundEvent("dontstarve/characters/wharang/ghost_LP","dontstarve/characters/willow/ghost_LP")

ExcludeClothingSymbolForModCharacter("wharang", "torso")
ExcludeClothingSymbolForModCharacter("wharang", "torso_pelvis")
ExcludeClothingSymbolForModCharacter("wharang", "skirt")
ExcludeClothingSymbolForModCharacter("wharang", "arm_upper")
ExcludeClothingSymbolForModCharacter("wharang", "arm_upper_skin")
ExcludeClothingSymbolForModCharacter("wharang", "arm_lower")
ExcludeClothingSymbolForModCharacter("wharang", "arm_lower_cuff")
ExcludeClothingSymbolForModCharacter("wharang", "hand")
ExcludeClothingSymbolForModCharacter("wharang", "leg")
ExcludeClothingSymbolForModCharacter("wharang", "foot")
ExcludeClothingSymbolForModCharacter("wharang", "tail")

AddMinimapAtlas("images/map_icons/wharang.xml")
AddMinimapAtlas("images/map_icons/wharang_fan1.xml")
AddMinimapAtlas("images/map_icons/wharang_fan2.xml")
AddMinimapAtlas("images/map_icons/wharang_onggi.xml")
AddMinimapAtlas("images/map_icons/wharang_shrine.xml")


_G = GLOBAL
local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH

local containers = require("containers")

GLOBAL.KOREAN = false
GLOBAL.CHINESE = false


for k,v in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do 
local MOD = GLOBAL.KnownModIndex:GetModInfo(v).name
	if MOD == "한글 모드 서버 버전" or MOD == "한글 모드 클라이언트 버전" then
		GLOBAL.KOREAN = true
	else GLOBAL.KOREAN = false
	end
	
	if MOD == "Chinese Language Pack" or MOD == "Chinese Plus" then
		GLOBAL.CHINESE = true
	else GLOBAL.CHINESE = false
	end
end

if GLOBAL.KOREAN == true then
modimport("scripts/wharang_strings_ko.lua")
STRINGS.CHARACTERS.WHARANG = require "speech_wendy"
elseif GLOBAL.CHINESE == true then
modimport("scripts/wharang_strings_ch.lua")
STRINGS.CHARACTERS.WHARANG = require "speech_wendy"
else
modimport("scripts/wharang_strings.lua")
STRINGS.CHARACTERS.WHARANG = require "speech_wendy"
end

AddUserCommand("info", {
	aliases = {"wharang", "wharanginfo", "information", "soulheart", "soulspirit", "soul"},
	prettyname = nil,
	desc = nil,
	permission = GLOBAL.COMMAND_PERMISSION.USER,
	params = {},
	emote = true,
	slash = true,
	usermenu = false,
	servermenu = false,
	vote = false,
	paramsoptional = {true},
    localfn = function(params, caller)
		local player = GLOBAL.UserToPlayer(caller.userid) or GLOBAL.ThePlayer
		if player ~= nil then
			if player.prefab == "wharang" then
				caller.HUD.controls.networkchatqueue:DisplaySystemMessage(STRINGS.WHARANG_SOULHEART_INFO.."(".. player.soulheart.."/"..TUNING.WHARANG_SOULHEART_MAX..")  "..STRINGS.WHARANG_SOULSPIRIT_INFO.."(".. player.soulspirit.."/"..TUNING.WHARANG_SOULSPIRIT_MAX.."xp)  "..STRINGS.WHARANG_TAILFUR_INFO.."(".. player.wharangfur..")")
			end
		end
	end,
})

AddUserCommand("fan", {
	aliases = {"wharangfan", "gumifan"},
	prettyname = nil,
	desc = nil,
	permission = GLOBAL.COMMAND_PERMISSION.USER,
	params = {},
	emote = true,
	slash = true,
	usermenu = false,
	servermenu = false,
	vote = false,
	paramsoptional = {true},
    localfn = function(params, caller)
	
        if caller == nil or caller.HUD == nil then
            return
        end
	
		local player = GLOBAL.UserToPlayer(caller.userid) or GLOBAL.ThePlayer
		if player ~= nil then
			if player.prefab == "wharang" then
				player:PushEvent("find_wharangfan")
			end
		end
	end,
})

local params = {}

local containers_widgetsetup_base = containers.widgetsetup
function containers.widgetsetup(container, prefab, data, ...)
    local t = params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
    else
        containers_widgetsetup_base(container, prefab, data, ...)
    end
end

local function WharangChest_4x4()
    local container =
    {
        widget =
        {
            slotpos = {},
            animbank = "ui_chest_4x4",
            animbuild = "ui_chest_4x4",
            pos = GLOBAL.Vector3(0, 200, 0),
            side_align_tip = 160,
        },
        type = "chest",
    }

    for y = 2.5, -.5, -1 do
        for x = 0, 3 do
            table.insert(container.widget.slotpos, GLOBAL.Vector3(75*x-93*2+75, 75*y-75*2+75,0))
        end
    end

    return container
end

params.wharang_onggi = WharangChest_4x4()

for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end

local function WharangBadge(class, owner)
	if GLOBAL.ThePlayer.prefab == "wharang" then
		class.brain.anim:GetAnimState():SetBuild("wharang_sanity")
	end
end AddClassPostConstruct("widgets/statusdisplays", WharangBadge)


RECIPETABS.YINYANG = {str = "YINYANG", sort = 19, icon = "yinyangtab.tex", icon_atlas = "images/yinyangtab.xml"}

local wharang_dango = AddRecipe("wharang_dango", {Ingredient("berries", 4), Ingredient("seeds_cooked", 3)}, RECIPETABS.YINYANG, TECH.NONE, nil, nil, nil, nil, "wharang")
wharang_dango.atlas = "images/inventoryimages/wharang_dango.xml"

local wharang_fan = AddRecipe("wharang_fan2", {Ingredient("wharang_fan1", 1, "images/inventoryimages/wharang_fan1.xml"), Ingredient("wharang_fur", 3, "images/inventoryimages/wharang_fur.xml"), Ingredient("goldnugget", 6)}, RECIPETABS.YINYANG, TECH.NONE, nil, nil, nil, nil, "wharang")
wharang_fan.atlas = "images/inventoryimages/wharang_fan2.xml"

local wharang_foxhat = AddRecipe("wharang_foxhat", {Ingredient("goldnugget", 4), Ingredient("wharang_fur", 2, "images/inventoryimages/wharang_fur.xml"), Ingredient("nightmarefuel", 2)}, RECIPETABS.YINYANG, TECH.SCIENCE_ONE, nil, nil, nil, nil, "wharang")
wharang_foxhat.atlas = "images/inventoryimages/wharang_foxhat.xml"

local wharang_onggi = AddRecipe("wharang_onggi", {Ingredient("boards", 4), Ingredient("cutstone", 12)}, RECIPETABS.YINYANG, TECH.SCIENCE_ONE, "wharang_onggi_placer", 1, nil, nil, "wharang")
wharang_onggi.atlas = "images/inventoryimages/wharang_onggi.xml"

local wharang_shrine = AddRecipe("wharang_shrine", {Ingredient("boards", 20), Ingredient("wall_stone_item", 40), Ingredient("redgem", 2)}, RECIPETABS.YINYANG, TECH.SCIENCE_ONE, "wharang_shrine_placer", 4, nil, nil, "wharang")
wharang_shrine.atlas = "images/inventoryimages/wharang_shrine.xml"


AddIngredientValues({"wharang_dango"}, {sweetener=1})
AddIngredientValues({"wharang_flamefruit"}, {fruit=1}, true)


-----TUNING.lua

local seg_time = 30
local total_day_time = seg_time*16
local perish_warp = 1--/200

TUNING.WHARANG_FAN_REMOVETIME = 3*total_day_time*perish_warp

TUNING.WHARANG_SOULHEART_MAX = 500
TUNING.WHARANG_SOULSPIRIT_MAX = 500

if Wharang_Stats == "stat_soul" then

TUNING.WHARANG_HEALTH = 85
TUNING.WHARANG_HUNGER = 150
TUNING.WHARANG_SANITY = 150

TUNING.WHARANG_HEALTH_PLUS = .4
TUNING.WHARANG_HUNGER_PLUS = .2
TUNING.WHARANG_SANITY_PLUS = .2

elseif Wharang_Stats == "stat_nosoul" then

TUNING.WHARANG_HEALTH = 285
TUNING.WHARANG_HUNGER = 285
TUNING.WHARANG_SANITY = 300

TUNING.WHARANG_HEALTH_PLUS = 0
TUNING.WHARANG_HUNGER_PLUS = 0
TUNING.WHARANG_SANITY_PLUS = 0
end