local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	
	Asset("ANIM", "anim/wharang.zip"),
	Asset("ANIM", "anim/wharang_white.zip"),
	Asset("ANIM", "anim/ghost_wharang_build.zip"),
	Asset("ANIM", "anim/wharang_swap_sakurahat.zip"),
	
}
	
local prefabs = {
	"wathgrithr_spirit",
	"wharang_fur",
}

local start_inv = {
	"wharang_fan1",
	--"wharang_dango",
	--"wharang_dango",
}

local function SoulHeart_Collect(inst)
	local MAX_SoulHeart = TUNING.WHARANG_SOULHEART_MAX
	local GET_SoulHeart = math.min(inst.soulheart, MAX_SoulHeart)

	local MAX_SoulSpirit = TUNING.WHARANG_SOULSPIRIT_MAX
	local GET_SoulSpirit = math.min(inst.soulspirit, MAX_SoulSpirit)

	if inst.soulheart < MAX_SoulHeart then
		if inst.soulspirit >= MAX_SoulSpirit then
			inst.soulspirit = inst.soulspirit - MAX_SoulSpirit
			inst.soulheart = inst.soulheart + 1
			
			inst.SoundEmitter:PlaySound("milleniumfox/characters/wharang/collect_souls")
			local fx1 = SpawnPrefab("wathgrithr_spirit")
			fx1.Transform:SetPosition(inst.Transform:GetWorldPosition());fx1.Transform:SetScale(.8,.8,.8)
			local fx2 = SpawnPrefab("petrified_trunk_break_fx")
			fx2.Transform:SetPosition(inst.Transform:GetWorldPosition());fx2.Transform:SetScale(1.2,1.2,1.2)
			local fx3 = SpawnPrefab("wharang_attunefx")
			fx3.Transform:SetPosition(inst.Transform:GetWorldPosition())
		end
	end

    local hunger_percent = inst.components.hunger:GetPercent()
    local health_percent = inst.components.health:GetPercent()
    local sanity_percent = inst.components.sanity:GetPercent()
	
	inst.components.health.maxhealth = math.ceil (TUNING.WHARANG_HEALTH + inst.soulheart * 0.4)		--285
	inst.components.hunger.max = math.ceil (TUNING.WHARANG_HUNGER + inst.soulheart * 0.2)			--285
	inst.components.sanity.max = math.ceil (TUNING.WHARANG_SANITY + inst.soulheart * 0.2)			--300

    inst.components.hunger:SetPercent(hunger_percent)
    inst.components.health:SetPercent(health_percent)
    inst.components.sanity:SetPercent(sanity_percent)
end

local function IsValidVictim(victim)
    return victim ~= nil
        and not ((victim:HasTag("prey") and not victim:HasTag("hostile")) or
                victim:HasTag("veggie") or
                victim:HasTag("structure") or
                victim:HasTag("wall") or
                victim:HasTag("companion") or
				victim:HasTag("birchnutdrake") or
				victim:HasTag("shadow") or
				victim:HasTag("insect") or
				victim:HasTag("ghost"))
        and victim.components.health ~= nil
        and victim.components.combat ~= nil
end

local function SoulHeart_OnKill(inst, data)
    local victim = data.victim
    if IsValidVictim(victim) then
		inst.soulspirit = inst.soulspirit + 1
		SoulHeart_Collect(inst)
	end
end


local function Wharang_OnEat(inst, food)
local prank_1 = 3/100
local prank_2 = 5/100
local prank_3 = 4/100
local prank_4 = 2/100
local prank_5 = 1/100

	if food and food.components.edible.foodtype == "MEAT" then
		if inst.soulheart >= 100 then if math.random() < prank_1 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random(-4,4);pos.x = pos.x + math.random(-4,4)
			local item = {"canary","crow","feather_crow","feather_robin","feather_robin_winter","feather_canary","spider","fish","froglegs","rabbit","bee","eel","butterfly","pigskin","tentaclespots","stinger","bird_egg","mosquito"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab(randomitem).Transform:SetPosition(pos:Get());SpawnPrefab("collapse_small").Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= 200 then if math.random() < prank_2 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random(-4,4);pos.x = pos.x + math.random(-4,4)
			local item = {"rope","cutstone","boards","papyrus","charcoal","ash","twigs","rocks","cutgrass","cutreeds","log","nitre","boneshard","moonrocknugget","ice","acorn","marble","cutlichen","foliage","succulent_picked"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab(randomitem).Transform:SetPosition(pos:Get());SpawnPrefab("collapse_small").Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= 300 then if math.random() < prank_3 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random(-4,4);pos.x = pos.x + math.random(-4,4)
			local item = {"silk","beefalowool","horn","manrabbit_tail","beardhair","slurper_pelt","slurtleslime","honeycomb","steelwool","lightninggoathorn","furtuft","goatmilk","glommerfuel","glommerwings","coontail"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab(randomitem).Transform:SetPosition(pos:Get());SpawnPrefab("collapse_small").Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= 400 then if math.random() < prank_4 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random(-4,4);pos.x = pos.x + math.random(-4,4)
			local item = {"spoiled_food","wetgoop","powcake","monsterlasagna","meatballs","honeyham","taffy","unagi","honey","wharang_dango","wharang_flamefruit","wormlight","lightbulb"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab(randomitem).Transform:SetPosition(pos:Get());SpawnPrefab("collapse_small").Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= 500 then if math.random() < prank_5 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random(-4,4);pos.x = pos.x + math.random(-4,4)
			local item = {"gears","petals_evil","nightmarefuel","goldnugget","thulecite","thulecite_pieces","redgem","bluegem","yellowgem","opalpreciousgem","royal_jelly"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab(randomitem).Transform:SetPosition(pos:Get());SpawnPrefab("collapse_small").Transform:SetPosition(pos:Get()) end
		end
	end
end


local function Wharang_MonsterAttackAura(target)
	if (target:HasTag("monster") and not target:HasTag("shadowcreature")) then
		return true
	end
	return false
end

local function Wharang_EvilAura(inst, dt)
if not inst:HasTag("playerghost") then
	if inst:HasTag("wharang_fullmoon") then
		local pos = Vector3(inst.Transform:GetWorldPosition());pos.y = pos.y + .2
		local fx = SpawnPrefab("wharang_aurafx")
		fx.Transform:SetPosition(pos:Get())
		fx.Transform:SetScale(.3,.3,.3)
		
		local auraRange = 2
		local hits = inst.components.combat:DoAreaAttack(inst, auraRange, inst, Wharang_MonsterAttackAura)
	end
end
end

local function Wharang_Foxfire(inst, data)
		if data.attacker and data.attacker.components.burnable and data.attacker.components.health and not data.attacker:HasTag("thorny") then
			data.attacker.components.burnable:Ignite()
			SpawnPrefab("wharang_foxfire").Transform:SetPosition(data.attacker.Transform:GetWorldPosition())
		if data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then data.attacker.components.burnable:Extinguish() end
	end
end

local function Wharang_Regen(inst)
	if not inst:HasTag("playerghost") then
		if inst.components.health:GetPercent() <= .3 and inst.components.hunger:GetPercent() <= .6 then
			inst.components.health:DoDelta(1)
		end
	end
end

local function Wharang_Stats(inst)
	if not inst:HasTag("playerghost") then

	inst.components.locomotor.walkspeed = (8)
	inst.components.locomotor.runspeed = (10)

		if (TheWorld.state.isnight and TheWorld.state.isfullmoon) then
			inst.AnimState:SetBuild("wharang_white")
			inst:AddTag("wharang_fullmoon")
			inst.components.eater:SetDiet({ FOODGROUP.OMNI }, { FOODTYPE.MEAT, FOODTYPE.GOODIES })
			inst.components.combat.damagemultiplier = 1
			inst.components.health.absorb = .2
		elseif TheWorld.state.iswinter then
			inst.AnimState:SetBuild("wharang_white")
			inst:RemoveTag("wharang_fullmoon")
			inst.components.eater:SetDiet({ FOODGROUP.OMNI }, { FOODGROUP.OMNI })
			inst.components.combat.damagemultiplier = .8
			inst.components.health.absorb = .2
		else
			inst.AnimState:SetBuild("wharang")
			inst:RemoveTag("wharang_fullmoon")
			inst.components.eater:SetDiet({ FOODGROUP.OMNI }, { FOODGROUP.OMNI })
			inst.components.combat.damagemultiplier = .8
			inst.components.health.absorb = 0
		end
	end
end

local function Wharang_HungerFire(inst, data)
	if not inst:HasTag("playerghost") then
	local Light = inst.entity:AddLight()

		if (TheWorld.state.isnight or TheWorld:HasTag("cave")) and not TheWorld.state.isfullmoon then
				if inst.components.hunger:GetPercent() <= .8 then
					Light:Enable(false)
					inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
				elseif inst.components.hunger:GetPercent() > .8 then
					inst.entity:AddLight()
					inst.Light:SetRadius(1.0)
					inst.Light:SetFalloff(.7)
					inst.Light:SetIntensity(.5)
					inst.Light:SetColour(255/255,20/255,20/255)
					inst.Light:Enable(true)
					inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.2)
				end
		else
			Light:Enable(false)
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
		end
	end
end

local function IsFan(item)
    return (item.prefab == "wharang_fan1" or item.prefab == "wharang_fan2")
end

local function find_wharangfan(inst, data)
	if (inst.components.inventory:FindItem(IsFan) ~= nil) or inst:HasTag("usefan") then
	--no
	else
		local wharangfan = SpawnPrefab("wharang_fan1")				
		local pos = Vector3(inst.Transform:GetWorldPosition());pos.y = pos.y + 3
		wharangfan.Transform:SetPosition(pos:Get())
			
		local fx = SpawnPrefab("lucy_transform_fx")
		fx.Transform:SetPosition(pos:Get())
	end
end

local function onbecamehuman(inst)
	inst.Transform:SetScale(.7,.7,.7)
	Wharang_Stats(inst)
end

local function onbecameghost(inst)
	inst.Transform:SetScale(1,1,1)
	inst.components.locomotor.walkspeed = (4.5)
	inst.components.locomotor.runspeed = (6.5)
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local function onpreload(inst, data)
	if data ~= nil then
		if data.soulheart then
			inst.soulheart = data.soulheart
			SoulHeart_Collect(inst)
			
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
		if data.soulspirit then
			inst.soulspirit = data.soulspirit
			SoulHeart_Collect(inst)
		end
	end
end

local function onsave(inst, data)
	data.soulheart = inst.soulheart
	data.soulspirit = inst.soulspirit
end

local function ondeath(inst)
	if inst.soulheart > 0 then
		inst.soulheart = inst.soulheart - 5
		SoulHeart_Collect(inst)
	end
	if inst.soulspirit > 0 then
		inst.soulspirit = inst.soulspirit - 100
		SoulHeart_Collect(inst)
	end
end

local common_postinit = function(inst)
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst:AddTag("wharang")
	
	inst.soulheart = 0
	inst.soulspirit = 0
	
	inst:AddComponent("beard")
	inst.wharangfur = inst.components.beard.bits
	
	--save
    inst.entity:AddLight()
	inst.Light:SetRadius(1.0)
	inst.Light:SetFalloff(.7)
	inst.Light:SetIntensity(.5)
	inst.Light:SetColour(255/255,20/255,20/255)
	
	inst:AddComponent("sanityaura")
	inst.components.sanityaura.aura = TUNING.SANITYAURA_SMALL_TINY
end

local master_postinit = function(inst)
	
	inst.soundsname = "wharang"
	inst.Transform:SetScale(.7,.7,.7)
	
	inst.soulheart = 0
	inst.soulspirit = 0
	SoulHeart_Collect(inst)
	
	inst:DoPeriodicTask(0, function()
		if not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD) then
			inst.AnimState:OverrideSymbol("swap_hat", "wharang_swap_sakurahat", "swap_hat")
			inst.AnimState:Show("HAT")
		end
	end)
	inst:ListenForEvent("unequip", function(inst, data)
		if not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD) then
			inst.AnimState:OverrideSymbol("swap_hat", "wharang_swap_sakurahat", "swap_hat")
			inst.AnimState:Show("HAT")
		end
	end)
	
	inst.components.eater.EatMEAT = inst.components.eater.Eat
	inst.components.eater:SetOnEatFn(Wharang_OnEat)
	function inst.components.eater:Eat(food)
		if self:CanEat(food) then
			if food.prefab == "meat" or food.prefab == "smallmeat" or food.prefab == "fish" or food.prefab == "batwing" or food.prefab == "froglegs" or food.prefab == "plantmeat" then
					food.components.edible.sanityvalue = 0
			elseif food.prefab == "monstermeat" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -30
			elseif food.prefab == "cookedmonstermeat" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -20
			elseif food.prefab == "monstermeat_dried" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -15
			elseif food.prefab == "monsterlasagna" then
					food.components.edible.healthvalue = -10
					food.components.edible.sanityvalue = -40
			elseif food.prefab == "drumstick" then
					food.components.edible.healthvalue = 1
					food.components.edible.hungervalue = 15
					food.components.edible.sanityvalue = 0
			elseif food.prefab == "drumstick_cooked" then
					food.components.edible.healthvalue = 2
					food.components.edible.hungervalue = 15
					food.components.edible.sanityvalue = 2
			elseif food.prefab == "turkeydinner" then
					food.components.edible.healthvalue = 25
					food.components.edible.hungervalue = 80
					food.components.edible.sanityvalue = 10
			end
		end return inst.components.eater:EatMEAT(food)
	end
	
	inst.components.health.fire_damage_scale = 0
	inst.components.sanity.night_drain_mult = .5
	inst.components.sanity.neg_aura_mult = 2
	
	inst:DoPeriodicTask(60, Wharang_Regen)
	
	inst:WatchWorldState("isday", Wharang_Stats)
	inst:WatchWorldState("isdusk", Wharang_Stats)
	inst:WatchWorldState("isnight", Wharang_Stats)
	inst:WatchWorldState("iswinter", Wharang_Stats)
	inst:WatchWorldState("phase", Wharang_Stats)
	
	inst:DoPeriodicTask(0, Wharang_Stats)
	
	Wharang_Stats(inst)
	
	inst:WatchWorldState("phase", Wharang_HungerFire)
	inst:ListenForEvent("hungerdelta", Wharang_HungerFire)
	
	inst:ListenForEvent("killed", SoulHeart_OnKill)
	inst:ListenForEvent("death", ondeath)
	
	inst:ListenForEvent("attacked", Wharang_Foxfire)
	
	inst:ListenForEvent("find_wharangfan", find_wharangfan)
	
	
	-- Stats	
	inst.components.health:SetMaxHealth(TUNING.WHARANG_HEALTH)
	inst.components.hunger:SetMax(TUNING.WHARANG_HUNGER)
	inst.components.sanity:SetMax(TUNING.WHARANG_SANITY)
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(4)
    inst.updateTask = inst:DoPeriodicTask(1, Wharang_EvilAura, nil, 1)
	
	inst.components.temperature.hurtrate = 0.5
	inst.components.temperature.inherentinsulation = 30
	
	inst:AddComponent("beard")
	inst.components.beard.prize = "wharang_fur"
	inst.wharangfur = inst.components.beard.bits

	local fur_days = {3, 6, 9, 12, 15, 18, 21, 24, 27}
	local fur_bits = {1, 2, 3, 4, 5, 6, 7, 8, 9}

	inst.components.beard:AddCallback(fur_days[1], function()
		inst.components.beard.bits = fur_bits[1]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[2], function()
		inst.components.beard.bits = fur_bits[2]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[3], function()
		inst.components.beard.bits = fur_bits[3]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[4], function()
		inst.components.beard.bits = fur_bits[4]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[5], function()
		inst.components.beard.bits = fur_bits[5]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[6], function()
		inst.components.beard.bits = fur_bits[6]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[7], function()
		inst.components.beard.bits = fur_bits[7]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[8], function()
		inst.components.beard.bits = fur_bits[8]
		inst.wharangfur = inst.components.beard.bits

	end)
	inst.components.beard:AddCallback(fur_days[9], function()
		inst.components.beard.bits = fur_bits[9]
		inst.wharangfur = inst.components.beard.bits

	end)
	
	inst:ListenForEvent("shaved", function() inst.wharangfur = inst.components.beard.bits end)
	inst:DoPeriodicTask(1, function() inst.wharangfur = inst.components.beard.bits end)
	
	local function Equip(inst)
		local head = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
		if head then
			inst.AnimState:Show("HEAD")
			inst.AnimState:Hide("HEAD_HAT")
		end
		if not head then
			inst.AnimState:Hide("HAT_HAIR")
		end
	end

	inst:ListenForEvent("equip", Equip)

	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	inst.OnPreLoad = onpreload
	inst.OnSave = onsave
	
end

return MakePlayerCharacter("wharang", prefabs, assets, common_postinit, master_postinit, start_inv)
