local assets=
{
    Asset("ANIM", "anim/wharang_fan1.zip"),
    Asset("ANIM", "anim/wharang_swap_fan1.zip"),
    Asset("ATLAS", "images/inventoryimages/wharang_fan1.xml"),
}

local prefabs = {}

local function IsValidOwner(inst, owner)
    return owner:HasTag("wharang")
end

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_handfan", "swap_handfan")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
	owner:AddTag("usefan")

    if inst.remove_task then
		inst.remove_task:Cancel()
		inst.remove_task = nil
	end
end
 
local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
	owner:RemoveTag("usefan")
	
    if inst.remove_task then
		inst.remove_task:Cancel()
		inst.remove_task = nil
	end
end

local function IsFan(item)
    return (item.prefab == "wharang_fan1" or item.prefab == "wharang_fan2")
end

local function OnFanDrop(inst, owner)
    if inst.remove_task then
		inst.remove_task:Cancel()
		inst.remove_task = nil
	end

	if not IsValidOwner(inst, owner) then
		owner:DoTaskInTime(0, function()
			if owner.components.inventory then
				owner.components.inventory:DropItem(inst, nil, true)
			elseif owner.components.container then
				owner.components.container:DropItem(inst)
			else inst:Drop()
			end
		end)
	end
	
	if owner:HasTag("usefan") then
		owner:DoTaskInTime(0, function()
			if owner.components.inventory then
				owner.components.inventory:DropItem(inst, nil, true)
			elseif owner.components.container then
				owner.components.container:DropItem(inst)
			else inst:Drop()
			end
		end)
	end

	if owner.components.inventory and owner.components.inventory:FindItem(IsFan) then
		owner:DoTaskInTime(0, function()
			if owner.components.inventory then
				owner.components.inventory:DropItem(inst, nil, true)
			elseif owner.components.container then
				owner.components.container:DropItem(inst)
			else inst:Drop()
			end
		end)
	end
	
end

local function OnDisappear(inst, owner)
	inst:Remove()
	local fx1 = SpawnPrefab("lucy_transform_fx")
	fx1.Transform:SetPosition(inst.Transform:GetWorldPosition())
end


local function fn()
    local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()
	
	inst.MiniMapEntity:SetIcon("wharang_fan1.tex")
	
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("handfan")
    inst.AnimState:SetBuild("handfan")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("wharangfan")
	
	inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(30)
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wharang_fan1.xml"
	inst.components.inventoryitem.onpickupfn = OnFanDrop
	inst.components.inventoryitem.onputininventoryfn = OnFanDrop

	inst:ListenForEvent("animover", function() inst.remove_task = inst:DoPeriodicTask(TUNING.WHARANG_FAN_REMOVETIME, OnDisappear) end)
	
	MakeHauntableLaunch(inst)
 
    return inst
end

return Prefab("common/inventory/wharang_fan1", fn, assets)