local assets=
{
    Asset("ANIM", "anim/wharang_fan2.zip"),
    Asset("ANIM", "anim/wharang_swap_fan2.zip"),
    Asset("ATLAS", "images/inventoryimages/wharang_fan2.xml"),
}

local prefabs = {}

local function onfinished(inst)
local fan1 = SpawnPrefab("wharang_fan1")
	if fan1 then
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner or nil
		local pt = Vector3(inst.Transform:GetWorldPosition())
		local holder = owner and ( owner.components.inventory or owner.components.container) 
		local slot = holder and holder:GetItemSlot(inst)			
		inst:Remove()
			if holder then
				holder:Equip(fan1, slot)
			else
				fan1.Transform:SetPosition(pt:Get())
			end
	end
end

local framechance = .3

local function onattack(inst, attacker, target)

	if math.random() < framechance and target.components.burnable and target.sg and not target.sg:HasStateTag("frozen") and not target:HasTag("wall") and not target:HasTag("structure") and target.sg.sg.states.hit then
			target.sg:GoToState("hit")
			target.components.burnable:Ignite()
	end
	if target.components.burnable and target.components.burnable:IsBurning() then
			target.components.burnable:Extinguish()
	end
	if target.components.combat then
			target.components.combat:SuggestTarget(attacker)
	end
	if target.components.sleeper and target.components.sleeper:IsAsleep() then
			target.components.sleeper:WakeUp()
	end
	if target.components.freezable then
			target.components.freezable:AddColdness(-1)
			
		if target.components.freezable:IsFrozen() then
				target.components.freezable:Unfreeze()            
		end
	end
end

local function IsValidOwner(inst, owner)
    return owner:HasTag("wharang")
end

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_gumifan", "swap_gumifan")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
	owner:AddTag("usefan")

    if inst.remove_task then
		inst.remove_task:Cancel()
		inst.remove_task = nil
	end
end
 
local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
	owner:RemoveTag("usefan")
	
    if inst.remove_task then
		inst.remove_task:Cancel()
		inst.remove_task = nil
	end
end

local function IsFan(item)
    return (item.prefab == "wharang_fan1" or item.prefab == "wharang_fan2")
end

local function OnFanDrop(inst, owner)
    if inst.remove_task then
		inst.remove_task:Cancel()
		inst.remove_task = nil
	end

	if not IsValidOwner(inst, owner) then
		owner:DoTaskInTime(0, function()
			if owner.components.inventory then
				owner.components.inventory:DropItem(inst, nil, true)
			elseif owner.components.container then
				owner.components.container:DropItem(inst)
			else inst:Drop()
			end
		end)
	end
	
	if owner:HasTag("usefan") then
		owner:DoTaskInTime(0, function()
			if owner.components.inventory then
				owner.components.inventory:DropItem(inst, nil, true)
			elseif owner.components.container then
				owner.components.container:DropItem(inst)
			else inst:Drop()
			end
		end)
	end

	if owner.components.inventory and owner.components.inventory:FindItem(IsFan) then
		owner:DoTaskInTime(0, function()
			if owner.components.inventory then
				owner.components.inventory:DropItem(inst, nil, true)
			elseif owner.components.container then
				owner.components.container:DropItem(inst)
			else inst:Drop()
			end
		end)
	end
	
end

local function OnDisappear(inst, owner)
	inst:Remove()
	local fx1 = SpawnPrefab("lucy_transform_fx")
	fx1.Transform:SetPosition(inst.Transform:GetWorldPosition())
end


local function fn()
    local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()
	
	inst.MiniMapEntity:SetIcon("wharang_fan2.tex")
	
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("gumifan")
    inst.AnimState:SetBuild("gumifan")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("wharangfan")
	
	inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack)
	inst.components.weapon:SetDamage(55)
	inst.components.weapon:SetRange(2)
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)
    inst.components.finiteuses:SetOnFinished(onfinished)
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wharang_fan2.xml"
	inst.components.inventoryitem.onpickupfn = OnFanDrop
	inst.components.inventoryitem.onputininventoryfn = OnFanDrop

	inst:ListenForEvent("animover", function() inst.remove_task = inst:DoPeriodicTask(TUNING.WHARANG_FAN_REMOVETIME, OnDisappear) end)
	
	MakeHauntableLaunch(inst)
 
    return inst
end

return Prefab("common/inventory/wharang_fan2", fn, assets)