local assets=
{
    Asset("ANIM", "anim/wharang_foxhat.zip"),
	Asset("ANIM", "anim/wharang_swap_foxhat.zip"),
	Asset("ATLAS", "images/inventoryimages/wharang_foxhat.xml")
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function StopUsingMask(inst, data)
	local foxhat = inst.components.inventory ~= nil and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD) or nil
	if foxhat ~= nil and data.statename ~= "hide" then
		foxhat.components.armor:SetAbsorption(.6)
		foxhat.components.useableitem:StopUsingItem()
    else
		foxhat.components.armor:SetAbsorption(1)
    end
end

local function OnEquipMaks(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "wharang_swap_foxhat", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	inst:ListenForEvent("blocked", OnBlocked, owner)
	inst:ListenForEvent("newstate", StopUsingMask, owner) 
end
	
local function OnUnequipMak(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	inst:RemoveEventCallback("blocked", OnBlocked, owner)
	inst:RemoveEventCallback("newstate", StopUsingMask, owner)
end
	
 local function OnUseMask(inst)
	local owner = inst.components.inventoryitem.owner
	if owner then
		owner.sg:GoToState("hide")
	end
end

local function fn(Sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("wharang_foxhat")
	inst.AnimState:SetBuild("wharang_foxhat")
	inst.AnimState:PlayAnimation("anim")
	
	inst:AddTag("hat")
	
	inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
        return inst
    end

	inst:AddComponent("inspectable")

	inst:AddComponent("tradable")

	inst:AddComponent("armor")
	inst.components.armor:InitCondition(1500, 0)

	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

	inst:AddComponent("useableitem")
	inst.components.useableitem:SetOnUseFn(OnUseMask)
	inst.components.equippable:SetOnEquip(OnEquipMaks)
	inst.components.equippable:SetOnUnequip(OnUnequipMak)

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/wharang_foxhat.xml"
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/bushhat"

	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(.1)
  
    return inst
end

return Prefab( "common/inventory/wharang_foxhat", fn, assets ) 