local assets_fire=
{
	Asset("ANIM", "anim/wharang_ground_fire_fx.zip"),
}

local assets_attune=
{
	Asset("ANIM", "anim/attune_fx.zip"),
}

local function fn_fire(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.entity:SetCanSleep(false)
	
    inst.AnimState:SetBank("dragonfly_ground_fx")
    inst.AnimState:SetBuild("wharang_ground_fire_fx")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:PlayAnimation("idle")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

local function fn_attune(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.entity:SetCanSleep(false)
	
    inst.AnimState:SetBank("attune_fx")
    inst.AnimState:SetBuild("attune_fx")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:PlayAnimation("attune_out")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

local function fn_aura(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.entity:SetCanSleep(false)

    inst.AnimState:SetBank("die_fx")
    inst.AnimState:SetBuild("die")
	inst.AnimState:SetMultColour(0,0,0,0.5)
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:PlayAnimation("small")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

return Prefab("fx/wharang_firefx", fn_fire, assets_fire),
Prefab("fx/wharang_attunefx", fn_attune, assets_attune),
Prefab("fx/wharang_aurafx", fn_aura, assets_attune)