require "prefabutil"
require "brains/mushasmallbrain"
local brain = require "brains/mushasmallbrain"

local WAKE_TO_FOLLOW_DISTANCE = 5
local SLEEP_NEAR_LEADER_DISTANCE = 2
local CRY_NEAR_LEADER_DISTANCE = 15

local assets =
{
	Asset("ANIM", "anim/musha_small.zip"),
    	Asset("ANIM", "anim/hat_yamche.zip"),
	Asset("ATLAS", "images/inventoryimages/musha_small.xml"),
	Asset("IMAGE", "images/inventoryimages/musha_small.tex"),

}

local prefabs=
{
"hat_yamche",
    "musha_small",
    "musha_teen",
    "musha_tall",
    "musha_tall2",
    "musha_tall3",
    "musha_tall4",
    "musha_tall5",
    "musha_rp1",
    "musha_rp2",
    "musha_rp3",
    "musha_rp4",
    "musha_rp5",
    "musha_rp6",
--	"willowfire",
    "poop",
    "campfirefire",
}

local teen_assets =
{
	Asset("ANIM", "anim/musha_teen.zip"),
	Asset("ATLAS", "images/inventoryimages/musha_teen.xml"),
}

local tall_assets =
{
	Asset("ANIM", "anim/musha_tall.zip"),
	Asset("ATLAS", "images/inventoryimages/musha_tall.xml"),
}

local tall2_assets =
{
	Asset("ANIM", "anim/musha_tall2.zip"),
}
local tall3_assets =
{
	Asset("ANIM", "anim/musha_tall3.zip"),
}
local tall4_assets =
{
	Asset("ANIM", "anim/musha_tall4.zip"),
}
local tall5_assets =
{
	Asset("ANIM", "anim/musha_tall5.zip"),
}
local rp1_assets =
{
	Asset("ANIM", "anim/musha_small.zip"),
}
local rp2_assets =
{
	Asset("ANIM", "anim/musha_teen.zip"),
}
local rp3_assets =
{
	Asset("ANIM", "anim/musha_tall.zip"),
}
local rp4_assets =
{
	Asset("ANIM", "anim/musha_tall2.zip"),
}
local rp5_assets =
{
	Asset("ANIM", "anim/musha_tall3.zip"),
}
local rp6_assets =
{
	Asset("ANIM", "anim/musha_tall3.zip"),
}
local ice_assets =
{
	Asset("ANIM", "anim/musha_ice.zip"),
}

--[[
ACTIONS.MURDER.fn = function(act)
    local murdered = act.invobject or act.target
    if murdered and murdered.components.health and not murdered:HasTag("baby") then
                
        murdered.components.inventoryitem:RemoveFromOwner(true)

        if murdered.components.health.murdersound then
            act.doer.SoundEmitter:PlaySound(murdered.components.health.murdersound)
        end

        local stacksize = 1
        if murdered.components.stackable then
            stacksize = murdered.components.stackable.stacksize
        end

        if murdered.components.lootdropper then
            for i = 1, stacksize do
                local loots = murdered.components.lootdropper:GenerateLoot()
                for k, v in pairs(loots) do
                    local loot = SpawnPrefab(v)
                    act.doer.components.inventory:GiveItem(loot)
                end      
            end
        end
        act.doer:PushEvent("killed", {victim = murdered})
        murdered:Remove()

        return true
    end
end
]]--

----------------
local function die(inst)
inst:AddTag("ndead")
	inst.components.health:Kill()
end
------------------
--------------

local function makeused2(inst)
	inst.AnimState:PlayAnimation("debris")
end

local function doresurrect2(inst, dude)
    dude.entity:AddLight()
	dude.Light:SetRadius(3)
    dude.Light:SetFalloff(10)
    dude.Light:SetIntensity(.5)
    dude.Light:SetColour(15/255,165/255,165/255)
	dude.Light:Enable(true)

	inst:AddTag("busy")	
	inst.persists = false
    if inst.Physics then
		RemovePhysicsColliders(inst)
    end
    --dude:Hide()
    if dude.HUD then
        dude.HUD:Hide()
    end
    if dude.components.playercontroller then
        dude.components.playercontroller:Enable(false)
    end

    inst:RemoveComponent("inspectable")
    dude:ClearBufferedAction()
------
    scheduler:ExecuteInTime(2, function()
        dude:Show()

inst.AnimState:PlayAnimation("debris")
-------
        dude.sg:GoToState("amulet_rebirth")
        dude:DoTaskInTime(4, function() 

            if dude.HUD then
                dude.HUD:Show()
            end
            if dude.components.health then
				dude.components.health:RecalculatePenalty()
                dude.components.health:Respawn(100)
                dude.components.health:SetInvincible(true)
            end
          if dude.components.sanity then
			    dude.components.sanity:SetPercent(.7)
            end
          if dude.components.hunger then
                dude.components.hunger:SetPercent(.7)
            end
        if dude.components.playercontroller then
                dude.components.playercontroller:Enable(true)
            end
            inst:RemoveTag("busy")
            dude.components.health:SetInvincible(false)
	dude.Light:Enable(false)

 end)
	inst:Show()

 end)

	if inst.components.container then
	inst.components.container:DropEverything() 
end
inst.components.health:Kill() 
    inst:Remove()
            end
----------------
---------------------------
local function levelexp(inst,data)

	local max_exp = 999999999999999993000
	local exp = math.min(inst.level, max_exp)
	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()

if inst:HasTag("level8") then
	inst.components.hunger.max = math.ceil (130 + exp* 1)
	inst.components.health.maxhealth = math.ceil (2000 + exp* 1)
end

inst.components.talker:Say("[EXP] ".. (inst.level))
	if inst.level <1 and not inst:HasTag("level8") then
    		--inst.components.growable:StopGrowing()
	--inst.components.talker:Say("[EXP] ".. (inst.level))
inst.components.talker:Say("[Next : Level Up] \n EXP ".. (inst.level))

elseif inst.level >0 and inst.level <1 and inst:HasTag("level1") and not inst:HasTag("baby") then
inst.components.talker:Say(" һ : EXP [1]\n[EXP] ".. (inst.level))
	elseif inst.level >0 and inst:HasTag("level1") and not inst:HasTag("baby") then
    		inst.components.growable:StartGrowing()
	inst.components.talker:Say("[]")
elseif inst.level >0 and inst.level <19 and inst:HasTag("level2") then
inst.components.talker:Say(" һ : EXP [20]\n[EXP] ".. (inst.level))
	elseif inst.level >19 and inst:HasTag("level2") then
    		inst.components.growable:StartGrowing()
	inst.components.talker:Say("[]")
elseif inst.level >0 and inst.level <49 and inst:HasTag("level3") then
inst.components.talker:Say(" һ : EXP [50]\n[EXP] ".. (inst.level))
	elseif inst.level >49 and inst:HasTag("level3") then
    		inst.components.growable:StartGrowing()
	inst.components.talker:Say("[]")
elseif inst.level >0 and inst.level <99 and inst:HasTag("level4") then
inst.components.talker:Say(" һ : EXP [100]\n[EXP] ".. (inst.level))
	elseif inst.level >99 and inst:HasTag("level4") then
    		inst.components.growable:StartGrowing()
	inst.components.talker:Say("[]")
elseif inst.level >0 and inst.level <299 and inst:HasTag("level5") then
inst.components.talker:Say(" һ : EXP [300]\n[EXP] ".. (inst.level))
	elseif inst.level >299 and inst:HasTag("level5") then
    		inst.components.growable:StartGrowing()
	inst.components.talker:Say("[]")
elseif inst.level >0 and inst.level <399 and inst:HasTag("level6") then
inst.components.talker:Say(" һ : EXP [400]\n[EXP] ".. (inst.level))
	elseif inst.level >399 and inst:HasTag("level6") then
    		inst.components.growable:StartGrowing()
	inst.components.talker:Say("[]")
elseif inst.level >0 and inst.level <499 and inst:HasTag("level7") then
inst.components.talker:Say(" һ : EXP [500]\n[EXP] ".. (inst.level))
	elseif inst.level >499 and inst:HasTag("level7") then
    		inst.components.growable:StartGrowing()
	inst.components.talker:Say("[]")
elseif inst:HasTag("level8") then
inst.components.talker:Say("[EXP] ".. (inst.level))
	--inst:AddTag("cure1")

	end
	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	end

local exp1x = 0.1
local exp2x = 0.4
local exp3x = 0.6
local exp4x = 0.7
local normalchance = .75
local largechance = 1
local smallllchance = 0.4

local function onkilll(inst, data)
	if data.cause == inst.prefab and not data.inst:HasTag("companion") then
	if math.random() < largechance and not data.inst:HasTag("prey") and not data.inst:HasTag("eyeplant") and not data.inst:HasTag("giant1x") and not data.inst:HasTag("giant2x") and not data.inst:HasTag("giant3x") and not data.inst:HasTag("giant4x") and not data.inst:HasTag("small_giant2x") and not data.inst:HasTag("small_giant3x") and not data.inst:HasTag("small_giant4x") then

    				inst.level = inst.level + 1
	levelexp(inst)

	elseif math.random() < smallllchance and data.inst:HasTag("eyeplant") then
    				inst.level = inst.level + 1
	levelexp(inst)

	elseif math.random() < smallllchance and data.inst:HasTag("arm") then
    				inst.level = inst.level + 1
	levelexp(inst)

------extra
	elseif math.random() < exp1x and data.inst:HasTag("spider1x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	elseif math.random() < exp1x and data.inst:HasTag("hound1x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())

	elseif math.random() < exp2x and data.inst:HasTag("spider2x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	elseif math.random() < exp3x and data.inst:HasTag("spider3x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	elseif math.random() < exp4x and data.inst:HasTag("spider4x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	elseif math.random() < exp2x and data.inst:HasTag("hound2x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	elseif math.random() < exp3x and data.inst:HasTag("hound3x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	elseif math.random() < exp4x and data.inst:HasTag("hound4x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())

	elseif data.inst:HasTag("giant1x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
	local fx3 = SpawnPrefab("glowdust")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx3.Transform:SetPosition(data.inst:GetPosition():Get())
    				inst.level = inst.level + 10
	--levelexp(inst)
	inst.components.talker:Say("  [EXP](+10) \n".. (inst.level))

	elseif data.inst:HasTag("giant2x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
	local fx3 = SpawnPrefab("glowdust")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx3.Transform:SetPosition(data.inst:GetPosition():Get())
    				inst.level = inst.level + 20
	--levelexp(inst)
	inst.components.talker:Say("  [EXP](+20) \n".. (inst.level))

	elseif data.inst:HasTag("giant3x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	local fx3 = SpawnPrefab("glowdust")
        		fx3.Transform:SetPosition(data.inst:GetPosition():Get())
    				inst.level = inst.level + 30
	--levelexp(inst)
	inst.components.talker:Say("  [EXP](+30) \n".. (inst.level))

	elseif data.inst:HasTag("giant4x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	local fx3 = SpawnPrefab("glowdust")
        		fx3.Transform:SetPosition(data.inst:GetPosition():Get())
    				inst.level = inst.level + 40
	--levelexp(inst)
	inst.components.talker:Say("  [EXP](+40) \n".. (inst.level))

	elseif data.inst:HasTag("small_giant2x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	local fx3 = SpawnPrefab("glowdust")
        		fx3.Transform:SetPosition(data.inst:GetPosition():Get())
    				inst.level = inst.level + 5
	--levelexp(inst)
	inst.components.talker:Say("  [EXP](+4) \n".. (inst.level))

	elseif data.inst:HasTag("small_giant3x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	local fx3 = SpawnPrefab("glowdust")
        		fx3.Transform:SetPosition(data.inst:GetPosition():Get())
    				inst.level = inst.level + 8
	--levelexp(inst)
	inst.components.talker:Say("  [EXP](+8) \n".. (inst.level))
	elseif data.inst:HasTag("small_giant4x") then
	local fx = SpawnPrefab("statue_transition")
	local fx2 = SpawnPrefab("exp")
        		fx.Transform:SetPosition(data.inst:GetPosition():Get())
        		fx2.Transform:SetPosition(data.inst:GetPosition():Get())
	local fx3 = SpawnPrefab("glowdust")
        		fx3.Transform:SetPosition(data.inst:GetPosition():Get())
    				inst.level = inst.level + 12
	--levelexp(inst)
	inst.components.talker:Say("  [EXP](+12) \n".. (inst.level))

    			 end
		          end
			end

--[[
local function onpreload(inst, data)
	if data then
		if data.level then
		inst.level = data.level
			levelexp(inst)
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)

end

	end
		end
]]


local function onpreload(inst, data)
	if data then
		if data.level then
		inst.level = data.level
			levelexp(inst)
end
	end
		end

local function onsave(inst, data)
	data.level = inst.level
end

------------

    local function cure1_proc(inst, data)
local player = GetPlayer()

	if inst.components.hunger.current > 20 then
        inst.components.health:DoDelta(300)
        player.components.health:DoDelta(150)
        inst.components.hunger:DoDelta(-20)
        local fx = SpawnPrefab("sparklefx")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1.3, 1.3, 1.3)
        fx.Transform:SetPosition(0, -0.2, 0)
        local fx_hitanim = function()
            fx.AnimState:PlayAnimation("hit")
            fx.AnimState:PushAnimation("idle_loop")
        end
        fx:ListenForEvent("blocked", fx_hitanim, inst)
        inst.active = true
        inst:DoTaskInTime(--[[Duration]] 5, function()
            fx:RemoveEventCallback("blocked", fx_hitanim, inst)
            if inst:IsValid() then
                inst:DoTaskInTime(--[[Cooldown]] 1800, function() inst.active = false 			end)
            end
        end)
    end
end
    local function cure2_proc(inst, data)
local player = GetPlayer()

	if inst.components.hunger.current > 20 then
        inst.components.health:DoDelta(300)
        player.components.health:DoDelta(150)
        inst.components.hunger:DoDelta(-20)
        local fx = SpawnPrefab("sparklefx")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1.3, 1.3, 1.3)
        fx.Transform:SetPosition(0, -0.2, 0)
        local fx_hitanim = function()
            fx.AnimState:PlayAnimation("hit")
            fx.AnimState:PushAnimation("idle_loop")
        end
        fx:ListenForEvent("blocked", fx_hitanim, inst)
        inst.active = true
        inst:DoTaskInTime(--[[Duration]] 5, function()
            fx:RemoveEventCallback("blocked", fx_hitanim, inst)
            if inst:IsValid() then
                inst:DoTaskInTime(--[[Cooldown]] 900, function() inst.active = false 			end)
            end
        end)
    end
end

------------

local function GetStatus(inst)
    --print("smallbird - GetStatus")
    if inst.components.hunger then
        if inst.components.hunger:IsStarving(inst) then
            --print("STARVING")
            return "STARVING"
        elseif inst.components.hunger:GetPercent() < .5 then
            --print("HUNGRY")
            return "HUNGRY"
        end
	end
end

------------

    local function heal_proc(inst, data)
	if not inst.components.health:IsDead() and inst.components.health:GetPercent() < .5  then
        inst:AddTag("forcefield")
        inst.components.health:DoDelta(10)
       -- inst.components.hunger:DoDelta(-1)
        local fx = SpawnPrefab("shock_fx2")
    inst.SoundEmitter:PlaySound("dontstarve/common/lightningrod")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 1, 1)
        fx.Transform:SetPosition(0, 0, 0)
        local fx_hitanim = function()
            fx.AnimState:PlayAnimation("hit")
            fx.AnimState:PushAnimation("idle_loop")
        end
        fx:ListenForEvent("blocked", fx_hitanim, inst)
        inst.active = true
        inst:DoTaskInTime(--[[Duration]] 1, function()
            fx:RemoveEventCallback("blocked", fx_hitanim, inst)
           -- fx.kill_fx(fx)
            if inst:IsValid() then
                inst:RemoveTag("forcefield")
                inst:DoTaskInTime(--[[Cooldown]] 3, function() inst.active = false end)
            end
        end)
    end
end

    local function tryproc(inst)
        if not inst.active and math.random() < 0.9 then
           heal_proc(inst)
		   end
 if inst.components.health:GetPercent() < .15  and inst:HasTag("cure1") then
           cure1_proc(inst)
 elseif inst.components.health:GetPercent() < .15  and inst:HasTag("cure2") then
           cure2_proc(inst)

        end
    end

------------------   
----------hat

local function OnPutInInventory(inst)
    inst.components.growable:StopGrowing()
   inst:AddTag("baby")
   inst:RemoveTag("level1")
    inst:RemoveTag("hat")
	inst:StopBrain()
end

local function OnDropped(inst,data)
   inst:AddTag("level1")
   inst:RemoveTag("baby")
   inst:RemoveTag("hat")
local drop = SpawnPrefab("musha_small")
drop.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    if inst.components.follower.leader then
        drop.components.follower:SetLeader(inst.components.follower.leader)
	drop.components.hunger:DoDelta(-15)

    end
            die(inst)
    inst:Remove()

end

    local function onyamche(inst, owner)
    inst.components.growable:StopGrowing()
    inst:AddTag("onyamche") 
    inst:RemoveTag("level1")
    inst:AddTag("baby")
    inst:AddTag("hat")
	inst:StopBrain()

     owner.AnimState:OverrideSymbol("swap_hat", "hat_yamche", "swap_hat")
        owner.AnimState:Show("HAT")
       -- owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

    end

    local function offyamche(inst, owner)

         owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

    end

 --[[
 local function onuseyamche(inst)
	inst.Light:Enable(true)
    end
 local function offuseyamche(inst)
    end
]]--
-------------

local function BattleCommand(inst, data)
local player = GetPlayer()

    if not inst.components.health:IsDead() and player:HasTag("fightn") then
 inst:AddTag("fightn") 
 inst:RemoveTag("command") 
inst.components.combat:GiveUp()

    elseif not inst.components.health:IsDead() and not player:HasTag("fightn") then
inst:RemoveTag("fightn") 
 inst:RemoveTag("command") 

end
    if player:HasTag("turns") and not inst:HasTag("command") 
then
 inst.sg:GoToState("command")
 inst:AddTag("command") 
 player:RemoveTag("turns") 
end
end

local function Checklevel(inst, data)
local player = GetPlayer()
    if player:HasTag("levelinfo") and inst:HasTag("level1") then
inst.components.talker:Say("  1\n һ  : [EXP] 1\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
    elseif player:HasTag("levelinfo") and inst:HasTag("level2") then
inst.components.talker:Say("  2\n һ  : [EXP] 20\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
    elseif player:HasTag("levelinfo") and inst:HasTag("level3") then
inst.components.talker:Say("  3\n һ  : [EXP] 50\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
    elseif player:HasTag("levelinfo") and inst:HasTag("level4") then
inst.components.talker:Say("  4\n һ  : [EXP] 100\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
    elseif player:HasTag("levelinfo") and inst:HasTag("level5") then
inst.components.talker:Say("  5\n һ  : [EXP] 300\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
    elseif player:HasTag("levelinfo") and inst:HasTag("level6") then
inst.components.talker:Say("  6\n һ  : [EXP] 400\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
    elseif player:HasTag("levelinfo") and inst:HasTag("level7") then
inst.components.talker:Say("  7\n һ  : [EXP] 500\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
    elseif player:HasTag("levelinfo") and inst:HasTag("level8") then
inst.components.talker:Say("  8\n[Max Level]\n ǰ [EXP] ".. (inst.level))
    player:RemoveTag("levelinfo") 
end
end

local function close(inst)
local player = GetPlayer()

player:AddTag("yamche") 
inst:AddTag("closea") 
inst:RemoveTag("fara") 
	inst.components.locomotor.walkspeed = 4
player.components.leader:AddFollower(inst)
inst.components.resurrector.active = true

    if player:HasTag("houndmound") then
 inst:AddTag("houndmound") 
    elseif not player:HasTag("houndmound") then
inst:RemoveTag("houndmound") 
    elseif player:HasTag("shadows") then
inst:AddTag("notarget") 
    elseif not player:HasTag("shadows") then
inst:RemoveTag("notarget") 

end
end

local function far(inst)
local player = GetPlayer()
player:RemoveTag("turns") 

player:RemoveTag("yamche") 
inst:RemoveTag("closea") 
inst:AddTag("fara") 
	inst.components.locomotor.walkspeed = 10
if inst:HasTag("animals") then
inst.components.resurrector.active = false
inst.components.follower:SetLeader(nil)
end
end

-----------------------
local function onignite(inst)
local player = GetPlayer()
inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,.1,0) )
inst.components.locomotor.walkspeed = 0
player.components.health.fire_damage_scale = 0

end

local function onextinguish(inst)
local player = GetPlayer()
    if inst.components.fueled then
        inst.components.fueled:InitializeFuelLevel(0)
    end
if not player:HasTag("Valkyrieh") then
player.components.health.fire_damage_scale = 1
end
end

local function OnOpen(inst)
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("open")
end
if inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
end
if inst.components.freezable:IsFrozen() then
        inst.components.freezable:Unfreeze()

    end
end 

local function OnClose(inst) 
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("close")
    end
end 

local slotpos_6 = {}

for y = 3, 0, -1 do
    for x = 0, 3 do
        table.insert(slotpos_6, Vector3(60*x-60*2+30, 60*y-60*2+30,0))
    end
end

local slotpos_5 = {}

for y = 3, 0, -1 do
    for x = 0, 2 do
        table.insert(slotpos_5, Vector3(75*x-75*2+75, 60*y-60*2+32,0))
    end
end

local slotpos_4 = {}

for y = 2, 0, -1 do
    for x = 0, 2 do
        table.insert(slotpos_4, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
    end
end

local slotpos_3 = {}

for y = 2, 0, -1 do
    for x = 0, 1 do
        table.insert(slotpos_3, Vector3(80*x-80*2+78, 80*y-80*2+80,0))
    end
end

local slotpos_2 = {}

for y = 1, 0, -1 do
    for x = 0, 1 do
        table.insert(slotpos_2, Vector3(80*x-80*2+78, 80*y-80*2+80,0))
    end
end

local slotpos_1 = {}

for y = 1, 0, -1 do
        table.insert(slotpos_1, Vector3(74*y-74*2+70, 0))

end


local function itemtest(inst, item, slot)
	--if not item:HasTag("tstone") then
	if not item:HasTag("nothing") then
			return true
end
end

local function PhoenixSanityAura(inst, observer)
	if inst.components.hunger:GetPercent() < .5 then
		return 0
	elseif inst.components.hunger:GetPercent() > .5 then
			return TUNING.SANITYAURA_TINY

	elseif inst.components.hunger:GetPercent() > .9 then
			return TUNING.SANITYAURA_SMALL
	end

	if inst.components.follower and inst.components.follower.leader == observer then
		--return TUNING.SANITYAURA_TINY
		return 0
	end
	
	return 0
end

local function ShouldWakeUp(inst)
    return DefaultWakeTest(inst) or inst.components.hunger:IsStarving(inst) or not inst.components.follower:IsNearLeader(WAKE_TO_FOLLOW_DISTANCE)
end

local function ShouldSleep(inst)
    return DefaultSleepTest(inst) and not inst.components.hunger:IsStarving(inst) and inst.components.follower:IsNearLeader(SLEEP_NEAR_LEADER_DISTANCE)
end

local function CanEatTest(inst, item)
    --print("smallbird - CanEatTest", inst.name, item.components.edible.foodtype, item, item.prefab)
    local canEat = (item.components.edible.foodtype == "SEEDS") or (item.prefab == "berries")
    --print("   canEat?", canEat)

	if not item:HasTag("spoiled") then
			return true

   -- return canEat
end
end

local function ShouldAcceptItem(inst, item)
    --print("smallbird - ShouldAcceptItem", inst.name, item.name)
    if item.components.edible and inst.components.hunger and inst.components.eater then
        return inst.components.eater:CanEat(item) and inst.components.hunger:GetPercent() <= 0.9
    end
end

local function OnGetItemFromPlayer(inst, giver, item)
    --print("smallbird - OnGetItemFromPlayer")

    if inst.components.sleeper then
        inst.components.sleeper:WakeUp()
    end

    --I eat food
    if item.components.edible then

        if inst.components.combat.target and inst.components.combat.target == giver then
            inst.components.combat:SetTarget(nil)
elseif giver.components.leader then
inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/scratch_ground")
giver.components.leader:AddFollower(inst)
        end
        if inst.components.eater:Eat(item) then
	--inst.components.talker:Say("Zzu zu")
            --print("   yummy!")

        end
    end


--[[
        if item.components.edible.foodtype == "MEAT" then
			local last_eat_time = inst.components.eater:TimeSinceLastEating()
			if last_eat_time and last_eat_time < TUNING.PIG_MIN_POOP_PERIOD then        
				return false
			end
end
]]--
end
local poopchance2 = 0.6
local poopchance = 0.4
local rebackchance = 0.2
local tynychance = 0.1
local tynyychance = 0.05
local eggchance = 1.0

local function OnEat(inst, food)

if food.components.edible.hungervalue >= 150 and food.components.edible.healthvalue >= 100 then 
	inst.level = inst.level + 100
	levelexp(inst)
inst.components.talker:Say(" !!!!!!!!!! \nEXP + 100 ")
elseif food.components.edible and math.random() < largechance and not inst:HasTag("baby") and food.components.edible.hungervalue > 100 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < normalchance and not inst:HasTag("baby") and food.components.edible.hungervalue > 74 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < poopchance2 and not inst:HasTag("baby") and food.components.edible.hungervalue > 50 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < poopchance and not inst:HasTag("baby") and food.components.edible.hungervalue > 20 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < tynychance and not inst:HasTag("baby") and food.components.edible.hungervalue > 9 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < tynychance and not inst:HasTag("baby") and food.components.edible.hungervalue <= 9 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < poopchance2 and not inst:HasTag("baby") and food.components.edible.healthvalue > 39 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < poopchance and not inst:HasTag("baby") and food.components.edible.healthvalue > 19 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food.components.edible and math.random() < tynychance and not inst:HasTag("baby") and food.components.edible.healthvalue > 8 then 
	inst.level = inst.level + 1
	levelexp(inst)
elseif food and food.components.edible and food.components.edible.foodtype == "EXP" then
	inst.level = inst.level + 2
	levelexp(inst)
inst.components.talker:Say("  [EXP](+2) ".. (inst.level))
end

    -- food heal
    if inst:HasTag("companion") then
        inst.components.health:DoDelta(inst.components.health.maxhealth * .05, nil, food.prefab)
        inst.components.combat:SetTarget(nil)
    else
        inst.components.health:DoDelta(inst.components.health.maxhealth, nil, food.prefab)
    end
    -- VEGGIE -- MEAT -- SEEDS
    if food.components.edible and food.components.edible.foodtype == "MEAT" then
	local fx = SpawnPrefab("poopcloud")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(0.7, 0.7, 0.7)
    if math.random() < poopchance then
		local poo = SpawnPrefab("guano")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("poop")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("spoiled_food")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("wetgoop")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("ash")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < tynyychance then
		local poo = SpawnPrefab("glowdust")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
	end
	end

    if food.components.edible and food.components.edible.hungervalue > 141 and food.components.edible.healthvalue > 91 then
inst.components.health:DoDelta(400)
    if math.random() < poopchance then
		local poo = SpawnPrefab("orangegem")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("greengem")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("yellowgem")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("purplegem")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		

	end
	end

    if food.components.edible and food.components.edible.hungervalue > 145 or food.components.edible.healthvalue > 39 then
inst.components.health:DoDelta(500)
    if math.random() < rebackchance then
		local poo = SpawnPrefab("goldnugget")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < tynychance then
		local poo = SpawnPrefab("redgem")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < tynychance then
		local poo = SpawnPrefab("bluegem")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < tynychance then
		local poo = SpawnPrefab("purplegem")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < tynychance then
		local poo = SpawnPrefab("thulecite")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		

	end
	end

    if food.components.edible and food.components.edible.hungervalue > 59 or food.components.edible.healthvalue > 29 or food.components.edible.sanityvalue > 14 then
inst.components.health:DoDelta(300)
    if math.random() < rebackchance then
		local poo = SpawnPrefab("goldnugget")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("wormlight")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("lightbulb")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("wormlight")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("thulecite_pieces")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		

	end
	end

    if food.components.edible and food.components.edible.hungervalue > 24 or food.components.edible.healthvalue > 9 or food.components.edible.sanityvalue > 4 then
inst.components.health:DoDelta(100)
    if math.random() < rebackchance then
		local poo = SpawnPrefab("poop")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("Charcoal")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("rottenegg")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < tynychance then
		local poo = SpawnPrefab("lightbulb")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < tynychance then
		local poo = SpawnPrefab("wormlight")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("houndstooth")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		

	end
	end

    if food.components.edible and food.components.edible.foodtype == "VEGGIE" then
	local fx = SpawnPrefab("poopcloud")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(0.5, 0.5, 0.5)
    if math.random() < poopchance then
		local poo = SpawnPrefab("seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("carrot_seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("pumpkin_seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("dragonfruit_seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("pomegranate_seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("corn_seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("durian_seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("eggplant_seeds")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < tynychance then
		local poo = SpawnPrefab("wormlight")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("ash")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
	end
	end

    if food.components.edible and food.components.edible.foodtype == "SEEDS" then
	local fx = SpawnPrefab("poopcloud")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(0.2, 0.2, 0.2)
    if math.random() < poopchance then
		local poo = SpawnPrefab("ash")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
	end
	end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level1") then
		local poo = SpawnPrefab("musha_egg")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()

end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level2") then
	if inst.components.container then
	inst.components.container:DropEverything() 
		local poo = SpawnPrefab("musha_eggs1")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()
    end
end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level3") then
	if inst.components.container then
	inst.components.container:DropEverything() 
		local poo = SpawnPrefab("musha_eggs2")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()
end
end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level4") then
	if inst.components.container then
	inst.components.container:DropEverything() 
		local poo = SpawnPrefab("musha_eggs3")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()
    end
end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level5") then
	if inst.components.container then
	inst.components.container:DropEverything() 
		local poo = SpawnPrefab("musha_egg1")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()
    end
end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level6") then
	if inst.components.container then
	inst.components.container:DropEverything() 
		local poo = SpawnPrefab("musha_egg2")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()
    end
end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level7") then
	if inst.components.container then
	inst.components.container:DropEverything() 
		local poo = SpawnPrefab("musha_egg3")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()
    end
end
if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" and inst:HasTag("level8") then
	if inst.components.container then
	inst.components.container:DropEverything() 
		local poo = SpawnPrefab("musha_egg8")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
            die(inst)
    inst:Remove()
    end
end

if food and food.components.edible and food.components.edible.foodtype == "CRISTAL" then
	local dark2 = SpawnPrefab("statue_transition_2")
	local pos = Vector3(inst.Transform:GetWorldPosition())
dark2.Transform:SetPosition(pos:Get())
    if math.random() < poopchance then
		local poo = SpawnPrefab("flower_cave")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("flower_cave")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("flower_cave_double")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < poopchance then
		local poo = SpawnPrefab("flower_cave_double")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("flower_cave_triple")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
    elseif math.random() < rebackchance then
		local poo = SpawnPrefab("flower_cave_triple")
		poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	

	end
	end
	end

local function OnRefuseItem(inst, item)
    inst.sg:GoToState("refuse")
    if inst.components.sleeper:IsAsleep() then
        inst.components.sleeper:WakeUp()
end
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function SetTeenAttackDefault(inst)
    --print("teenbird - Set phasers to 'KILL'")
    inst:RemoveTag("peck_attack")
    --inst.components.combat:SetDefaultDamage(TUNING.TEENBIRD_DAMAGE)
    --inst.components.combat:SetAttackPeriod(TUNING.TEENBIRD_ATTACK_PERIOD)
end

local function SetTeenAttackPeck(inst)
    --print("teenbird - Set phasers to 'PECK'")
    inst:AddTag("peck_attack")
    --inst.components.combat:SetDefaultDamage(TUNING.TEENBIRD_DAMAGE_PECK)
    --inst.components.combat:SetAttackPeriod(TUNING.TEENBIRD_PECK_PERIOD)
end
--[[
local function OnNewTarget(inst, data)
local other = data.target
    --print("teenbird - OnNewTarget", data.target, inst.components.follower.leader)
    if data.target and data.target:HasTag("player") then
	return 
	elseif inst:HasTag("animal") then
	inst.components.combat:SetTarget(nil)
elseif other and other:HasTag("musha") then
	inst.components.combat:SetTarget(nil)
inst.components.combat:GiveUp()

end
end

]]

local function OnNewTarget(inst, data)
    --print("teenbird - OnNewTarget", data.target, inst.components.follower.leader)
    if data.target and data.target:HasTag("player") then
	return 
	elseif inst:HasTag("animal") then
	inst.components.combat:SetTarget(nil)
end
end

--[[
local function TeenRetarget(inst)
    return FindEntity(inst, TUNING.TEENBIRD_TARGET_DIST, function(guy)
        if inst.components.combat:CanTarget(guy)  and (not guy.LightWatcher or guy.LightWatcher:IsInLight()) then
            if inst.components.follower.leader ~= nil then
                return (guy:HasTag("monster") or (guy == inst.components.follower.leader and guy:HasTag("player") and inst.components.hunger and inst.components.hunger:IsStarving()))
            else
                return guy:HasTag("monster")
            end
        end
    end)
end

local function TeenKeepTarget(inst, target)
    return inst.components.combat:CanTarget(target) and (not target.LightWatcher or target.LightWatcher:IsInLight())
end
]]--
local function OnAttacked(inst, data)

    inst.components.combat:SuggestTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 3, function(dude) return dude:HasTag("companion") and not dude.components.health:IsDead() end, 5)

end

local function OnRanger(inst, data)
local rangechance = 0.1
local other = data.target
    if other and not inst:HasTag("level1") and not inst:HasTag("musha_ranger") and math.random() < rangechance then
inst:AddTag("musha_ranger") 
	local sparks = SpawnPrefab("sparks")
	local pos = Vector3(inst.Transform:GetWorldPosition())
	sparks.Transform:SetPosition(pos:Get())
	inst.components.talker:Say("  [   ]")
	inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
 inst.components.combat:SetRange(8)

    elseif other and inst:HasTag("level2") and inst:HasTag("musha_ranger") then
            SpawnPrefab("lightning").Transform:SetPosition(other:GetPosition():Get())
        other.components.health:DoDelta(-10)
            SpawnPrefab("shock_fx2").Transform:SetPosition(other:GetPosition():Get())
	inst.AnimState:SetBloomEffectHandle( "" )
inst:RemoveTag("musha_ranger") 
 inst.components.combat:SetRange(3)
    elseif other and inst:HasTag("level3") and inst:HasTag("musha_ranger") then
            SpawnPrefab("lightning").Transform:SetPosition(other:GetPosition():Get())
        other.components.health:DoDelta(-20)
            SpawnPrefab("shock_fx2").Transform:SetPosition(other:GetPosition():Get())
	inst.AnimState:SetBloomEffectHandle( "" )
inst:RemoveTag("musha_ranger") 
 inst.components.combat:SetRange(3)
    elseif other and inst:HasTag("level4") and inst:HasTag("musha_ranger") then
            SpawnPrefab("lightning").Transform:SetPosition(other:GetPosition():Get())
        other.components.health:DoDelta(-30)
            SpawnPrefab("shock_fx2").Transform:SetPosition(other:GetPosition():Get())
	inst.AnimState:SetBloomEffectHandle( "" )
inst:RemoveTag("musha_ranger") 
 inst.components.combat:SetRange(3)
    elseif other and inst:HasTag("level5") and inst:HasTag("musha_ranger") then
            SpawnPrefab("lightning").Transform:SetPosition(other:GetPosition():Get())
        other.components.health:DoDelta(-40)
            SpawnPrefab("shock_fx2").Transform:SetPosition(other:GetPosition():Get())
	inst.AnimState:SetBloomEffectHandle( "" )
inst:RemoveTag("musha_ranger") 
 inst.components.combat:SetRange(3)
    elseif other and inst:HasTag("level6") and inst:HasTag("musha_ranger") then
            SpawnPrefab("lightning").Transform:SetPosition(other:GetPosition():Get())
        other.components.health:DoDelta(-50)
            SpawnPrefab("shock_fx2").Transform:SetPosition(other:GetPosition():Get())
	inst.AnimState:SetBloomEffectHandle( "" )
inst:RemoveTag("musha_ranger") 
 inst.components.combat:SetRange(3)
    elseif other and inst:HasTag("level7") and inst:HasTag("musha_ranger") then
            SpawnPrefab("lightning").Transform:SetPosition(other:GetPosition():Get())
        other.components.health:DoDelta(-60)
            SpawnPrefab("shock_fx2").Transform:SetPosition(other:GetPosition():Get())
	inst.AnimState:SetBloomEffectHandle( "" )
inst:RemoveTag("musha_ranger") 
 inst.components.combat:SetRange(3)
    elseif other and inst:HasTag("level8") and inst:HasTag("musha_ranger") then
            SpawnPrefab("lightning").Transform:SetPosition(other:GetPosition():Get())
        other.components.health:DoDelta(-100)
            SpawnPrefab("shock_fx2").Transform:SetPosition(other:GetPosition():Get())
	inst.AnimState:SetBloomEffectHandle( "" )
inst:RemoveTag("musha_ranger") 
 inst.components.combat:SetRange(3)

    end
end

local function OnHitfire(inst, data)
local firechance = 0.4
local other = data.target
   local pos = other:GetPosition()
    if other and other.components.burnable and not inst:HasTag("darkyamche") and not inst:HasTag("iceyamche") then
        other.components.burnable:Ignite()
    elseif other and other.components.burnable and not inst:HasTag("iceyamche") and inst:HasTag("musha_ranger") then
        other.components.burnable:Ignite()
		other.components.health:DoDelta(-40)
elseif other and other:HasTag("musha") then
	inst.components.combat:SetTarget(nil)
inst.components.combat:GiveUp()

    end
    if other.components.burnable and other.components.burnable:IsBurning() then
        other.components.burnable:Extinguish()
    end
end

local function OnHitfreeze(inst, data)
local freezechance = 0.4
local other = data.target
   local pos = other:GetPosition()
    if other and other.components.freezable and inst:HasTag("iceyamche") then
        other.components.freezable:AddColdness(0.3)
        other.components.freezable:SpawnShatterFX()
elseif other and other.components.freezable and inst:HasTag("iceyamche") and inst:HasTag("musha_ranger") then
        other.components.freezable:AddColdness(10)
        other.components.freezable:SpawnShatterFX()
            SpawnPrefab("groundpoundring_fx").Transform:SetPosition(other:GetPosition():Get())
elseif other and other:HasTag("musha") then
	inst.components.combat:SetTarget(nil)
inst.components.combat:GiveUp()

    end

    if other.components.burnable and other.components.burnable:IsBurning() then
        other.components.burnable:Extinguish()
    end
end

local function OnHitvampire(inst, data)
--local vampirechance = 0.2
local other = data.target
   local pos = other:GetPosition()
if other and inst:HasTag("darkyamche") then
            SpawnPrefab("statue_transition").Transform:SetPosition(other:GetPosition():Get())
        inst.components.health:DoDelta(15)

    end
end


local function Onfreeze(attacked, data)
        if data and data.attacker and data.attacker.components.freezable then
            data.attacker.components.freezable:AddColdness(0.25)
            data.attacker.components.freezable:SpawnShatterFX()
        end 
    if data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then
        data.attacker.components.burnable:Extinguish()
    end
    end

local function Onfreezeice(attacked, data)
        if data and data.attacker and data.attacker.components.freezable then
            data.attacker.components.freezable:AddColdness(0.1)
            data.attacker.components.freezable:SpawnShatterFX()
        end 
    if data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then
        data.attacker.components.burnable:Extinguish()
    end
    end

local function OnFire(attacked, data)
        if data and data.attacker and data.attacker.components.burnable then
            data.attacker.components.burnable:IsBurning()
            data.attacker.components.health:DoDelta(-5)
            data.attacker.components.burnable:Ignite(true)
        end 
    end

--[[
    if inst:HasTag("musha_teen") and data.attacker ~= nil and (data.attacker == inst.components.follower.leader or data.attacker:HasTag("player")) then
        --print("  what did I ever do to you!?")
        -- well i was just annoyed, but now you done pissed me off!
        SetTeenAttackDefault(inst)
    end

    inst.components.combat:SuggestTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 1, function(dude) return dude:HasTag("smallbird") and not dude.components.health:IsDead() end, 5)
end
]]--

local function SetTeen(inst)
    --print("smallbird - SetTeen")
	inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.sg:GoToState("growup") -- calls back to SpawnTeen
end

local function SpawnTeen(inst)
    --print("smallbird - SpawnTeen")
local random = 0.2
local last = 1.0

    if math.random() < random then
    local musha_0 = SpawnPrefab("musha_teen")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_teenice")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_teenr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_teenr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_teenr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_teenr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_teenice")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_teenr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_teenr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_teenr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_0 = SpawnPrefab("musha_teen")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)

    elseif math.random() < random then
    local musha_0 = SpawnPrefab("musha_teen")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_teenr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_teenr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_teenr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_teenr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_teenice")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_teenr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_teenr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_teenr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < last then
    local musha_0 = SpawnPrefab("musha_teen")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)

    end
inst.AnimState:SetBloomEffectHandle( "" )
            die(inst)
    inst:Remove()

    end

local function SetAdult(inst)
    --print("smallbird - SetAdult")
inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

    inst.sg:GoToState("growup") -- calls back to SpawnAdult
end

local function SpawnAdult(inst)
    --print("smallbird - SpawnAdult")
local random = 0.2
local last = 1.0

    if math.random() < random then
 local musha_0 = SpawnPrefab("musha_tall")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrice")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrice")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
 local musha_0 = SpawnPrefab("musha_tall")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrice")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
 local musha_0 = SpawnPrefab("musha_tall")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)

    elseif math.random() < last then
 local musha_0 = SpawnPrefab("musha_tall")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
end

if inst.components.container then
inst.components.container:DropEverything() 
end
inst.AnimState:SetBloomEffectHandle( "" )
            die(inst)
    inst:Remove()

    end

local function SetAdult2(inst)
    --print("smallbird - SetAdult")
inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

    inst.sg:GoToState("growup") -- calls back to SpawnAdult
end

local function SpawnAdult2(inst)

local random = 0.2
local last = 1.0

    if math.random() < random then
    local musha_0 = SpawnPrefab("musha_tall2")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrice")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallrr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallrr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallrr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallrr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrr5")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrice")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_0 = SpawnPrefab("musha_tall2")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallrr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallrr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallrr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallrr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrr5")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrice")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < last then
    local musha_0 = SpawnPrefab("musha_tall2")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
end

if inst.components.container then
inst.components.container:DropEverything() 
end
inst.AnimState:SetBloomEffectHandle( "" )
            die(inst)
    inst:Remove()

    end
local function SetAdult3(inst)
    --print("smallbird - SetAdult")
inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

    inst.sg:GoToState("growup") -- calls back to SpawnAdult
end

local function SpawnAdult3(inst)

local random = 0.2
local last = 1.0

    if math.random() < random then
    local musha_0 = SpawnPrefab("musha_tall3")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrrice")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallrrr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallrrr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallrrr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallrrr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrrr5")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrrice")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < last then
    local musha_0 = SpawnPrefab("musha_tall3")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
end

if inst.components.container then
inst.components.container:DropEverything() 
end
inst.AnimState:SetBloomEffectHandle( "" )
            die(inst)
    inst:Remove()

    end
local function SetAdult4(inst)
    --print("smallbird - SetAdult")
inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

    inst.sg:GoToState("growup") -- calls back to SpawnAdult
end

local function SpawnAdult4(inst)
local random = 0.2
local last = 1.0

    if math.random() < random then
    local musha_0 = SpawnPrefab("musha_tall4")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_7 = SpawnPrefab("musha_tallrrrrice")
    musha_7.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_7.sg:GoToState("idle")
musha_7.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallrrrr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallrrrr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallrrrr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallrrrr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrrrr5")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrrr6")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_7 = SpawnPrefab("musha_tallrrrrice")
    musha_7.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_7.sg:GoToState("idle")
musha_7.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_0 = SpawnPrefab("musha_tall4")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallrrrr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallrrrr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallrrrr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallrrrr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrrrr5")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrrr6")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_7 = SpawnPrefab("musha_tallrrrrice")
    musha_7.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_7.sg:GoToState("idle")
musha_7.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < last then
    local musha_0 = SpawnPrefab("musha_tall4")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
end

	if inst.components.container then
	inst.components.container:DropEverything() 
end
inst.AnimState:SetBloomEffectHandle( "" )
            die(inst)
    inst:Remove()

    end
local function SetAdult5(inst)
    --print("smallbird - SetAdult")
inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

   inst.sg:GoToState("growup") -- calls back to SpawnAdult
end


local function SpawnAdult5(inst)
local random = 0.2
local last = 1.0
    if math.random() < random then
    local musha_0 = SpawnPrefab("musha_tall5")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_7 = SpawnPrefab("musha_tallrrrrrice")
    musha_7.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_7.sg:GoToState("idle")
musha_7.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_1 = SpawnPrefab("musha_tallrrrrr1")
    musha_1.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_1.sg:GoToState("idle")
musha_1.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_2 = SpawnPrefab("musha_tallrrrrr2")
    musha_2.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_2.sg:GoToState("idle")
musha_2.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_3 = SpawnPrefab("musha_tallrrrrr3")
    musha_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_3.sg:GoToState("idle")
musha_3.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_4 = SpawnPrefab("musha_tallrrrrr4")
    musha_4.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_4.sg:GoToState("idle")
musha_4.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_5 = SpawnPrefab("musha_tallrrrrr5")
    musha_5.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_5.sg:GoToState("idle")
musha_5.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_6 = SpawnPrefab("musha_tallrrrrr6")
    musha_6.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_6.sg:GoToState("idle")
musha_6.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < random then
    local musha_7 = SpawnPrefab("musha_tallrrrrrice")
    musha_7.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_7.sg:GoToState("idle")
musha_7.components.follower:SetLeader(inst.components.follower.leader)
    elseif math.random() < last then
    local musha_0 = SpawnPrefab("musha_tall5")
    musha_0.Transform:SetPosition(inst.Transform:GetWorldPosition())
    musha_0.sg:GoToState("idle")
musha_0.components.follower:SetLeader(inst.components.follower.leader)
end

	if inst.components.container then
	inst.components.container:DropEverything() 
end
inst.AnimState:SetBloomEffectHandle( "" )
            die(inst)
    inst:Remove()

    end

local function SetAdult6(inst)
    --print("smallbird - SetAdult")
inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

   inst.sg:GoToState("growup") -- calls back to SpawnAdult
end

local function SpawnAdult6(inst)
	local dark1 = SpawnPrefab("statue_transition")
	local dark2 = SpawnPrefab("statue_transition_2")
	local pos = Vector3(inst.Transform:GetWorldPosition())

    local musha_tall6= SpawnPrefab("musha_egg8")
    musha_tall6.Transform:SetPosition(inst.Transform:GetWorldPosition())
dark1.Transform:SetPosition(pos:Get())
dark2.Transform:SetPosition(pos:Get())
    --musha_tall6.sg:GoToState("idle")

	if inst.components.container then
	inst.components.container:DropEverything() 
end
inst.AnimState:SetBloomEffectHandle( "" )
            die(inst)
    inst:Remove()

    end


local function ondeath(inst)
 if inst:HasTag("ndead") then
 elseif not inst:HasTag("ndead") and inst:HasTag("level1") then
local poo = SpawnPrefab("musha_egg")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif not inst:HasTag("ndead") and inst:HasTag("level2") then
local poo = SpawnPrefab("musha_egg")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif not inst:HasTag("ndead") and inst:HasTag("level3") then
local poo = SpawnPrefab("musha_eggs1")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
 elseif not inst:HasTag("ndead") and inst:HasTag("level4") then
local poo = SpawnPrefab("musha_eggs2")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
 elseif not inst:HasTag("ndead") and inst:HasTag("level5") then
local poo = SpawnPrefab("musha_eggs3")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
 elseif not inst:HasTag("ndead") and inst:HasTag("level6") then
local poo = SpawnPrefab("musha_egg1")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
 elseif not inst:HasTag("ndead") and inst:HasTag("level7") then
local poo = SpawnPrefab("musha_egg2")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())	
 elseif not inst:HasTag("ndead") and inst:HasTag("level8") then
local poo = SpawnPrefab("musha_egg3")
poo.Transform:SetPosition(inst.Transform:GetWorldPosition())		
end
 if not inst:HasTag("ndead") then
	local dark2 = SpawnPrefab("statue_transition_2")
	local pos = Vector3(inst.Transform:GetWorldPosition())
dark2.Transform:SetPosition(pos:Get())
end
end

local function resist(inst, data)

if inst.components.health:GetPercent() <= 1 and  inst.components.health:GetPercent() > 0.7 then
        inst.components.freezable.wearofftime = 1.5

elseif inst.components.health:GetPercent() <= 0.7 and  inst.components.health:GetPercent() > 0.5 then
        inst.components.freezable.wearofftime = 0.5

elseif inst.components.health:GetPercent() <= 0.5 and  inst.components.health:GetPercent() > 0.2 then
        inst.components.freezable.wearofftime = 0.25

elseif inst.components.health:GetPercent() <= 0.2 then
        inst.components.freezable.wearofftime = 0
end
end

local function updatestats(inst, data)

	if inst.components.health:GetPercent() < 0.2 then
			inst.Light:Enable(false)
inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst:ListenForEvent("attacked", OnFire)

elseif inst.components.health:GetPercent() >= 0.2 then
    inst:RemoveEventCallback("attacked", OnFire)

elseif inst.components.health:GetPercent() >= 0.2 and not inst:HasTag("musha_ranger") then
inst.AnimState:SetBloomEffectHandle( "" )

end


	if inst.components.health:GetPercent() > .5 and not inst:HasTag("iceyamche") then

			inst.Light:Enable(true)
inst.AnimState:SetBloomEffectHandle( "" )
    			inst.components.health:StartRegen(1, 15)
    inst:RemoveEventCallback("attacked", Onfreeze)
    inst.components.combat:SetAttackPeriod(1.2)

		elseif inst.components.health:GetPercent() > .5 and inst:HasTag("iceyamche") then
    			inst.components.health:StartRegen(1, 15)
			inst.Light:Enable(true)
    inst:ListenForEvent("attacked", Onfreeze)

    inst.components.combat:SetAttackPeriod(1.6)

		elseif inst.components.health:GetPercent() < .5 and not inst:HasTag("iceyamche") then
    			inst.components.health:StartRegen(1, 1)
			inst.Light:Enable(false)
    inst:ListenForEvent("attacked", Onfreeze)

    inst.components.combat:SetAttackPeriod(1)

		elseif inst.components.health:GetPercent() < .5 and inst:HasTag("iceyamche") then

    			inst.components.health:StartRegen(1, 1)
			inst.Light:Enable(false)
    inst:ListenForEvent("attacked", Onfreeze)

    inst.components.combat:SetAttackPeriod(1.3)

end

	if inst:HasTag("baby") and inst:HasTag("onyamche") and inst:HasTag("hat")  then
		if inst.components.hunger:GetPercent() > .9 then
    inst.entity:AddLight()
	inst.Light:SetRadius(2.5)
    inst.Light:SetFalloff(.8)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,165/255,165/255)
		elseif inst.components.hunger:GetPercent() <= .9 and inst.components.health:GetPercent() >= .75  then
    inst.entity:AddLight()
	inst.Light:SetRadius(2)
    inst.Light:SetFalloff(.8)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,165/255,165/255)
		elseif inst.components.hunger:GetPercent() <= .7 and inst.components.health:GetPercent() >= .5  then
	--inst.components.talker:Say("Kku!")
    inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/chirp") 

    inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.8)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,165/255,165/255)
		elseif inst.components.hunger:GetPercent() <= .5 and inst.components.health:GetPercent() >= .25  then
    inst.entity:AddLight()
	inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(.4)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,165/255,165/255)
		elseif inst.components.hunger:GetPercent() < .25 then
    inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/chirp") 
    inst.entity:AddLight()
	inst.Light:SetRadius(.2)
    inst.Light:SetFalloff(.8)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,165/255,165/255)
end
end
end

local function GetPeepChance(inst)
    local peep_percent = 0.1
    if inst.components.hunger then
        if inst.components.hunger:IsStarving() then
            peep_percent = .4
	--inst.components.talker:Say("Kkyuuu! Koo Koo!")
        elseif inst.components.hunger:GetPercent() < .1 then
            peep_percent = 0.3
	--inst.components.talker:Say("Kku! Koo Koo!")
        elseif inst.components.hunger:GetPercent() < .3 then
            peep_percent = 0.1
	--inst.components.talker:Say("Kku! Koo!")
        elseif inst.components.hunger:GetPercent() < .5 then
            peep_percent = 0.1
	inst.components.talker:Say("Kku!")
        elseif inst.components.health:GetPercent() < .2 then
            peep_percent = 0.4
	--inst.components.talker:Say("PPu! Poo! Poo!")
        elseif inst.components.health:GetPercent() < .4 then
            peep_percent = 0.15
	--inst.components.talker:Say("PPu! Poo!")
        elseif inst.components.health:GetPercent() < .6 then
            peep_percent = 0.1
	inst.components.talker:Say("Poo!")

        end
    end
    return peep_percent
end

local function GetCryChance(inst, data)
    local cry_percent = 0
	local player = GetPlayer()
if inst.components.follower:IsNearLeader(CRY_NEAR_LEADER_DISTANCE) then

if not inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .2 and player.components.health:GetPercent() <= .2 then
            cry_percent = .05
	inst.components.talker:Say("Ccuure!!!")
        player.components.health:DoDelta(20)
        player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(5)
        inst.components.hunger:DoDelta(-20)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        local fx2 = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
        fx2.entity:SetParent(player.entity)
	fx2.Transform:SetScale(1, 2, 1)
        fx2.Transform:SetPosition(0.3, 0, 0)
		
elseif not inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .3 and player.components.health:GetPercent() > .2 and player.components.health:GetPercent() <= .3 then
            cry_percent = .04
	inst.components.talker:Say("Ccuure!!")
        player.components.health:DoDelta(10)
        player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(5)
        inst.components.hunger:DoDelta(-10)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        local fx2 = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
        fx2.entity:SetParent(player.entity)
	fx2.Transform:SetScale(1, 2, 1)
        fx2.Transform:SetPosition(0.3, 0, 0)

		
elseif not inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .5 and player.components.health:GetPercent() > .3 and player.components.health:GetPercent() <= .5 then
            cry_percent = .01
	inst.components.talker:Say("Ccuure!")
        player.components.health:DoDelta(5)
        player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(5)
        inst.components.hunger:DoDelta(-5)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        local fx2 = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
        fx2.entity:SetParent(player.entity)
	fx2.Transform:SetScale(1, 2, 1)
        fx2.Transform:SetPosition(0.3, 0, 0)	

elseif inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .2 and player.components.health:GetPercent() <= .2 then
            cry_percent = 1
	inst.components.talker:Say("Ccuure!!!")
        player.components.health:DoDelta(20)
        player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(5)
        inst.components.hunger:DoDelta(-20)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        local fx2 = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
        fx2.entity:SetParent(player.entity)
	fx2.Transform:SetScale(1, 2, 1)
        fx2.Transform:SetPosition(0.3, 0, 0)
		
elseif inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .3 and player.components.health:GetPercent() > .2 and player.components.health:GetPercent() <= .5 then
            cry_percent = .95
	inst.components.talker:Say("Ccuure!!")
        player.components.health:DoDelta(10)
        player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(5)
        inst.components.hunger:DoDelta(-10)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        local fx2 = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
        fx2.entity:SetParent(player.entity)
	fx2.Transform:SetScale(1, 2, 1)
        fx2.Transform:SetPosition(0.3, 0, 0)

		
elseif inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .5 and player.components.health:GetPercent() > .5 and player.components.health:GetPercent() <= .8 then
            cry_percent = .9
	inst.components.talker:Say("Ccuure!")
        player.components.health:DoDelta(5)
        player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(5)
        inst.components.hunger:DoDelta(-5)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        local fx2 = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
        fx2.entity:SetParent(player.entity)
	fx2.Transform:SetScale(1, 2, 1)
        fx2.Transform:SetPosition(0.3, 0, 0)	
	
elseif inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .8 and player.components.health:GetPercent() > .8 and player.components.health:GetPercent() < 1 then
            cry_percent = .5
	inst.components.talker:Say("Ccuure!")
        player.components.health:DoDelta(5)
        player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(5)
        inst.components.hunger:DoDelta(-5)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        local fx2 = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
        fx2.entity:SetParent(player.entity)
	fx2.Transform:SetScale(1, 2, 1)
        fx2.Transform:SetPosition(0.3, 0, 0)		
		
		elseif inst:HasTag("fightn") and inst.components.hunger:GetPercent() > .2 and inst.components.health:GetPercent() < .3 then
            cry_percent = .9
	inst.components.talker:Say("Kkuure!")
        --player.components.health:DoDelta(5)
        --player.components.sanity:DoDelta(2)
        inst.components.health:DoDelta(30)
        inst.components.hunger:DoDelta(-5)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/raise")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pop")
        local fx = SpawnPrefab("sparklefx")
        fx.entity:SetParent(inst.entity)
	fx.Transform:SetScale(1, 2, 1)
        fx.Transform:SetPosition(0.3, 0, 0)
   			
    end
    end
    return cry_percent
end

--time
--(lv2)
local function GetTeenGrowTime(inst)
	return 1
end
--(lv3)
local function GetTallGrowTime(inst)
	return 1
	--return 1400
end
--(lv4)
local function GetTall2GrowTime(inst)
	return 1
	--return 2200
end
--(lv5)
local function GetTall3GrowTime(inst)
	return 1
	--return 3000
end
--(lv6)
local function GetTall4GrowTime(inst)
	return 1
	--return 3800
end
--(lv7)
local function GetTall5GrowTime(inst)
	return 1
	--return 4600
end
--(RP)
local function GetTall6GrowTime(inst)
	return 1
	--return 4600
end

--[[
local function GetTallGrowTime(inst)
	return TUNING.TEENBIRD_GROW_TIME
end
]]--
local function OnHealthDelta(inst, data)
    if data.cause == "hunger" and data.newpercent < 0.1 and inst.components.follower.leader then
        --print("teenbird - STARVING i'm blowing this popsicle stand!", data.newpercent)

        if inst.components.combat.target == inst.components.follower.leader then
            inst.components.combat:SetTarget(nil)
        end

        inst.components.follower:SetLeader(nil)
    end
end

local function create_common(inst)
    --print("smallbird - create_common")
	--inst = inst or CreateEntity()

    inst:AddTag("yamche")
    inst:AddTag("yamcheb")

    inst:AddTag("companion")
    inst:AddTag("character")
    inst:AddTag("musha_small")
    inst:AddTag("scarytoprey")
    inst:AddTag("noauradamage")
   -- inst:AddTag("fridge")
   -- inst:AddTag("lowcool")
    inst:AddTag("noauradamage")

inst:AddTag("peck_attack")
inst:AddTag("notraptrigger")
---inst:AddTag("houndfriend")

    inst.entity:AddMiniMapEntity()
	--inst.MiniMapEntity:SetIcon( "musha_small.tex" )
	inst.MiniMapEntity:SetIcon( "musha_teen.tex" )

	inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()

--[[    
    inst.fire = SpawnPrefab( "lighterfire" )
 local follower = inst.fire.entity:AddFollower()
    follower:FollowSymbol( inst.GUID, "swap_object", 150, 0, 1 )
]]--
	--MakeCharacterPhysics(inst, 10, .25)
    	MakeCharacterPhysics(inst, 50, .5)

    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)

    inst.Transform:SetFourFaced()

	inst:SetBrain(brain)	

    inst.userfunctions = 
    {
        FollowPlayer = FollowPlayer,
        GetPeepChance = GetPeepChance,
        GetCryChance = GetCryChance,
        SpawnTeen = SpawnTeen,
        SpawnAdult = SpawnAdult,
        SpawnAdult2 = SpawnAdult2,
        SpawnAdult3 = SpawnAdult3,
        SpawnAdult4 = SpawnAdult4,
        SpawnAdult5 = SpawnAdult5,
        SpawnAdult6 = SpawnAdult6,

	updatestats = updatestats
    }
    --("   order")

---name
    inst:AddComponent("named")
    inst.components.named.possiblenames = STRINGS.PHOENIXS
    inst.components.named:PickNewName()

    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = PhoenixSanityAura

--------------------
        inst:AddComponent("playerprox")
    inst.components.playerprox:SetDist(5.5, 6)
    inst.components.playerprox:SetOnPlayerNear(close)
    inst.components.playerprox:SetOnPlayerFar(far)

    ------------------------------------------
    inst:AddComponent("health")
	inst.components.health.fire_damage_scale = 0
	inst.components.health.canmurder = false

    inst:AddComponent("hunger")

    inst:AddComponent("combat")
    inst.components.combat:SetAttackPeriod(1.25)
    inst.components.combat.playerdamagepercent = 0
	inst:ListenForEvent("attacked", OnAttacked)
---    inst:ListenForEvent("attacked", OnFire)
        inst.procfn = function() tryproc(inst) end
        inst:ListenForEvent("attacked", inst.procfn)
inst:ListenForEvent("healthdelta", BattleCommand)
inst:ListenForEvent("hungerdelta", BattleCommand)
inst:ListenForEvent("attacked", BattleCommand)
inst:ListenForEvent("onhitother", BattleCommand)
inst:ListenForEvent("hungerdelta", Checklevel)
inst:ListenForEvent("healthdelta", resist)

    inst:ListenForEvent("onhitother", OnHitfire)
    inst:ListenForEvent("onhitother", OnHitfreeze)
    inst:ListenForEvent("onhitother", OnHitvampire)
    inst:ListenForEvent("onhitother", OnRanger)
 inst:ListenForEvent("death", ondeath)

    inst:AddComponent("resurrector")
	inst.components.resurrector.doresurrect = doresurrect2
	inst.components.resurrector.makeusedfn = makeused2

  --  inst:ListenForEvent("entity_death", function(world, data) entitydeathfn(inst, data) end, GetWorld())

    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = GetStatus

    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = 6
    inst.components.locomotor.runspeed = 9

  --  inst:AddTag("animal") 

    inst:AddComponent("follower")

-------
 if ACTIONS.STAYORDER~= nil then
    inst:AddComponent("staycommand")
    	end
-------
    inst:AddComponent("talker")
    inst.components.talker.fontsize = 29
    inst.components.talker.colour = Vector3(1, 0.85, 0.75, 1)

    inst:AddComponent("eater")
inst.components.eater:SetCanEatTestFn(CanEatTest)
    inst.components.eater:SetOmnivore()
	inst.components.eater.strongstomach = true

	--inst.components.eater:SetElemental()
    --inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", }

    inst.components.eater:SetOnEatFn(OnEat)

    inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
    inst.components.sleeper.testperiod = GetRandomWithVariance(4, 1)
    inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)
    inst:AddComponent("freezable")
    inst.components.freezable:SetResistance(6)

    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem

    inst:AddComponent("periodicspawner")
    inst.components.periodicspawner:SetPrefab("glowdust")
    inst.components.periodicspawner:SetRandomTimes(150, 600)
    inst.components.periodicspawner:SetDensityInRange(20, 2)
    inst.components.periodicspawner:SetMinimumSpacing(8)
    inst.components.periodicspawner:Start()


    inst:AddComponent("lootdropper")

    --print("smallbird - create_common END")

inst:ListenForEvent( "healthdelta", updatestats)

	inst.level = 0
    inst:ListenForEvent("entity_death", function(wrld, data) onkilll(inst, data) end, GetWorld())
inst:ListenForEvent("levelup", levelexp)
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload

    return inst
end

-----------start create birds grow

local function create_smallbird()
    --print("smallbird - create_smallbird")

	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_small.tex" )

    MakeInventoryPhysics(inst, 1,1)

    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
-------------------------------------
    inst:AddComponent("inspectable")
    inst:AddTag("musha_small")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_small.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
    inst.components.inventoryitem.cangoincontainer = false

-----------------------------equip--hat

   inst:AddTag("light")
   inst:AddTag("level1")

inst:AddComponent("equippable")
        inst:AddComponent("insulator")
     --inst:AddComponent("useableitem")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
        inst.components.insulator.insulation = TUNING.INSULATION_MED
       inst.components.equippable:SetOnEquip(onyamche)
       inst.components.equippable:SetOnUnequip(offyamche)
     -- inst.components.useableitem:SetOnUseFn(onuseyamche)
    --  inst.components.useableitem:SetOnStopUseFn(offuseyamche)
    inst.components.equippable.walkspeedmult = 1.25
    inst.components.equippable.runspeedmult = 1.25


------------------------
    inst.entity:AddLight()
	inst.Light:SetRadius(.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(10/255,125/255,125/255)
	---inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------
-------------------------------------

    create_common(inst)


    inst:SetStateGraph("SGmusha_small")
    inst.Transform:SetScale(0.4, 0.4, 0.4)

	inst.DynamicShadow:SetSize( 0.8, .3 )
    --MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

        inst.components.burnable:SetBurnTime(300)

    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(200)

    inst.components.hunger:SetMax(30)
    --inst.components.hunger:SetRate(TUNING.SMALLBIRD_HUNGER * 1.2 /TUNING.SMALLBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)

	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(TUNING.SMALLBIRD_DAMAGE)

    inst.components.lootdropper:SetLoot({"glowdust"})

  -- inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP", }

    local growth_stages = {
        {name="small", time = GetTeenGrowTime, fn = function() end },
        {name="tall", fn = SetTeen}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_smallbird END")
	return inst
end

-----musha_teen
local function create_teen_smallbird()
    --print("smallbird - create_teen_smallbird")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_small" )
--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_small.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_1)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_1
    inst.components.container.widgetanimbank = "ui_chest_3x2"
    inst.components.container.widgetanimbuild = "ui_chest_yamche0"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_teen")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")

    inst.entity:AddLight()
	inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(15/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end

    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:AddTag("level2")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_teen")


    inst.Transform:SetScale(0.5, 0.5, 0.5)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 0.9, .4 )
    --MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(60)
   -- inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER/TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(20)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTallGrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end
-------------

-----musha_teenr1
local function create_teenr1_smallbird()
    --print("smallbird - create_teen_smallbird")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_small" )
--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_small.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_1)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_1
    inst.components.container.widgetanimbank = "ui_chest_3x2"
    inst.components.container.widgetanimbuild = "ui_chest_yamche0"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")

    inst.entity:AddLight()
	inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(15/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end

    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:AddTag("level2")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_teen")


    inst.Transform:SetScale(0.5, 0.5, 0.5)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 0.9, .4 )
    --MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(60)
   -- inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER/TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(20)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTallGrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


-----musha_teenr2
local function create_teenr2_smallbird()
    --print("smallbird - create_teen_smallbird")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_small" )
--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_small.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_1)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_1
    inst.components.container.widgetanimbank = "ui_chest_3x2"
    inst.components.container.widgetanimbuild = "ui_chest_yamche0"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")

    inst.entity:AddLight()
	inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(15/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end

    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:AddTag("level2")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_teen")


    inst.Transform:SetScale(0.5, 0.5, 0.5)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 0.9, .4 )
    --MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(60)
   -- inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER/TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(20)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTallGrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


-----musha_teenr3
local function create_teenr3_smallbird()
    --print("smallbird - create_teen_smallbird")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_small" )
--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_small.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_1)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_1
    inst.components.container.widgetanimbank = "ui_chest_3x2"
    inst.components.container.widgetanimbuild = "ui_chest_yamche0"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall2")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")

    inst.entity:AddLight()
	inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(15/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end

    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:AddTag("level2")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_teen")


    inst.Transform:SetScale(0.5, 0.5, 0.5)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 0.9, .4 )
    --MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(60)
   -- inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER/TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(20)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTallGrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


-----musha_teenr4
local function create_teenr4_smallbird()
    --print("smallbird - create_teen_smallbird")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_small" )
--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_small.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_1)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_1
    inst.components.container.widgetanimbank = "ui_chest_3x2"
    inst.components.container.widgetanimbuild = "ui_chest_yamche0"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall3")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")

    inst.entity:AddLight()
	inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(15/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end

    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:AddTag("level2")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_teen")


    inst.Transform:SetScale(0.5, 0.5, 0.5)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 0.9, .4 )
    --MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(60)
   -- inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER/TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(20)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTallGrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

-----musha_teenr5
local function create_teenice_smallbird()
    --print("smallbird - create_teen_smallbird")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_small" )
--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_small.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_1)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_1
    inst.components.container.widgetanimbank = "ui_chest_3x2"
    inst.components.container.widgetanimbuild = "ui_chest_yamche0"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_ice")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")

    inst.entity:AddLight()
	inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(15/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end

    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:AddTag("level2")
inst:AddTag("iceyamche")
inst:AddTag("fridge")

    inst:SetStateGraph("SGmusha_teen")


    inst.Transform:SetScale(0.5, 0.5, 0.5)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 0.9, .4 )
    --MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(500)
    inst.components.combat:SetAttackPeriod(1.6)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(60)
   -- inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER/TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(20)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTallGrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end




-----musha tall

local function create_tall_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_tall.tex" )

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")


--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_2)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_2
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche1"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

    inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(25/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:AddTag("level3")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")


    inst:SetStateGraph("SGmusha_tall")


    inst.Transform:SetScale(0.6, 0.6, 0.6)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.0, .5 )
  --  MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

        inst.components.burnable:SetBurnTime(300)

 --   MakeSmallPropagator(inst)
    --MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(700)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(70)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.15 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(30)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTall2GrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallr1_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_tall.tex" )

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")


--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_2)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_2
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche1"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

    inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(25/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:AddTag("level3")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")


    inst:SetStateGraph("SGmusha_tall")


    inst.Transform:SetScale(0.6, 0.6, 0.6)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.0, .5 )
  --  MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

        inst.components.burnable:SetBurnTime(300)

 --   MakeSmallPropagator(inst)
    --MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(700)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(70)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.15 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(30)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTall2GrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end
local function create_tallr2_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_tall.tex" )

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_teen")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")


--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_2)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_2
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche1"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

    inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(25/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:AddTag("level3")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")


    inst:SetStateGraph("SGmusha_tall")


    inst.Transform:SetScale(0.6, 0.6, 0.6)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.0, .5 )
  --  MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

        inst.components.burnable:SetBurnTime(300)

 --   MakeSmallPropagator(inst)
    --MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(700)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(70)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.15 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(30)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTall2GrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end
local function create_tallr3_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_tall.tex" )

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall2")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")


--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_2)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_2
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche1"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

    inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(25/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:AddTag("level3")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")


    inst:SetStateGraph("SGmusha_tall")


    inst.Transform:SetScale(0.6, 0.6, 0.6)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.0, .5 )
  --  MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

        inst.components.burnable:SetBurnTime(300)

 --   MakeSmallPropagator(inst)
    --MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(700)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(70)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.15 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(30)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTall2GrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end
local function create_tallr4_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_tall.tex" )

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall3")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")


--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_2)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_2
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche1"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

    inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(25/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:AddTag("level3")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")


    inst:SetStateGraph("SGmusha_tall")


    inst.Transform:SetScale(0.6, 0.6, 0.6)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.0, .5 )
  --  MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

        inst.components.burnable:SetBurnTime(300)

 --   MakeSmallPropagator(inst)
    --MakeMediumFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(700)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(70)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.15 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(30)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTall2GrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end
local function create_tallrice_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "musha_tall.tex" )

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_ice")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")


-------------------------------------
    inst:AddComponent("inspectable")


--[[
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
]]--
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_2)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_2
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche1"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

    inst.entity:AddLight()
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(25/255,125/255,125/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:AddTag("level3")
inst:AddTag("iceyamche")
inst:AddTag("fridge")


    inst:SetStateGraph("SGmusha_tall")


    inst.Transform:SetScale(0.6, 0.6, 0.6)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.0, .5 )
  --  MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")

        inst.components.burnable:SetBurnTime(300)

 --   MakeSmallPropagator(inst)
    --MakeMediumFreezableCharacter(inst, "head")
        inst.components.combat:SetAttackPeriod(1.6)

    inst.components.health:SetMaxHealth(700)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(70)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.15 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(30)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall", time = GetTall2GrowTime, fn = function() end },
        {name="adult", fn = SetAdult}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

--------musha_tall2

local function create_tall2_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall2")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


   -- inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall2.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(100/255,25/255,25/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall2")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:AddTag("level4")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall2")


    inst.Transform:SetScale(0.7, 0.7, 0.7)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, .6 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
 --   MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(900)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(80)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.3 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(40)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_3)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche2"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

---
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall2", time = GetTall3GrowTime, fn = function() end },
        {name="adult2", fn = SetAdult2}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


local function create_tallrr1_teen()
    --print("tallbird -  create_tall2_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


   -- inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall2.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(100/255,25/255,25/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall2")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:AddTag("level4")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall2")


    inst.Transform:SetScale(0.7, 0.7, 0.7)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, .6 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
 --   MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(900)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(80)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.3 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(40)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_3)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche2"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

---
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall2", time = GetTall3GrowTime, fn = function() end },
        {name="adult2", fn = SetAdult2}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrr2_teen()
    --print("tallbird -  create_tall2_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_teen")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


   -- inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall2.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(100/255,25/255,25/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall2")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:AddTag("level4")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall2")


    inst.Transform:SetScale(0.7, 0.7, 0.7)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, .6 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
 --   MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(900)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(80)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.3 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(40)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_3)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche2"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

---
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall2", time = GetTall3GrowTime, fn = function() end },
        {name="adult2", fn = SetAdult2}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrr3_teen()
    --print("tallbird -  create_tall2_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


   -- inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall2.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(100/255,25/255,25/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall2")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:AddTag("level4")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall2")


    inst.Transform:SetScale(0.7, 0.7, 0.7)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, .6 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
 --   MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(900)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(80)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.3 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(40)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_3)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche2"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

---
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall2", time = GetTall3GrowTime, fn = function() end },
        {name="adult2", fn = SetAdult2}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrr4_teen()
    --print("tallbird -  create_tall2_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall3")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


   -- inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall2.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(100/255,25/255,25/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall2")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:AddTag("level4")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall2")


    inst.Transform:SetScale(0.7, 0.7, 0.7)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, .6 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
 --   MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(900)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(80)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.3 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(40)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_3)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche2"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

---
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall2", time = GetTall3GrowTime, fn = function() end },
        {name="adult2", fn = SetAdult2}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


local function create_tallrrice_teen()
    --print("tallbird -  create_tall2_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_ice")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


   -- inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall2.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(100/255,25/255,25/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall2")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:AddTag("level4")
inst:AddTag("iceyamche")
inst:AddTag("fridge")

    inst:SetStateGraph("SGmusha_tall2")


    inst.Transform:SetScale(0.7, 0.7, 0.7)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, .6 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
 --   MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
        inst.components.combat:SetAttackPeriod(1.6)

    inst.components.health:SetMaxHealth(900)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(80)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.3 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(40)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_3)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche2"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

---
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall2", time = GetTall3GrowTime, fn = function() end },
        {name="adult2", fn = SetAdult2}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end



local function create_tallrr5_teen()
    --print("tallbird -  create_tall2_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall4")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


   -- inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall2.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(100/255,25/255,25/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall2")
   inst:RemoveTag("musha_teen")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:AddTag("level4")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
   
   
    inst:SetStateGraph("SGmusha_tall2")


    inst.Transform:SetScale(0.7, 0.7, 0.7)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, .6 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
 --   MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(900)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(80)
    --inst.components.hunger:SetRate(TUNING.TEENBIRD_HUNGER * 1.3 /TUNING.TEENBIRD_STARVE_TIME)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(40)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_3)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_yamche2"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
----------

---
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    local growth_stages = {
        {name="tall2", time = GetTall3GrowTime, fn = function() end },
        {name="adult2", fn = SetAdult2}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


------musha tall3

local function create_tall3_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall3")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


    --inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall3.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.7)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(120/255,120/255,20/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall3")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:AddTag("level5")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall3")


    inst.Transform:SetScale(0.8, 0.8, 0.8)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.15, .7 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1100)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(90)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(50)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_4)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_4
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
    --inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall3", time = GetTall4GrowTime, fn = function() end },
        {name="adult3", fn = SetAdult3}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


------musha tall3

local function create_tallrrr1_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


    --inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall3.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.7)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(120/255,120/255,20/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall3")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:AddTag("level5")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall3")


    inst.Transform:SetScale(0.8, 0.8, 0.8)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.15, .7 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1100)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(90)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(50)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_4)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_4
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
    --inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall3", time = GetTall4GrowTime, fn = function() end },
        {name="adult3", fn = SetAdult3}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

------musha tall3

local function create_tallrrr2_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_teen")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


    --inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall3.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.7)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(120/255,120/255,20/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall3")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:AddTag("level5")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall3")


    inst.Transform:SetScale(0.8, 0.8, 0.8)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.15, .7 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1100)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(90)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(50)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_4)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_4
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
    --inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall3", time = GetTall4GrowTime, fn = function() end },
        {name="adult3", fn = SetAdult3}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

------musha tall3

local function create_tallrrr3_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


    --inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall3.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.7)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(120/255,120/255,20/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall3")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:AddTag("level5")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall3")


    inst.Transform:SetScale(0.8, 0.8, 0.8)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.15, .7 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1100)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(90)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(50)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_4)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_4
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
    --inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall3", time = GetTall4GrowTime, fn = function() end },
        {name="adult3", fn = SetAdult3}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

------musha tall3

local function create_tallrrr4_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall2")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


    --inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall3.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.7)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(120/255,120/255,20/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall3")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:AddTag("level5")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall3")


    inst.Transform:SetScale(0.8, 0.8, 0.8)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.15, .7 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1100)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(90)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(50)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_4)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_4
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
    --inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall3", time = GetTall4GrowTime, fn = function() end },
        {name="adult3", fn = SetAdult3}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end

------musha tall3

local function create_tallrrrice_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_ice")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


    --inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall3.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.7)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(120/255,120/255,20/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall3")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:AddTag("level5")
inst:AddTag("iceyamche")
inst:AddTag("fridge")

    inst:SetStateGraph("SGmusha_tall3")


    inst.Transform:SetScale(0.8, 0.8, 0.8)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.15, .7 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1100)
    inst.components.combat:SetAttackPeriod(1.6)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(90)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(50)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_4)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_4
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
    --inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall3", time = GetTall4GrowTime, fn = function() end },
        {name="adult3", fn = SetAdult3}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


local function create_tallrrr5_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall4")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


    --inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall3.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(1.7)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(120/255,120/255,20/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall3")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:AddTag("level5")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")

    inst:SetStateGraph("SGmusha_tall3")


    inst.Transform:SetScale(0.8, 0.8, 0.8)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.15, .7 )
    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst.components.burnable:SetBurnTime(300)
  --  MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1100)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(90)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(50)
--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_4)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_4
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,-180,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
    --inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall3", time = GetTall4GrowTime, fn = function() end },
        {name="adult3", fn = SetAdult3}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()


    --print("smallbird - create_teen_smallbird END")
	return inst
end


-----------musha_tall4

local function create_tall4_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall4")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(0.9, 0.9, 0.9)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end


local function create_tallrrrr1_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(0.9, 0.9, 0.9)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrrrr2_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_teen")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(0.9, 0.9, 0.9)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrrrr3_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(0.9, 0.9, 0.9)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrrrr4_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall2")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(0.9, 0.9, 0.9)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrrrr5_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall3")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(0.9, 0.9, 0.9)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end


local function create_tallrrrrice_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_ice")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:AddTag("iceyamche")
inst:AddTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(0.9, 0.9, 0.9)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)
    inst.components.combat:SetAttackPeriod(1.6)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end

local function create_tallrrrr6_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall5")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")

-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
--	inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall4.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(2.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(200/255,190/255,15/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall4")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:AddTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:AddTag("darkyamche") 
    inst:SetStateGraph("SGmusha_tall4")


    inst.Transform:SetScale(1.05, 1.05, 1.05)

  --  inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
   -- MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1300)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(100)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(60)

--("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_5)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
   inst.components.container.widgetslotpos = slotpos_5
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
---
   -- inst.components.eater:SetOmnivore()
	--inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall4", time = GetTall5GrowTime, fn = function() end },
        {name="adult4", fn = SetAdult4}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

    --print("smallbird - create_teen_smallbird END")
	return inst
end

--------musha_5
-------Level7 phoenix state

local function create_tall5_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall5")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:AddTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall5")


    inst.Transform:SetScale(1.1, 1.1, 1.1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end


local function create_tallrrrrr1_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall5")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end


local function create_tallrrrrr2_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_teen")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall5")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end


local function create_tallrrrrr3_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall5")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end


local function create_tallrrrrr4_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall2")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall5")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end


local function create_tallrrrrr5_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall3")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall5")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end


local function create_tallrrrrrice_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_ice")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:AddTag("iceyamche")
inst:AddTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall5")


   inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)
    inst.components.combat:SetAttackPeriod(1.6)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end


local function create_tallrrrrr6_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall4")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall5")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
     inst:AddTag("level7")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 
 

    inst:SetStateGraph("SGmusha_tall5")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.2, 0.9)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1500)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)

    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()

	return inst
end



-------Level8 phoenix state

local function create_rp1_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_small")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall6")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end


local function create_rp2_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_teen")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall6")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end

local function create_rp3_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall6")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end

local function create_rp4_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall2")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall6")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end

local function create_rp5_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall3")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall6")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end

local function create_rp6_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall4")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:RemoveTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall6")


     inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(3)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end

-------------

local function create_rp7_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_tall5")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:RemoveTag("iceyamche")
inst:RemoveTag("fridge")
inst:AddTag("darkyamche") 


    inst:SetStateGraph("SGmusha_tall6")


    inst.Transform:SetScale(1.15, 1.15, 1.15)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end

-------------

local function create_rpice_teen()
    --print("tallbird -  create_tall_teen")

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("smallbird")
    inst.AnimState:SetBuild("musha_ice")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
--inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )



-------------------------------------
    inst:AddComponent("inspectable")


  --  inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/musha_tall5.xml"

    inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(225/255,200/255,75/255)
	inst.Light:Enable(true)
-----------------------
    --inst:AddComponent("propagator")
    -----------------------
    inst:AddComponent("burnable")
   -- inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0,0) )
    
    inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.FIREPIT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(0)

-----------------------------
        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

        inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end
    
    inst:ListenForEvent( "onbuilt", function()
        anim:PlayAnimation("place")
        anim:PushAnimation("idle",false)
        inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
    end)
-------------------------------------------

-------------------------------------

    create_common(inst)
	
    inst:AddTag("musha_tall6")
   inst:RemoveTag("musha_tall")
   inst:RemoveTag("musha_tall2")
   inst:RemoveTag("musha_tall3")
   inst:RemoveTag("musha_tall4")
   inst:RemoveTag("musha_tall5")
     inst:AddTag("level8")
   inst:RemoveTag("baby")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
inst:RemoveTag("level5")
inst:RemoveTag("level6")
inst:RemoveTag("level7")
inst:AddTag("iceyamche")
inst:AddTag("fridge")
inst:RemoveTag("darkyamche") 

    inst:SetStateGraph("SGmusha_tall6")


    inst.Transform:SetScale(1, 1, 1)

   -- inst.Physics:SetCylinder(.5, 1)

	inst.DynamicShadow:SetSize( 1.1, 0.8)
   -- MakeSmallBurnableCharacter(inst, "head")
    MakeMediumBurnableCharacter(inst, "pig_torso")
    inst.components.burnable:SetBurnTime(300)
inst.components.burnable:SetFXLevel(300)
    --MakeSmallPropagator(inst)
    MakeSmallFreezableCharacter(inst, "head")
    
    inst.components.health:SetMaxHealth(1800)
    inst.components.combat:SetAttackPeriod(1.6)

    inst:ListenForEvent("healthdelta", OnHealthDelta)
    
    inst.components.hunger:SetMax(120)
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.25)
  --  inst.components.hunger:SetKillRate(TUNING.TEENBIRD_HEALTH * 1.75 /TUNING.TEENBIRD_STARVE_KILL_TIME)
--[[
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetRetargetFunction(3, TeenRetarget)
    inst.components.combat:SetKeepTargetFunction(TeenKeepTarget)
    SetTeenAttackDefault(inst)
]]--
	inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetRange(TUNING.TEENBIRD_ATTACK_RANGE)
    inst.components.combat:SetDefaultDamage(70)
    --("   container")
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos_6)
        inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_6
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(0,200,0)
    --inst.components.container.widgetpos = Vector3(-5,-75,0)
    inst.components.container.side_align_tip = 160
--	inst.components.container.side_widget = true    

--   inst.components.eater:SetOmnivore()
--	inst.components.eater:SetElemental()
inst.components.eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "CRISTAL", "EXP",}

     --   inst.procfn = function() tryproc(inst) end
     --   inst:ListenForEvent("attacked", inst.procfn)

    inst:ListenForEvent("newcombattarget", OnNewTarget)
    
    --inst.components.lootdropper:SetLoot({"musha_egg"})

    inst.components.lootdropper:SetLoot({"glowdust"})

    --inst.components.eater:SetCanEatTestFn(CanEatTest)
--[[
    local growth_stages = {
        {name="tall5", time = GetTall6GrowTime, fn = function() end },
        {name="adult5", fn = SetAdult5}
    }

	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StopGrowing()
]]
	return inst
end

-------------

return Prefab( "musha_small", create_smallbird, assets, prefabs),

	   Prefab( "musha_teen", create_teen_smallbird, teen_assets),
	   Prefab( "musha_teenr1", create_teenr1_smallbird, assets),
	   Prefab( "musha_teenr2", create_teenr2_smallbird, tall_assets),
	   Prefab( "musha_teenr3", create_teenr3_smallbird, tall2_assets),
	   Prefab( "musha_teenr4", create_teenr4_smallbird, tall3_assets),
	   Prefab( "musha_teenice", create_teenice_smallbird, ice_assets),

	   Prefab( "musha_tall", create_tall_teen, tall_assets) ,
	   Prefab( "musha_tallr1", create_tallr1_teen, assets) ,
	   Prefab( "musha_tallr2", create_tallr2_teen, teen_assets) ,
	   Prefab( "musha_tallr3", create_tallr3_teen, tall2_assets) ,
	   Prefab( "musha_tallr4", create_tallr4_teen, tall3_assets) ,
	   Prefab( "musha_tallrice", create_tallrice_teen, ice_assets) ,

 	   Prefab( "musha_tall2", create_tall2_teen, tall2_assets), 
 	   Prefab( "musha_tallrr1", create_tallrr1_teen, assets), 
 	   Prefab( "musha_tallrr2", create_tallrr2_teen, teen_assets), 
 	   Prefab( "musha_tallrr3", create_tallrr3_teen, tall_assets), 
 	   Prefab( "musha_tallrr4", create_tallrr4_teen, tall3_assets), 
 	   Prefab( "musha_tallrr5", create_tallrr5_teen, tall4_assets), 
 	   Prefab( "musha_tallrrice", create_tallrrice_teen, ice_assets), 

	   Prefab( "musha_tall3", create_tall3_teen, tall3_assets), 
 	   Prefab( "musha_tallrrr1", create_tallrrr1_teen, assets), 
 	   Prefab( "musha_tallrrr2", create_tallrrr2_teen, teen_assets), 
 	   Prefab( "musha_tallrrr3", create_tallrrr3_teen, tall_assets), 
 	   Prefab( "musha_tallrrr4", create_tallrrr4_teen, tall2_assets), 
 	   Prefab( "musha_tallrrr5", create_tallrrr5_teen, tall4_assets), 
 	   Prefab( "musha_tallrrrice", create_tallrrrice_teen, ice_assets), 

	   Prefab( "musha_tall4", create_tall4_teen, tall4_assets), 
 	   Prefab( "musha_tallrrrr1", create_tallrrrr1_teen, assets), 
 	   Prefab( "musha_tallrrrr2", create_tallrrrr2_teen, teen_assets), 
 	   Prefab( "musha_tallrrrr3", create_tallrrrr3_teen, tall_assets), 
 	   Prefab( "musha_tallrrrr4", create_tallrrrr4_teen, tall2_assets), 
 	   Prefab( "musha_tallrrrr5", create_tallrrrr5_teen, tall3_assets), 
 	   Prefab( "musha_tallrrrr6", create_tallrrrr6_teen, tall5_assets), 
 	   Prefab( "musha_tallrrrrice", create_tallrrrrice_teen, ice_assets), 

	   Prefab( "musha_tall5", create_tall5_teen, tall5_assets), 
	   Prefab( "musha_tallrrrrr1", create_tallrrrrr1_teen, assets), 
 	   Prefab( "musha_tallrrrrr2", create_tallrrrrr2_teen, teen_assets), 
 	   Prefab( "musha_tallrrrrr3", create_tallrrrrr3_teen, tall_assets), 
 	   Prefab( "musha_tallrrrrr4", create_tallrrrrr4_teen, tall2_assets), 
 	   Prefab( "musha_tallrrrrr5", create_tallrrrrr5_teen, tall3_assets), 
 	   Prefab( "musha_tallrrrrr6", create_tallrrrrr6_teen, tall4_assets), 
 	   Prefab( "musha_tallrrrrrice", create_tallrrrrrice_teen, ice_assets), 

	   Prefab( "musha_rp1", create_rp1_teen, rp1_assets), 
	   Prefab( "musha_rp2", create_rp2_teen, rp2_assets), 
	   Prefab( "musha_rp3", create_rp3_teen, rp3_assets), 
	   Prefab( "musha_rp4", create_rp4_teen, rp4_assets), 
	   Prefab( "musha_rp5", create_rp5_teen, rp5_assets), 
	   Prefab( "musha_rp6", create_rp6_teen, rp6_assets), 
	   Prefab( "musha_rp7", create_rp7_teen, tall5_assets), 
	   Prefab( "musha_rpice", create_rpice_teen, ice_assets), 

MakePlacer( "common/firepit_placer", "firepit", "firepit", "preview" ) 

