require "stategraphs/SGtentacle"

local assets=
{
	Asset("ANIM", "anim/tentacle.zip"),
    Asset("SOUND", "sound/tentacle.fsb"),
}

local prefabs =
{
    "monstermeat",
    "tentaclespike",
    "tentaclespots",
}

SetSharedLootTable( 'tentacle_frost',
{
   -- {'ice', 0.2},
})


local function onkilll(inst, data)
local tynychance = 0.05
local smallllchance = 0.1
local smallchance = 0.2
local normalchance = 0.3
local largechance = 0.7
local player = GetPlayer()
	if data.cause == inst.prefab and not data.inst:HasTag("companion") then
                if math.random() < normalchance and data.inst:HasTag("prey") then
        			player.level = player.level + 1
	player.components.talker:Say("  [EXP](+1) \n".. (player.level))
	--levelexp(player)	
	elseif math.random() < largechance and not data.inst:HasTag("prey") and not data.inst:HasTag("eyeplant") and not data.inst:HasTag("insect") then
    				player.level = player.level + 1
	player.components.talker:Say("  [EXP](+1) \n".. (player.level))
	elseif math.random() < tynychance and data.inst:HasTag("insect") then
    				player.level = player.level + 1
	player.components.talker:Say("  [EXP](+1) \n".. (player.level))
	elseif math.random() < smallllchance and data.inst:HasTag("eyeplant") then
    				player.level = player.level + 1
	player.components.talker:Say("  [EXP](+1) \n".. (player.level))
	elseif math.random() < smallllchance and data.inst:HasTag("arm") then
    				player.level = player.level + 1
	player.components.talker:Say("  [EXP](+1) \n".. (player.level))

    			 end
		          end
			end

local function retargetfn(inst)
    return FindEntity(inst, TUNING.TENTACLE_ATTACK_DIST, function(guy) 
        if guy.components.combat and guy.components.health and not guy.components.health:IsDead() then
            return (guy.components.combat.target == inst or guy:HasTag("character") or guy:HasTag("monster") or guy:HasTag("animal")) and not guy:HasTag("prey") and not guy:HasTag("musha") and not guy:HasTag("yamche") and not guy:HasTag("yamcheb") and not (guy.prefab == inst.prefab)
        end
    end)
end


local function shouldKeepTarget(inst, target)
    if target and target:IsValid() and target.components.health and not target.components.health:IsDead() then
        local distsq = target:GetDistanceSqToInst(inst)
        return distsq < TUNING.TENTACLE_STOPATTACK_DIST*TUNING.TENTACLE_STOPATTACK_DIST
    else
        return false
    end
end
local function OnHitfreeze(inst, data)
local other = data.target
   local pos = other:GetPosition()
    if other and other.components.freezable then
        other.components.freezable:AddColdness(0.5)
        other.components.freezable:SpawnShatterFX()
elseif other and other:HasTag("musha") then
	inst.components.combat:SetTarget(nil)
inst.components.combat:GiveUp()
    end
    if other.components.burnable and other.components.burnable:IsBurning() then
        other.components.burnable:Extinguish()
    end
end

local function ondeath(inst)
	inst.components.sanityaura.penalty = 0
	local player = GetPlayer()
	if player then
		player.components.sanity:RecalculatePenalty()
local fx = SpawnPrefab("statue_transition")
	local pos = Vector3(inst.Transform:GetWorldPosition())
	fx.Transform:SetPosition(pos:Get())

end
end

local function dead(inst, data)

if inst.components.hunger.current < 1 then
	inst.components.health:DoDelta(-600)

end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddPhysics()
    inst.Physics:SetCylinder(0.25,2)
    
    inst.AnimState:SetBank("tentacle")
    inst.AnimState:SetBuild("tentacle_frost")
    inst.AnimState:PlayAnimation("idle")
 	inst.entity:AddSoundEmitter()

  --  inst:AddTag("monster")    
    inst:AddTag("hostile")
    inst:AddTag("wet")
    inst:AddTag("WORM_DANGER")
    inst:AddTag("companion")
    inst:AddTag("yamcheb")

    inst.Transform:SetScale(0.7, 0.7, 0.7)

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(300)
    	inst:AddComponent("colourtweener")
	inst.components.colourtweener:StartTween({1,1,1,.85}, 0)
    inst:AddComponent("hunger")
	inst.components.hunger:SetMax(150)
 inst:ListenForEvent("death", ondeath)
local player = GetPlayer()
       inst:AddComponent("sanityaura")
    inst.components.sanityaura.penalty = 10
        player.components.sanity:RecalculatePenalty()

    inst:AddComponent("combat")
    inst.components.combat:SetRange(TUNING.TENTACLE_ATTACK_DIST)
    --inst.components.combat:SetDefaultDamage(TUNING.TENTACLE_DAMAGE)
    inst.components.combat:SetDefaultDamage(20)

    inst.components.combat:SetAttackPeriod(TUNING.TENTACLE_ATTACK_PERIOD)
    inst.components.combat:SetRetargetFunction(GetRandomWithVariance(2, 0.5), retargetfn)
    inst.components.combat:SetKeepTargetFunction(shouldKeepTarget)
    
    MakeLargeFreezableCharacter(inst)

        inst:AddComponent("follower")
    
        inst:ListenForEvent("onhitother", OnHitfreeze)
inst:ListenForEvent("hungerdelta", dead)
    inst:ListenForEvent("entity_death", function(wrld, data) onkilll(inst, data) end, GetWorld())

    inst:AddComponent("inspectable")
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('tentacle_frost')
    
    inst:SetStateGraph("SGtentacle")

    return inst
end

return Prefab( "marsh/monsters/tentacle_frost", fn, assets, prefabs) 
