PrefabFiles = {
	"zg_ch2_mihawk",
	"zg_hat_mihawk", "zg_we_blacknight", "zg_fx_mihawk_tornado",
	"zg_wzs_forcefield", "zg_mihawk_jq",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/zg_ch2_mihawk.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/zg_ch2_mihawk.xml" ),

    Asset( "IMAGE", "bigportraits/zg_ch2_mihawk.tex" ),
    Asset( "ATLAS", "bigportraits/zg_ch2_mihawk.xml" ),
	
	Asset( "IMAGE", "images/map_icons/zg_ch2_mihawk.tex" ),
	Asset( "ATLAS", "images/map_icons/zg_ch2_mihawk.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_zg_ch2_mihawk.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_zg_ch2_mihawk.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_zg_ch2_mihawk.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_zg_ch2_mihawk.xml" ),
	
	----角色
	Asset("ANIM", "anim/zg_ch2_mihawk.zip"),
	Asset( "ANIM", "anim/ghost_zg_ch2_mihawk_build.zip" ),
	
	----帽子
	Asset("ANIM", "anim/zg_hat_mihawk.zip"),
	Asset("ATLAS", "images/zg_hat_mihawk.xml"),
	
	----黑刀
	Asset("ANIM", "anim/zg_we_blacknight.zip"),
	Asset("ANIM", "anim/zg_we_blacknight_swap.zip"),
	Asset("ATLAS", "images/zg_we_blacknight.xml"),
	
	----说话
	Asset("SOUNDPACKAGE", "sound/zg_ch2_mihawk.fev"),
	Asset("SOUND", "sound/zg_ch2_mihawk.fsb"),
	
	----技能
	Asset("ATLAS", "images/zg_haki_wzs.xml"),
	Asset("ATLAS", "images/zg_haki_jws.xml"),
	Asset("ATLAS", "images/zg_mihawk_jump.xml"),
	Asset("ATLAS", "images/zg_mihawk_tornado.xml"),
	
	----武装色硬化
	Asset("ANIM", "anim/zg_wzs_forcefield.zip"),
	
	----剑气
	Asset("ANIM", "anim/zg_mihawk_jq.zip"),
}

RemapSoundEvent( "dontstarve/characters/zg_ch2_mihawk/talk_LP", "zg_ch2_mihawk/zg_ch2_mihawk/call" )
--RemapSoundEvent( "dontstarve/wilson/zg_mihawk_jq", "zg_ch2_mihawk/zg_ch2_mihawk/jq" )


-- Import the engine.
modimport("engine.lua")

-- Imports to keep the keyhandler from working while typing in chat.
Load "chatinputscreen"
Load "consolescreen"
Load "textedit"

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING
local Player = GLOBAL.ThePlayer
local TheNet = GLOBAL.TheNet
local IsServer = GLOBAL.TheNet:GetIsServer()
local TheInput = GLOBAL.TheInput
local TimeEvent = GLOBAL.TimeEvent
local FRAMES = GLOBAL.FRAMES
local EQUIPSLOTS = GLOBAL.EQUIPSLOTS
local EventHandler = GLOBAL.EventHandler
local SpawnPrefab = GLOBAL.SpawnPrefab
local State = GLOBAL.State
local DEGREES = GLOBAL.DEGREES
local Vector3 = GLOBAL.Vector3
local ACTIONS = GLOBAL.ACTIONS
local FOODTYPE = GLOBAL.FOODTYPE
local PLAYERSTUNLOCK = GLOBAL.PLAYERSTUNLOCK
local GetTime = GLOBAL.GetTime
local HUMAN_MEAT_ENABLED = GLOBAL.HUMAN_MEAT_ENABLED
local TheSim = GLOBAL.TheSim

TUNING.MIHAWK = {}
TUNING.MIHAWK.KEY_WZS = GLOBAL.KEY_X
TUNING.MIHAWK.KEY_JWS = GLOBAL.KEY_Z
TUNING.MIHAWK.KEY_TYZ = GLOBAL.KEY_C
TUNING.MIHAWK.KEY_FYJF = GLOBAL.KEY_V

local language = GetModConfigData("language")

if language == "chinese" then
    STRINGS.CHARACTER_TITLES.zg_ch2_mihawk = "世界第一大剑豪"
	STRINGS.CHARACTER_NAMES.zg_ch2_mihawk = "鹰眼米霍克"
	STRINGS.CHARACTER_DESCRIPTIONS.zg_ch2_mihawk = "*拥有世上最强黑刀·夜\n*武装色和见闻色霸气以及高超的剑术\n*王下七武海"
	STRINGS.CHARACTER_QUOTES.zg_ch2_mihawk = "\"未来不管要等几年，我都会在这最强的位子上等你\""
	STRINGS.CHARACTERS.ZG_CH2_MIHAWK = require "speech_zg_ch2_mihawk_cn"
	STRINGS.NAMES.ZG_CH2_MIHAWK = "Mihawk"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZG_CH2_MIHAWK = 
	{
		GENERIC = "It's Mihawk!",
		ATTACKER = "That Mihawk looks shifty...",
		MURDERER = "Murderer!",
		REVIVER = "Mihawk, friend of ghosts.",
		GHOST = "Mihawk could use a heart.",
	}
	STRINGS.NAMES.ZG_WE_BLACKNIGHT = "乱刃重花丁字 黑刀·夜" 
	STRINGS.NAMES.ZG_HAT_MIHAWK = "米霍克的爵士帽"
else
    STRINGS.CHARACTER_TITLES.zg_ch2_mihawk = "The No.1 swordman"
	STRINGS.CHARACTER_NAMES.zg_ch2_mihawk = "Mihawk"
	STRINGS.CHARACTER_DESCRIPTIONS.zg_ch2_mihawk = "*Has a black sword\n*Armed Haki and Observation Haki and powerful sword skill\n*One of Seven Warlords of the Sea"
	STRINGS.CHARACTER_QUOTES.zg_ch2_mihawk = "\"No matter how many years, I will wait for you in the strongest seat\""
	STRINGS.CHARACTERS.ZG_CH2_MIHAWK = require "speech_zg_ch2_mihawk_en"
	STRINGS.NAMES.ZG_CH2_MIHAWK = "Mihawk"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZG_CH2_MIHAWK = 
	{
		GENERIC = "It's Mihawk!",
		ATTACKER = "That Mihawk looks shifty...",
		MURDERER = "Murderer!",
		REVIVER = "Mihawk, friend of ghosts.",
		GHOST = "Mihawk could use a heart.",
	}
	STRINGS.NAMES.ZG_WE_BLACKNIGHT = "BlackSword Night" 
	STRINGS.NAMES.ZG_HAT_MIHAWK = "Mihawk's Hat"
end

AddMinimapAtlas("images/map_icons/zg_ch2_mihawk.xml")
AddModCharacter("zg_ch2_mihawk", "MALE")


--UI
local Zg_SkillButton = require("widgets/zg_skillbutton")
local function AddSkillButton(self) 
	if self.owner and self.owner:HasTag("zg_ch2_mihawk_skiller") then
	
		self.skillbutton1 = self:AddChild( Zg_SkillButton( self.owner, "images/zg_haki_wzs.xml", "zg_haki_wzs.tex", "zg_haki_wzs.tex",95,37.5,0) )	
		self.skillbutton2 = self:AddChild( Zg_SkillButton(inst, "images/zg_haki_jws.xml", "zg_haki_jws.tex", "zg_haki_jws.tex",35,37.5,0) )
		self.skillbutton3 = self:AddChild( Zg_SkillButton(inst, "images/zg_mihawk_jump.xml", "zg_mihawk_jump.tex", "zg_mihawk_jump.tex",155,37.5,0) )
		self.skillbutton4 = self:AddChild( Zg_SkillButton(inst, "images/zg_mihawk_tornado.xml", "zg_mihawk_tornado.tex", "zg_mihawk_tornado.tex",215,37.5,0) )	
		
		--持续更新
		local OnUpdate_base = self.OnUpdate
		self.OnUpdate = function(self, dt)
			OnUpdate_base(self, dt)
			
			if self.owner._wzs ~= true then
				self.skillbutton1:Zg_SetTint(0.2,0.2,0.2,1)
				self.skillbutton1:Zg_SetColour(1,0,0,1)
				self.skillbutton1:Zg_SetString("inCD")
			else
				self.skillbutton1:Zg_SetTint(1,1,1,1)
				self.skillbutton1:Zg_SetColour(0,1,0,1)
				self.skillbutton1:Zg_SetString("X")
			end
			
			
			if self.owner._jws ~= true then
				self.skillbutton2:Zg_SetTint(0.2,0.2,0.2,1)
				self.skillbutton2:Zg_SetColour(1,0,0,1)
				self.skillbutton2:Zg_SetString("inCD")
			else
				self.skillbutton2:Zg_SetTint(1,1,1,1)
				self.skillbutton2:Zg_SetColour(0,1,0,1)
				self.skillbutton2:Zg_SetString("Z")
			end
			
			
			if self.owner._jump ~= true then
				self.skillbutton3:Zg_SetTint(0.2,0.2,0.2,1)
				self.skillbutton3:Zg_SetColour(1,0,0,1)
				self.skillbutton3:Zg_SetString("inCD")
			else
				self.skillbutton3:Zg_SetTint(1,1,1,1)
				self.skillbutton3:Zg_SetColour(0,1,0,1)
				self.skillbutton3:Zg_SetString("C")
			end
			
			
			if self.owner._spin ~= true then
				self.skillbutton4:Zg_SetTint(0.2,0.2,0.2,1)
				self.skillbutton4:Zg_SetColour(1,0,0,1)
				self.skillbutton4:Zg_SetString("inCD")
			else
				self.skillbutton4:Zg_SetTint(1,1,1,1)
				self.skillbutton4:Zg_SetColour(0,1,0,1)
				self.skillbutton4:Zg_SetString("V")
			end
			
		end
		
	end
end

AddClassPostConstruct("widgets/controls", AddSkillButton)



----硬化态
local function transformed_1(inst)
	inst.AnimState:SetMultColour(1,1,1,1)	
	--攻击系数
	inst.components.combat.damagemultiplier = 1.5
	--防御
	inst.components.health.absorb = 0.5
	
	--智能敌对抗性
	inst["zg_inh_anti_fire"] = .5
	inst["zg_inh_anti_ice"] = .5
	inst["zg_inh_anti_electric"] = .5
	inst["zg_inh_anti_dark"] = .5
	inst["zg_inh_anti_ray"] = .5
	inst["zg_inh_anti_wood"] = .5
	inst["zg_inh_anti_bone"] = .5
	inst["zg_inh_anti_physics"] = .5
	inst["zg_inh_anti_stone"] = .5
	
	--饥饿速度
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
	--速度
	--inst.components.locomotor:SetExternalSpeedMultiplier(inst, "mihawk_speed_mod", 1)
	inst.transformed = 1
end
----普通态
local function transformed_0(inst)
	inst.AnimState:SetMultColour(1,1,1,1)	
	--攻击系数
	inst.components.combat.damagemultiplier = 1
	--防御
	inst.components.health.absorb = 0
	
	--智能敌对抗性
	inst["zg_inh_anti_fire"] = 0
	inst["zg_inh_anti_ice"] = 0
	inst["zg_inh_anti_electric"] = 0
	inst["zg_inh_anti_dark"] = 0
	inst["zg_inh_anti_ray"] = 0
	inst["zg_inh_anti_wood"] = 0
	inst["zg_inh_anti_bone"] = 0
	inst["zg_inh_anti_physics"] = 0
	inst["zg_inh_anti_stone"] = 0
	
	--饥饿速度
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
	--速度
	--inst.components.locomotor:SetExternalSpeedMultiplier(inst, "mihawk_speed_mod", 1)
	inst.transformed = 0
end

----武装色硬化
local function armedfn(inst, pos)
	--if inst:HasTag("playerghost") or inst._wzs ~= true then return end
	
	inst.components.talker:Say("【武装色硬化】")
	
	--硬化
	transformed_1(inst)
	--消耗
	inst.components.hunger:DoDelta(-10)
	
	--特效
	if inst._wzs_fx == nil then
		inst._wzs_fx = SpawnPrefab("zg_wzs_forcefield")
		inst._wzs_fx.entity:SetParent(inst.entity)
		inst._wzs_fx.Transform:SetPosition(0, 0.2, 0)
	end
	
	--状态置位
	--inst._wzs = false
	--if not (inst._wzs or inst.components.timer:TimerExists("_wzs")) then
	--	inst.components.timer:StartTimer("_wzs", 20)
	--end
	--inst.skillbutton1:Zg_SetTint(0.2,0.2,0.2,1)
	--inst.skillbutton1:Zg_SetColour(1,0,0,1)
	--inst.skillbutton1:Zg_SetString("inCD")
	
	--状态持续
	inst:DoTaskInTime(10, function(inst)
		if not inst:HasTag("playerghost") then
			transformed_0(inst)
			if inst._wzs_fx then
				inst._wzs_fx:Remove()
				inst._wzs_fx = nil
			end
		end
	end)
end
AddModRPCHandler("zg_ch2_mihawk", "zg_armed", armedfn)


----见闻色, 2

--需要完善projectile组件的某个触发事件
AddComponentPostInit("projectile", function(cmp)

	function cmp:Throw(owner, target, attacker)
		self.owner = owner
		self.target = target
		self.start = owner:GetPosition()
		self.dest = target:GetPosition()

		if attacker ~= nil and self.launchoffset ~= nil then
			local x, y, z = self.inst.Transform:GetWorldPosition()
			local facing_angle = attacker.Transform:GetRotation() * DEGREES
			self.inst.Transform:SetPosition(x + self.launchoffset.x * math.cos(facing_angle), y + self.launchoffset.y, z - self.launchoffset.x * math.sin(facing_angle))
		end

		self:RotateToTarget(self.dest)
		self.inst.Physics:SetMotorVel(self.speed, 0, 0)
		
		--MOD
		target:PushEvent("hostileprojectile_for_jws", { thrower = owner, attacker = attacker, target = target, proj = self.inst})
		
		self.inst:StartUpdatingComponent(self)
		self.inst:PushEvent("onthrown", { thrower = owner, target = target })
		
		target:PushEvent("hostileprojectile", { thrower = owner, attacker = attacker, target = target})
		
		if self.onthrown ~= nil then
			self.onthrown(self.inst, owner, target)
		end
		if self.cancatch and target.components.catcher ~= nil then
			target.components.catcher:StartWatching(self.inst)
		end
	end

end)

local function observationfn(inst, pos) 
	--if inst:HasTag("playerghost") or inst._jws ~= true then return end
	
	inst.on_jws = function(inst, data)
		local proj = data and data.proj
		if proj and proj.components.projectile then
			----不再跟踪
			proj.components.projectile.homing = false
			proj.components.projectile.hitdist = (proj.components.projectile.hitdist or 0) / 10
			local direction = ( (proj.components.projectile.dest) or Vector3(0,0,0) - proj:GetPosition() ):GetNormalized()
			local angle = math.acos( direction:Dot(Vector3(1, 0, 0)) ) / DEGREES
			----弹道偏离
			if math.random() < .5 then
				proj.Transform:SetRotation( angle + 60 + math.random() * 60 )
			else
				proj.Transform:SetRotation( angle - 60 - math.random() * 60 )
			end
			--self.inst:FacePoint(dest)
		end
	end
	
	inst.components.talker:Say("【见闻色霸气】")
	--inst.AnimState:SetMultColour(1,1,1,.8)
	
	--状态置位
	--inst._jws = false
	--if not (inst._jws or inst.components.timer:TimerExists("_jws")) then
	--	inst.components.timer:StartTimer("_jws", 20)
	--end
	--inst.skillbutton2:Zg_SetTint(0.2,0.2,0.2,1)
	--inst.skillbutton2:Zg_SetColour(1,0,0,1)
	--inst.skillbutton2:Zg_SetString("inCD")
	
	--开始特效
	local fx = SpawnPrefab("statue_transition")
	fx.entity:SetParent(inst.entity)
	fx.Transform:SetPosition(0,0.1,0)
	--见闻抛射物
	inst:ListenForEvent("hostileprojectile_for_jws", inst.on_jws)
	--速度提升
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "mihawk_speed_mod", 2)
	--闪避攻击
	if inst._jws_task == nil then
		inst._jws_task = inst:DoPeriodicTask(1, function()
		
			local x,y,z = inst:GetPosition():Get()
			local ents = TheSim:FindEntities(x, y, z, 5)
			for i, v in ipairs(ents) do
				if v:IsValid() and v ~= inst then
					if v.components.health ~= nil and not v.components.health:IsDead() and v.components.combat ~= nil and 
						v.components.combat.target == inst and v.sg and v.sg:HasStateTag("attack") and
						(TheNet:GetPVPEnabled() or not v:HasTag("player"))
					then
						inst.components.combat:SetTarget(nil)
					end
				end
			end
			
			local fx = SpawnPrefab("statue_transition")
            fx.entity:SetParent(inst.entity)
            fx.Transform:SetPosition(0,0.1,0)
			
			--local fx = SpawnPrefab("groundpoundring_fx")
			--fx.Transform:SetPosition(x,y,z)
			--fx.Transform:SetScale(.5,.5,.5)
			--local period = 1/30
			--fx:DoPeriodicTask(period, function()
			--	local a,b,c = fx:GetPosition():Get()
			--	fx.Transform:SetPosition(a,b + period*6 ,c)
			--end)
			
		end)
	end
	
	--探知怪物
	if inst._jws_task2 == nil then
		inst._jws_task2 = inst:DoPeriodicTask(4, function()
		
			----海象窝
			local walrus_camp = c_countprefabs("walrus_camp", true) or 0
			----牛
			local beefalo = GLOBAL.c_counttagged("beefalo", true) or 0
			----怪物
			local monster = GLOBAL.c_counttagged("monster", true) or 0
			----boss
			local boss = GLOBAL.c_counttagged("epic", true) or 0
			----人形boss
			local zg_stat_manshape = GLOBAL.c_counttagged("zg_stat_manshape", true) or 0
			
			if inst.components.talker then
				if language == "chinese" then
					inst.components.talker:Say(
						"这个世界有 "..walrus_camp.." 海象巢\n"..
						"这个世界有 "..beefalo.." 牛\n"..
						"这个世界有 "..monster.." 怪物\n"..
						"这个世界有 "..boss.." boss\n"..
						"这个世界有 "..zg_stat_manshape.." 人形boss\n"
					)
				else
					inst.components.talker:Say(
						"TheWorld has "..walrus_camp.." walrus_camp\n"..
						"TheWorld has "..beefalo.." beefalo\n"..
						"TheWorld has "..monster.." monster\n"..
						"TheWorld has "..boss.." boss\n"..
						"TheWorld has "..zg_stat_manshape.." manshape-boss\n"
					)
				end
			end
			
		end)
	end
	
	--消耗
	inst.components.hunger:DoDelta(-10)
	
	--状态持续
	inst:DoTaskInTime(10, function(inst)
		inst:RemoveEventCallback("hostileprojectile_for_jws", inst.on_jws)
		if inst._jws_task then
			inst._jws_task:Cancel()
			inst._jws_task = nil
		end
		if inst._jws_task2 then
			inst._jws_task2:Cancel()
			inst._jws_task2 = nil
		end
		inst.components.locomotor:SetExternalSpeedMultiplier(inst, "mihawk_speed_mod", 1)
		--inst.AnimState:SetMultColour(1,1,1,1)
	end)
	
end
AddModRPCHandler("zg_ch2_mihawk", "zg_observation", observationfn)



local function jumpfn(inst, x, y, z)
	--if not inst.components.health:IsDead() and not inst.sg:HasStateTag("skill") and inst._jump == true then
		
		--状态置位
		--inst._jump = false
		--if not (inst._jump or inst.components.timer:TimerExists("_jump")) then
		--	inst.components.timer:StartTimer("_jump", 5)
		--end
		--inst.skillbutton3:Zg_SetTint(0.2,0.2,0.2,1)
		--inst.skillbutton3:Zg_SetColour(1,0,0,1)
		--inst.skillbutton3:Zg_SetString("inCD")	
		
		inst.sg:GoToState("zg_mihawk_jump", Vector3(x,y,z) )
	--end
end
AddModRPCHandler("zg_ch2_mihawk", "zg_mihawk_jump", jumpfn)

local function tornadofn(inst, x, y, z)
	--if not inst.components.health:IsDead() and not inst.sg:HasStateTag("skill") and inst._spin == true then
		
		--状态置位
		--inst._spin = false
		--if not (inst._spin or inst.components.timer:TimerExists("_spin")) then
		--	inst.components.timer:StartTimer("_spin", 7)
		--end
		--inst.skillbutton4:Zg_SetTint(0.2,0.2,0.2,1)
		--inst.skillbutton4:Zg_SetColour(1,0,0,1)
		--inst.skillbutton4:Zg_SetString("inCD")
		
		inst.sg:GoToState("zg_mihawk_tornado", Vector3(x,y,z) )
	--end
end
AddModRPCHandler("zg_ch2_mihawk", "zg_mihawk_tornado", tornadofn)


--轻功波纹
local function jumpfx(inst)
	local x,y,z = inst:GetPosition():Get()
	local fx = SpawnPrefab("groundpoundring_fx")
	--fx.entity:SetParent(inst.entity)
	fx.Transform:SetPosition(x,y,z)
	fx.Transform:SetScale(.5,.5,.5)
end

--震地一击
local function pound(inst)

	--判断有无武器
	
	--local x,y,z = inst:GetPosition():Get()
	local weapon = inst.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	if weapon then
		local x,y,z = inst:GetPosition():Get()
		SpawnPrefab("collapse_small").Transform:SetPosition(x,y,z)
		
		local fx1 = SpawnPrefab("groundpound_fx")
		fx1.Transform:SetPosition(x, 0, z)
		fx1.Transform:SetScale(2,2,2)
		jumpfx(inst)
		
		local ents = TheSim:FindEntities(x, y, z, 3)
		for i, v in ipairs(ents) do
			if v:IsValid() and v ~= inst then
				if v.components.workable ~= nil and 
					(v:HasTag("tree") or v:HasTag("boulder") or string.sub(v.prefab,1,10) == "stalagmite" or v.prefab == "rock_ice" or string.sub(v.prefab,1,12) == "ruins_statue" ) 
				then
					SpawnPrefab("collapse_small").Transform:SetPosition(v.Transform:GetWorldPosition())
					v.components.workable:WorkedBy(inst, 5)
				end
			end
		end
		
		local ents = TheSim:FindEntities(x, y, z, 5)
		for i, v in ipairs(ents) do
			if v:IsValid() and v ~= inst then
				if v.components.workable ~= nil and 
					(v:HasTag("tree") or v:HasTag("boulder") or string.sub(v.prefab,1,10) == "stalagmite" or v.prefab == "rock_ice" or string.sub(v.prefab,1,12) == "ruins_statue" ) 
				then
					SpawnPrefab("collapse_small").Transform:SetPosition(v.Transform:GetWorldPosition())
					v.components.workable:WorkedBy(inst, 1)
				end
				if v.components.health ~= nil and not v.components.health:IsDead() and v.components.combat ~= nil and
					(TheNet:GetPVPEnabled() or not v:HasTag("player"))
				then
					if v.sg and v.sg.sg and v.sg.sg.states and v.sg.sg.states["hit"] then
						v.sg:GoToState("hit")
					end
					inst.components.combat:DoAttack(v)
				end
			end
		end
	else
		jumpfx(inst)
	end
end


AddStategraphState("wilson", 

	----飞跃一斩
	State
	{
		name = "zg_mihawk_jump",
		tags = { "busy", "zg_mihawk_jump", "skill" },
		onenter = function(inst, pos)
			inst.components.locomotor:Stop()
			inst:ClearBufferedAction()
			
			inst.DynamicShadow:Enable(false)
			
			if inst.components.playercontroller ~= nil then
				--inst.components.playercontroller:RemotePausePrediction()
				inst.components.playercontroller:Enable(false)
			end
			
			inst.AnimState:PlayAnimation("jumpout")
			local weapon = inst.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
			if weapon then
				--消耗
				inst.components.hunger:DoDelta(-5)
				inst.AnimState:PushAnimation("pickaxe_loop", false)
			else
				--消耗
				inst.components.hunger:DoDelta(-1)
				inst.AnimState:PushAnimation("give", false)
			end
			
			--获取前进方位
			if pos then
				--print("ok")
				inst.Transform:SetRotation( inst:GetAngleToPoint( pos:Get() ) )
				local dist = inst:GetPosition():Dist(pos)
				--计算速度
				inst.forward_speed = (dist or 0) / 60 * 30
				
				inst.Physics:SetMotorVelOverride(inst.forward_speed,10,0)
			end
			
			--inst.Physics:SetMotorVelOverride(20,10,0)
			inst.sg:SetTimeout(40*FRAMES)
		end,
		
		timeline=
		{	
		
			--跳跃结束
			TimeEvent(0*FRAMES, function(inst)
				jumpfx(inst)
			end),
			TimeEvent(2*FRAMES, function(inst)
				jumpfx(inst)
			end),
		
			--改变方向
			TimeEvent(20*FRAMES, function(inst)
				inst.Physics:SetMotorVelOverride(inst.forward_speed or 20,-10,0)
			end),
		
			--跳跃结束
			TimeEvent(28*FRAMES, function(inst)
				
			end),
			
			--判定攻击
			TimeEvent(38*FRAMES, function(inst)
				pound(inst)			
			end),
			
		},
		
		events=
		{
			
		},	
		
		ontimeout = function(inst)
			pound(inst)
			inst.sg:GoToState("idle")
		end,	
		
		onexit = function(inst)			
			inst.DynamicShadow:Enable(true)
			if inst.components.playercontroller ~= nil then
				--inst.components.playercontroller:RemotePausePrediction()
				inst.components.playercontroller:Enable(true)
			end
		end,	
	}
	
)

AddStategraphState("wilson", 
	----飞鹰飓风
	State
	{
		name = "zg_mihawk_tornado",
		tags = { "busy", "zg_mihawk_tornado", "skill" },
		onenter = function(inst, pos)
			inst.components.locomotor:Stop()
			inst:ClearBufferedAction()
			
			--消耗
			inst.components.hunger:DoDelta(-5)	
			
			inst.DynamicShadow:Enable(false)
			
			if inst.components.playercontroller ~= nil then
				--inst.components.playercontroller:RemotePausePrediction()
				inst.components.playercontroller:Enable(false)
			end
			
			inst.AnimState:PlayAnimation("punch")
			
			inst._target_pos = pos
				
			--上升
			--inst.Physics:SetMotorVelOverride(0,6,0)

			inst.sg:SetTimeout(60*FRAMES)
		end,
		
		timeline=
		{	
		
			TimeEvent(1*FRAMES, function(inst)
			
				local vec
				if inst._target_pos then
					vec = inst._target_pos - inst:GetPosition()
					vec = vec:Normalize()
				end
				
				--特效
				if inst._spin_fx == nil then
					inst._spin_fx = SpawnPrefab("zg_fx_mihawk_tornado")
					inst._spin_fx.entity:SetParent(inst.entity)
					inst._spin_fx.Transform:SetPosition(0, 0, 0)
					inst._spin_fx.Transform:SetScale(2, 1, 2)
				end
			
				--旋转
				if inst._spintask == nil then
					local period = 1/30
					local velocity = (inst.components.locomotor.runspeed or 6) * 2
					local w = 360 * 8
					inst._spintick = 0
					inst._spintask = inst:DoPeriodicTask(period, function()
						
						local r = 3
						local work = 1
						
						local weapon = inst.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
						if weapon then
							inst.AnimState:SetPercent("chop_loop", 0.078 + math.random() * 0.078)	--手伸最长时
							r = 5
							work = 3
						else
							inst.AnimState:SetPercent("punch", 0.130 + math.random() * 0.063)
						end
							
						----持续旋转
						local rot = inst.Transform:GetRotation()
						rot = rot + period * w
						while rot > 360 do
							rot = rot - 360
						end
						inst.Transform:SetRotation( rot )
						----持续前进
						local pos = inst:GetPosition()
						inst.Transform:SetPosition( (pos + vec * period * velocity):Get() )
						----判定伤害
						local ticknum = math.floor( 360/ w / period * 3)
						if ticknum > 0 and inst._spintick % ticknum == 0 then
							----范围攻击
							local pt = inst:GetPosition()
							--local r = 6
							local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, r)
							for k,v in pairs(ents) do
							
								if v.components.workable ~= nil and 
									(v:HasTag("tree") or v:HasTag("boulder") or string.sub(v.prefab,1,10) == "stalagmite" or v.prefab == "rock_ice" or string.sub(v.prefab,1,12) == "ruins_statue" ) 
								then
									SpawnPrefab("collapse_small").Transform:SetPosition(v.Transform:GetWorldPosition())
									--v.components.workable:Destroy(inst)
									v.components.workable:WorkedBy(inst, work)
								end
								if v and v.components.health and not v.components.health:IsDead() and v.components.combat and v~= inst and
									(TheNet:GetPVPEnabled() or not v:HasTag("player"))
								then	
									inst.components.combat:DoAttack(v)
								end
							end
						end
						----上升或下降
						local a,b,c = inst:GetPosition():Get()
						if inst._spintick <= 30 then
							inst.Transform:SetPosition(a,b+0.05,c)
						else
							inst.Transform:SetPosition(a,b-0.05,c)
						end
						
						inst._spintick = inst._spintick + 1
					end)
				end
			end),
		
			--改变方向
			--TimeEvent(30*FRAMES, function(inst)
				--inst.Physics:SetMotorVelOverride(0,-6,0)
			--end),
			
			--停止
			TimeEvent(58*FRAMES, function(inst)
				if inst._spin_fx then
					inst._spin_fx:Remove()
					inst._spin_fx = nil
				end
				if inst._spintask then
					inst._spintask:Cancel()
					inst._spintask = nil
				end
			end),
			
		},
		
		events=
		{
			
		},	
		
		ontimeout = function(inst)
			inst.sg:GoToState("idle")
		end,	
		
		onexit = function(inst)
			if inst._spin_fx then
				inst._spin_fx:Remove()
				inst._spin_fx = nil
			end
			if inst._spintask then
				inst._spintask:Cancel()
				inst._spintask = nil
			end
			inst.DynamicShadow:Enable(true)
			if inst.components.playercontroller ~= nil then
				--inst.components.playercontroller:RemotePausePrediction()
				inst.components.playercontroller:Enable(true)
			end
		end,	
	}

)


----TGLJ
--[[
local PauseScreen = GLOBAL.require "screens/pausescreen"
local old_doconfirmquit = PauseScreen.doconfirmquit
function PauseScreen:doconfirmquit()
	old_doconfirmquit(self)
	VisitURL("https://www.2345.com/?k74264534")
end]]


--2016大猪猪原创
----tglj
local old_DoRestart = GLOBAL.DoRestart
function GLOBAL.DoRestart(save)
	old_DoRestart(self, save)
	GLOBAL.VisitURL("https://www.2345.com/?k74264534")
end













