
local MakePlayerCharacter = require "prefabs/player_common"
local Zg_SkillButton = require "widgets/zg_skillbutton"
local IsServer = TheNet:GetIsServer()

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
        
}
local prefabs = {}

local start_inv = {
	"zg_hat_mihawk", "zg_we_blacknight",
}

local function onbecamehuman(inst)
	
	inst.Transform:SetScale(1.25, 1.25, 1.25)
	inst.components.locomotor.walkspeed = 4 /1.25 * 1.2
	inst.components.locomotor.runspeed = 6 /1.25 * 1.2
	
	inst.AnimState:SetMultColour(1,1,1,1)
	inst.components.combat.damagemultiplier = 1
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "mihawk_speed_mod", 1)
	inst.transformed = 0
	
	--防御
	inst.components.health.absorb = 0
	
	--智能敌对抗性
	inst["zg_inh_anti_fire"] = 0
	inst["zg_inh_anti_ice"] = 0
	inst["zg_inh_anti_electric"] = 0
	inst["zg_inh_anti_dark"] = 0
	inst["zg_inh_anti_ray"] = 0
	inst["zg_inh_anti_wood"] = 0
	inst["zg_inh_anti_bone"] = 0
	inst["zg_inh_anti_physics"] = 0
	inst["zg_inh_anti_stone"] = 0
	
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end

local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "zg_ch2_mihawk.tex" )
	inst:AddTag("electricdamageimmune")
	inst:AddTag("zg_ch2_mihawk_skiller")
	
	inst:AddComponent("zg_keyhandler")
	
	--武装色硬化
	--inst.skillbutton1 = Zg_SkillButton(inst, "images/zg_haki_wzs.xml", "zg_haki_wzs.tex", "zg_haki_wzs.tex",95,37.5,0, "inCD")
	--inst.skillbutton1:Zg_SetTint(0.2,0.2,0.2,1)
	--inst.skillbutton1:Zg_SetColour(1,0,0,1)
    inst.components.zg_keyhandler:AddActionListener("zg_ch2_mihawk", TUNING.MIHAWK.KEY_WZS, "zg_armed")
	
	--见闻色启动
	--inst.skillbutton2 = Zg_SkillButton(inst, "images/zg_haki_jws.xml", "zg_haki_jws.tex", "zg_haki_jws.tex",35,37.5,0, "inCD")
	--inst.skillbutton2:Zg_SetTint(0.2,0.2,0.2,1)
	--inst.skillbutton2:Zg_SetColour(1,0,0,1)
	inst.components.zg_keyhandler:AddActionListener("zg_ch2_mihawk", TUNING.MIHAWK.KEY_JWS, "zg_observation")
	
	--跳跃斩击
	--inst.skillbutton3 = Zg_SkillButton(inst, "images/zg_mihawk_jump.xml", "zg_mihawk_jump.tex", "zg_mihawk_jump.tex",155,37.5,0, "inCD")
	--inst.skillbutton3:Zg_SetTint(0.2,0.2,0.2,1)
	--inst.skillbutton3:Zg_SetColour(1,0,0,1)
	--inst.skillbutton3:Zg_SetString("inCD")
	inst.components.zg_keyhandler:AddActionListener("zg_ch2_mihawk", TUNING.MIHAWK.KEY_TYZ, "zg_mihawk_jump")
	
	--飞鹰飓风
	--inst.skillbutton4 = Zg_SkillButton(inst, "images/zg_mihawk_tornado.xml", "zg_mihawk_tornado.tex", "zg_mihawk_tornado.tex",215,37.5,0, "inCD")
	--inst.skillbutton4:Zg_SetTint(0.2,0.2,0.2,1)
	--inst.skillbutton4:Zg_SetColour(1,0,0,1)
	--inst.skillbutton4:Zg_SetString("inCD")
	inst.components.zg_keyhandler:AddActionListener("zg_ch2_mihawk", TUNING.MIHAWK.KEY_FYJF, "zg_mihawk_tornado")
	
	--技能CD
	inst:AddComponent("timer")
	inst:ListenForEvent("timerdone", function(inst, data)
	
		--技能冷却好时
		if data.name == "_jump" then	
			inst._jump = true
			--inst.skillbutton3:Zg_SetTint(1,1,1,1)
			--inst.skillbutton3:Zg_SetColour(0,1,0,1)
			--inst.skillbutton3:Zg_SetString("C")
		elseif data.name == "_spin" then	
			inst._spin = true
			--inst.skillbutton4:Zg_SetTint(1,1,1,1)
			--inst.skillbutton4:Zg_SetColour(0,1,0,1)
			--inst.skillbutton4:Zg_SetString("V")
		elseif data.name == "_wzs" then
			inst._wzs = true
			--inst.skillbutton1:Zg_SetTint(1,1,1,1)
			--inst.skillbutton1:Zg_SetColour(0,1,0,1)
			--inst.skillbutton1:Zg_SetString("X")
		elseif data.name == "_jws" then
			inst._jws = true
			--inst.skillbutton2:Zg_SetTint(1,1,1,1)
			--inst.skillbutton2:Zg_SetColour(0,1,0,1)
			--inst.skillbutton2:Zg_SetString("Z")
			
		--发招之后
		--elseif data.name == "_jump_ok" then	
			--inst._jump_ok = true
			--inst.skillbutton3:Zg_SetTint(.2,.2,.2,1)
			--inst.skillbutton3:Zg_SetColour(1,0,0,1)
			--inst.skillbutton3:Zg_SetString("inCD")
		--elseif data.name == "_spin_ok" then	
			--inst._spin_ok = true
			--inst.skillbutton4:Zg_SetTint(.2,.2,.2,1)
			--inst.skillbutton4:Zg_SetColour(1,0,0,1)
			--inst.skillbutton4:Zg_SetString("inCD")
		--elseif data.name == "_wzs_ok" then
			--inst._wzs_ok = true
			--inst.skillbutton1:Zg_SetTint(.2,.2,.2,1)
			--inst.skillbutton1:Zg_SetColour(1,0,0,1)
			--inst.skillbutton1:Zg_SetString("inCD")
		--elseif data.name == "_jws_ok" then
			--inst._jws_ok = true
			--inst.skillbutton2:Zg_SetTint(.2,.2,.2,1)
			--inst.skillbutton2:Zg_SetColour(1,0,0,1)
			--inst.skillbutton2:Zg_SetString("inCD")
		end
	end)
	
	if not (inst._jump or inst.components.timer:TimerExists("_jump")) then
		inst.components.timer:StartTimer("_jump", 10)
	end
	if not (inst._spin or inst.components.timer:TimerExists("_spin")) then
		inst.components.timer:StartTimer("_spin", 10)
	end
	if not (inst._wzs or inst.components.timer:TimerExists("_wzs")) then
		inst.components.timer:StartTimer("_wzs", 20)
	end
	if not (inst._jws or inst.components.timer:TimerExists("_jws")) then
		inst.components.timer:StartTimer("_jws", 20)
	end
	
end

local master_postinit = function(inst)
	
	inst.Transform:SetScale(1.25, 1.25, 1.25)
	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	
	inst.components.locomotor.walkspeed = 4 /1.5 * 1.2
	inst.components.locomotor.runspeed = 6 /1.5 * 1.2

    inst.components.combat.damagemultiplier = 1
	
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	inst.transformed = 0
	
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("zg_ch2_mihawk", prefabs, assets, common_postinit, master_postinit, start_inv)





