
local function onequip(inst, owner)
	if owner.prefab == "zg_ch2_mihawk" then
		owner.AnimState:OverrideSymbol("swap_object", "zg_we_blacknight_swap", "zg_we_blacknight_swap")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")
	else
		owner:DoTaskInTime(0, function()
			local inv = owner.components.inventory 
			if inv then
				inv:GiveItem(inst)
			end
			local talker = owner.components.talker 
			if talker then
				talker:Say("I cannot use this black sword!")
			end
		end)
	end
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
	inst.Transform:SetScale(1.25,1.25,1.25)
	
    inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("zg_we_blacknight")
    inst.AnimState:SetBuild("zg_we_blacknight")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
	inst:AddTag("shadow")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/zg_we_blacknight.xml"
	inst.components.inventoryitem.imagename = "zg_we_blacknight"
	inst.components.inventoryitem.nobounce = true
	inst.components.inventoryitem.keepondeath = true

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(68)
	inst.components.weapon:SetRange(2)					--攻击距离+3
	inst.components.weapon:SetOnAttack(function (weapon, attacker, target)
		if target ~= nil then
			
		end
	end)
	
	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 1)
	
	inst:AddComponent("spellcaster")
	
	--
	local function IsWorkAction(action)
		return action == ACTIONS.CHOP
			or action == ACTIONS.DIG
			or action == ACTIONS.HAMMER
			or action == ACTIONS.MINE
	end
	
	function inst.components.spellcaster:CanCast(doer, target, pos)
		if doer == nil or doer.prefab ~= "zg_ch2_mihawk" then
			return false
		elseif self.spell == nil then
			return false
		elseif target == nil then
			if pos == nil then
				return self.canusefrominventory
			end
			return self.canuseonpoint and TheWorld.Map:IsAboveGroundAtPoint(pos:Get())
		elseif target:IsInLimbo()
			or not target.entity:IsVisible()
			or (target.components.health ~= nil and target.components.health:IsDead())
			or (target.sg ~= nil and (
					target.sg.currentstate.name == "death" or
					target.sg:HasStateTag("flight") or
					target.sg:HasStateTag("invisible")
				)) then
			return false
		end
		return self.canuseontargets and (
				(self.canonlyuseonrecipes and AllRecipes[target.prefab] ~= nil) or
				(self.canonlyuseonlocomotors and target.components.locomotor ~= nil and (TheNet:GetPVPEnabled() or not (target:HasTag("player") and doer:HasTag("player")))) or
				(self.canonlyuseonworkable and target.components.workable ~= nil and target.components.workable:CanBeWorked() and IsWorkAction(target.components.workable:GetWorkAction())) or
				(self.canonlyuseoncombat and doer.components.combat ~= nil and doer.components.combat:CanTarget(target))
			)
	end
	
	inst.components.spellcaster.canuseonpoint = true
    inst.components.spellcaster.canuseontargets = true
	inst.components.spellcaster.canonlyuseonrecipes = true
	inst.components.spellcaster.canonlyuseonlocomotors = true
    inst.components.spellcaster.canonlyuseonworkable = true
    inst.components.spellcaster.canonlyuseoncombat = true
    inst.components.spellcaster.quickcast = true
	
    inst.components.spellcaster:SetSpellFn( function(staff, target, pos)
		local owner = inst.components.inventoryitem.owner
		if owner then
			--owner:PushEvent("zg_mihawk_jump", {pos = target and target:GetPosition() or pos})
			local fx = SpawnPrefab("zg_mihawk_jq")
			if fx then
			
				fx.master = owner
				local x,y,z = inst:GetPosition():Get()
				fx.Transform:SetPosition(x, 0, z)
				fx.Transform:SetRotation( owner.Transform:GetRotation() )
				fx.Physics:SetMotorVelOverride(10,0,0)
				--inst.SoundEmitter:PlaySound("dontstarve/wilson/zg_mihawk_jq")
				
				if owner.components.hunger then
					owner.components.hunger:DoDelta(-5)
				end
				if owner.components.health then
					owner.components.health:DoDelta(-2)
				end
				
			end
			
		end
	end)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    return inst
end

return Prefab("zg_we_blacknight", fn)