
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/ace.zip" ),
        Asset( "ANIM", "anim/ghost_ace_build.zip" ),
}
local prefabs = {"acehat",
}

local start_inv = {
	-- Custom starting items
	"acehat"
}

local function RestoreLight(inst)
    inst.Light:Enable(true)
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.6)
    inst.Light:SetIntensity(0.9)
    inst.Light:SetColour(255/255,102/155,0/255)
end

-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "ace.tex" )
end
 
local function startfirebug(inst)
    inst.components.firebug:Enable()
end

local function stopfirebug(inst)
    inst.components.firebug:Disable()
end

local function sanityfn(inst)
	local x,y,z = inst.Transform:GetWorldPosition()	
	local delta = 0
	local max_rad = 10
	local ents = TheSim:FindEntities(x,y,z, max_rad, {"fire"})
    for k,v in pairs(ents) do 
    	if v.components.burnable and v.components.burnable.burning then
    		local sz = TUNING.SANITYAURA_TINY
    		local rad = v.components.burnable:GetLargestLightRadius() or 1
    		sz = sz * ( math.min(max_rad, rad) / max_rad )
			local distsq = inst:GetDistanceSqToInst(v)
			delta = delta + sz/math.max(1, distsq)
    	end
    end

    return delta
end

local function onattack_red(attacker, target)
  
    if target.components.burnable and not target.components.burnable:IsBurning() then
        if target.components.freezable and target.components.freezable:IsFrozen() then        
            target.components.freezable:Unfreeze()         
        else         
            target.components.burnable:Ignite(true, attacker)
        end
    end
   
    if target.components.freezable then
        target.components.freezable:AddColdness(-1) --Does this break ice staff?
        if target.components.freezable:IsFrozen() then
            target.components.freezable:Unfreeze()         
        end
    end
   
    if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end
   
    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
        if target.sg and target.sg.sg.states.hit and not target:HasTag("player") then
            target.sg:GoToState("hit")
        end
    end
   
    attacker.SoundEmitter:PlaySound("dontstarve/wilson/fireball_explo")
    target:PushEvent("attacked", {attacker = attacker, damage = 0})
end
  
local function DoCustomAttack(inst, targ, weapon)
      
    if inst.components.combat:CanHitTarget(targ, weapon) then
        inst:PushEvent("onattackother", {target = targ, weapon = weapon})
  
        local damage = inst.components.combat:CalcDamage(targ, weapon)
        targ.components.combat:GetAttacked(inst, damage, weapon)
        onattack_red(inst, targ)
          
        if weapon then
            weapon.components.weapon:OnAttack(inst, targ)
        end
        inst.components.combat.lastdoattacktime = GetTime()
    end
end


-- This initializes for the host only
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "wilson"
	-- Stats	
	inst.components.health.fire_damage_scale = 0
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
    inst.components.sanity.custom_rate_fn = sanityfn
	inst.components.combat.damagemultiplier = 1.3
	inst.components.sanity.night_drain_mult = 1
	inst.components.sanity.neg_aura_mult = 1
	
	inst.components.temperature.mintemp = 20
	
	inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.6)
    inst.Light:SetIntensity(0.9)
    inst.Light:SetColour(255/255,102/155,0/255)
	
	inst:AddComponent("firebug")
    inst.components.firebug.prefab = "willowfire"
	inst.components.firebug.sanity_threshold = TUNING.WILLOW_LIGHTFIRE_SANITY_THRESH
	
	inst:ListenForEvent("ms_respawnedfromghost", RestoreLight)

    inst:ListenForEvent("ms_respawnedfromghost", startfirebug)
    inst:ListenForEvent("ms_becameghost", stopfirebug)
    inst:ListenForEvent("death", stopfirebug)

    startfirebug(inst)
	
	local old_DoAttack = inst.components.combat.DoAttack
    inst.components.combat.DoAttack = function(self, target_override, weapon, projectile)
     
        local targ = target_override or self.target
        local weapon = weapon or self:GetWeapon()
         
        if not weapon then
            DoCustomAttack(inst, targ, weapon)
        else
            return old_DoAttack(self, target_override, weapon, projectile)
        end
    end
	
end

return MakePlayerCharacter("ace", prefabs, assets, common_postinit, master_postinit, start_inv)
