--资源文件
local assets=
{   -- 这个是放在地上的动画文件
	Asset("ANIM", "anim/loongysword.zip"),
	-- 这个是手上动画
	Asset("ANIM", "anim/swap_loongysword.zip"),
	-- 物品栏图标的xml
	Asset("IMAGE", "images/inventoryimages/loongysword.tex"),
	-- 物品栏图标的图片
	Asset("ATLAS", "images/inventoryimages/loongysword.xml"),
}
--事件-耐久为零
local function onfinished(inst)

	--删除物品
    --inst:Remove()
end

--事件-装备武器
local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_loongysword", "swap_loongysword")
	--owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")   
	-- 显示持物手
    owner.AnimState:Show("ARM_carry")
	--隐藏普通的手
    owner.AnimState:Hide("ARM_normal")
end

--事件-取消装备
local function onunequip(inst, owner)
    --显示持物手
    owner.AnimState:Hide("ARM_carry")
	--隐藏普通的手
    owner.AnimState:Show("ARM_normal")
end

--初始化
local function fn(Sim)
    -- 创建一个实体，常见的各种inst，根源就是在这里。
	local inst = CreateEntity()
	-- 给实体添加转换组件，这主要涉及的是空间位置的转换和获取
	local trans = inst.entity:AddTransform()
	-- 给实体添加动画组件，从而实体能在游戏上显示出来
	local anim = inst.entity:AddAnimState()
	-- 给实体设定为"物品"的物理属性，这是一个写在data\scripts\standardcomponents里的标准函数，
    -- 类似的还有MakeCharacterPhysics，就是设定"人物"的物理属性，基本上所有会动的生物，都会有MakeCharacterPhysics
    MakeInventoryPhysics(inst)
	
    -- 放在地上
    inst.AnimState:SetBank("loongysword")--设置实体的bank，此处是指放在地上的时候，下同
    inst.AnimState:SetBuild("loongysword")--设置实体的build
	anim:PlayAnimation("idle")--设置实体播放的动画
		
	--添加标签	
    inst:AddTag("sharp")
	
    -- 添加伤害组件
	inst:AddComponent("weapon")
	-- 攻击力
    inst.components.weapon:SetDamage(TUNING.gjl)
    --设置有限使用
    inst:AddComponent("finiteuses")
	--设置使用次数
    inst.components.finiteuses:SetMaxUses(TUNING.use)
    inst.components.finiteuses:SetUses(TUNING.use)
	inst:ListenForEvent("percentusedchange", function(inst,data)
		local percent = data.percent
		if percent <= 0 then
			inst.components.weapon:SetDamage(10)
		else
			inst.components.weapon:SetDamage(TUNING.gjl)
			if percent > 1 then
				inst.components.finiteuses:SetUses(TUNING.use)
			end
		end
	end)
    -- 耐久为零事件
    inst.components.finiteuses:SetOnFinished( onfinished )
	
    -- 可以执行检查操作
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/loongysword.xml"
	
    -- 添加可装备组件，有了这个组件，你才能装备物品
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(function(inst, item) return item and item.prefab == "nightmarefuel" or item and item.prefab == "goldnugget" end)
    inst.components.trader.onaccept=function(inst,giver,item)
	local finiteuses=inst.components.finiteuses
	finiteuses:SetUses(math.min(finiteuses.current+TUNING.n*finiteuses.total,finiteuses.total))
	end
    inst.components.trader.onrefuse=function(inst,giver,item) if giver.components.talker then giver.components.talker:Say("需要猪皮修复耐久") end end
    
    return inst
end

return Prefab( "common/inventory/loongysword", fn, assets)