local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local TECH = GLOBAL.TECH

PrefabFiles = {
	"inori",
	"xk",
	"zxk",
	"licking",
	"licking_eyebone",
	"books",
	"sweet_n_sour",
	"dress1",
	"inorihat",
	"inorihouse",
	"turf_asia",
	"turf_orient",
	"turf_flamerose",
	"turf_tilecheckerboard",
	"turf_tilefrosty",
	"turf_tilesquares",
	"musha_cargo",
	
}

Assets = {

    Asset( "IMAGE", "images/map_icons/inori.tex" ),
    Asset( "ATLAS", "images/map_icons/inori.xml" ),

    Asset("IMAGE", "images/inventoryimages/xk.tex"),
    Asset("ATLAS", "images/inventoryimages/xk.xml"),
	Asset("IMAGE", "images/inventoryimages/zxk.tex"),
    Asset("ATLAS", "images/inventoryimages/zxk.xml"),

    Asset( "IMAGE", "images/saveslot_portraits/inori.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/inori.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/inori_silho.tex" ),
    Asset( "IMAGE", "bigportraits/inori.tex" ),

    Asset( "ATLAS", "images/saveslot_portraits/inori.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/inori.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/inori_silho.xml" ),
    Asset( "ATLAS", "bigportraits/inori.xml" ),
    
	Asset("ATLAS", "images/inventoryimages/licking_eyebone.xml"),
	Asset("BRAIN", "scripts/brains/lickingbrain.lua"),

	Asset("ATLAS", "images/map_icons/licking.xml"),
	Asset("IMAGE", "images/map_icons/licking.tex"),

	Asset("ATLAS", "images/map_icons/licking_eyebone.xml"),
	Asset("IMAGE", "images/map_icons/licking_eyebone.tex"),
	
	--Ǹͼõ
	Asset( "ATLAS", "images/tabs/inoritab.xml" ),
	Asset( "IMAGE", "images/tabs/inoritab.tex" ),
	
	--ʳ
	Asset("ANIM", "anim/sweet_n_sour.zip"),
	Asset( "IMAGE", "images/inventoryimages/sweet_n_sour.tex" ),
	Asset( "ATLAS", "images/inventoryimages/sweet_n_sour.xml" ),
	
	Asset("ANIM", "anim/dress1.zip"),
	Asset( "IMAGE", "images/inventoryimages/dress1.tex" ),
	Asset( "ATLAS", "images/inventoryimages/dress1.xml" ),
	
	Asset("ANIM", "anim/inorihat.zip"),
	Asset( "IMAGE", "images/inventoryimages/inorihat.tex" ),
	Asset( "ATLAS", "images/inventoryimages/inorihat.xml" ),
	
	Asset("ANIM", "anim/inorihouse.zip"),
    Asset("IMAGE", "images/inventoryimages/inorihouse.tex"),
    Asset("ATLAS", "images/inventoryimages/inorihouse.xml"),
	
	Asset( "ANIM", "anim/inori_turf.zip" ),
	Asset( "ATLAS", "images/inventoryimages/turf_asia.xml" ),
	Asset( "ATLAS", "images/inventoryimages/turf_orient.xml" ),
	Asset( "ATLAS", "images/inventoryimages/turf_flamerose.xml" ),
	
	Asset("ATLAS", "images/inventoryimages/tilecheckerboard.xml"),
	Asset("ATLAS", "images/inventoryimages/tilefrosty.xml"),
	Asset("ATLAS", "images/inventoryimages/tilesquares.xml"),
	
	Asset("ANIM", "anim/musha_cargo_build.zip"),
	Asset( "IMAGE", "images/inventoryimages/musha_cargo.tex" ),
	Asset( "ATLAS", "images/inventoryimages/musha_cargo.xml" ),	

}

--̨----------------------------------------------------------------------------------------------------
local function InoriMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "inori" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/disappear",	
            voice = "dontstarve/maxwell/talk_LP_world2",
            appearanim = "appear2",
            idleanim = "idle2_loop",
            dialogpreanim = "dialog2_pre",
            dialoganim ="dialog2_loop",
            dialogpostanim = "dialog2_pst",
            disappearanim = "disappear2",
            disableplayer = true,
            skippable = true,
            {
                string = ",INORI, ƺ״̬̫",
                wait = 2.5,
                anim = nil,
                sound = nil,
            },
			{
                string = ", ʱ!",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "ոʲô ҷ·ô籾!!!",
                wait = 3,
                anim = nil,
                sound = nil,
            },
			{
                string = ",ұӦ˵ʲôţ",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = " ˲!ף~",
                wait = 4,
                anim = nil,
                sound = nil,
            },
        }
    end
end

AddPrefabPostInit("maxwellintro", InoriMaxwellIntro)
----------------------------------------------------------------------------------------------------

--pre-set the settings
GLOBAL.require 'screens.lickingsettings'
GetPlayer = GLOBAL.GetPlayer
IsHUDPaused = GLOBAL.IsPaused
TheInput = GLOBAL.TheInput
TheFrontEnd = GLOBAL.TheFrontEnd
TheSim = GLOBAL.TheSim
TUNING = GLOBAL.TUNING
FirstOption = true

local function IcanTALK(inst)
	local Option = GetModConfigData("They Can Talk")
	if Option == 1 then
		inst:AddComponent("talker")
		inst.components.talker.ontalk = ontalk
		inst.components.talker.fontsize = 35
		inst.components.talker.font = TALKINGFONT
		--inst.components.talker.offset = Vector3(0,-400,0)
	end
end

AddPrefabPostInit("licking", IcanTALK)

--********************TUNINGS*********************************
	TUNING.LICKING_HEALTH = GetModConfigData("Licking's Health")
	TUNING.LICKING_WALK_SPEED = 24
--************************************************************

--Added a new settings for lickings
--Settings
settingskey = GLOBAL.KEY_P
tpg = 0
tocutcode = true --Warning! Don't change it to false!


local function SettingsUpd(component)
	local original_OnUpdate = component.OnUpdate
	component.OnUpdate = function(self, dt)
		original_OnUpdate(self, dt)
		if not self:IsEnabled() then return end
		local player = GetPlayer()
		local ObjLicking = TheSim:FindFirstEntityWithTag("licking")
		local ObjLickingBone = TheSim:FindFirstEntityWithTag("licking_eyebone")
		
		local Profile = GLOBAL.Profile
		if not Profile then return end
		
		--//֧ӧѧ ߧѧۧܧ
		if tocutcode then
		if Profile:GetValue("following") then
		FirstOption = false
		end
		if not Profile:GetValue("following") then
		FirstOption = true
		end
		end
		--//ѧ ߧѧۧܧ
		if tocutcode then
		if Profile:GetValue("lickingcantdie") then
			if ObjLicking and not ObjLicking:HasTag("immortal") then
				ObjLicking:AddTag("immortal")
				ObjLicking.SoundEmitter:PlaySound("dontstarve/creatures/slurper/jump")
				if ObjLicking.components.talker then ObjLicking.components.talker:Say(STRINGS.LICKING_TALK_IMMORTAL) end
			end
		end
		if not Profile:GetValue("lickingcantdie") then
			if ObjLicking and ObjLicking:HasTag("immortal") then
				ObjLicking:RemoveTag("immortal")
			end
		end
		
		if Profile:GetValue("lickingcantdie") then
			if ObjLicking then
				ObjLicking.components.health:DoDelta(ObjLicking.components.health.maxhealth, true)
			end
		end
		end
		
	end
end
AddComponentPostInit("playercontroller", SettingsUpd)

SettingsKeyHandler = Class(function(self)   
    self.handler = TheInput:AddKeyHandler(function(key, down) self:OnRawKey(key, down) end )
end)

function SettingsKeyHandler:OnRawKey(key, down)
	if IsHUDPaused() or not GetPlayer() then return end
	if (key == settingskey and not down) then
		GLOBAL.TheFrontEnd:PushScreen(GLOBAL.LickingSettings())
	end
end
LickingSettings = SettingsKeyHandler()

function TableContains(table, val)
	if not table and not val then return end
	for k,v in pairs(table) do
		if v == val then return true end
	end
	return false
end


if GetModConfigData("Language") == true then
GLOBAL.STRINGS.CHARACTER_TITLES.inori = "inori"
GLOBAL.STRINGS.CHARACTER_NAMES.inori = "inori"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.inori = "1.2ٶ \nԴմ󽣡³\nרƼ"
GLOBAL.STRINGS.CHARACTER_QUOTES.inori = "\"ģ\""

GLOBAL.STRINGS.NAMES.XK = "մ"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.XK = "ҸеĪı "
GLOBAL.STRINGS.RECIPE_DESC.XK = "մ "

GLOBAL.STRINGS.NAMES.ZXK = ".մ"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZXK = "ҸеĪı "
GLOBAL.STRINGS.RECIPE_DESC.ZXK = ".մ "

GLOBAL.STRINGS.NAMES.SWEET_N_SOUR = "ķ"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SWEET_N_SOUR = "е"
GLOBAL.STRINGS.RECIPE_DESC.SWEET_N_SOUR = "е"

GLOBAL.STRINGS.NAMES.DRESS1 = "װ"
GLOBAL.STRINGS.RECIPE_DESC.DRESS1 = "+ͱ"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.DRESS1 = "Ư"

GLOBAL.STRINGS.NAMES.INORIHAT = ""
GLOBAL.STRINGS.RECIPE_DESC.INORIHAT = "!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.INORIHAT = "˼!"

STRINGS.NAMES.INORIHOUSE = "С"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.INORIHOUSE = "װƷ."
STRINGS.RECIPE_DESC.INORIHOUSE = "ԭؽ"

STRINGS.NAMES.TURF_ASIA = "!!!"
STRINGS.RECIPE_DESC.TURF_ASIA = "ҵĹ!!!!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_ASIA = "ô..."

STRINGS.NAMES.TURF_FLAMEROSE = ""
STRINGS.RECIPE_DESC.TURF_FLAMEROSE = "ɫذ!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_FLAMEROSE = "󺣰ĸ~!!"

STRINGS.NAMES.TURF_ORIENT = "й"
STRINGS.RECIPE_DESC.TURF_ORIENT = "й!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_ORIENT = "й·~!"

--Tile
GLOBAL.STRINGS.NAMES.TURF_TILECHECKERBOARD = "ɫذ"
STRINGS.RECIPE_DESC.TURF_TILECHECKERBOARD = "ɫ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_TILECHECKERBOARD = "öɫذ..."

GLOBAL.STRINGS.NAMES.TURF_TILEFROSTY = "ѩذ"
STRINGS.RECIPE_DESC.TURF_TILEFROSTY = "ɫѩ~"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_TILEFROSTY = "ɫذ?..."

GLOBAL.STRINGS.NAMES.TURF_TILESQUARES = "ƴͼ"
STRINGS.RECIPE_DESC.TURF_TILESQUARES = "6*6ƴ.з."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_TILESQUARES = "氮ܲƴһ"

STRINGS.NAMES.LICKING = "Fyu-Neru"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LICKING = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LICKING.GENERIC = "My Fyu-Neru!"

STRINGS.RECIPE_DESC.LICKING_EYEBONE = "The FirsT EPIC gift from the Sky"
STRINGS.NAMES.LICKING_EYEBONE = "Fyu-Neru"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.LICKING_EYEBONE = "ԲٿFyu-Neru~"

STRINGS.NAMES.MUSHA_CARGO = "ͿװĻ"
STRINGS.RECIPE_DESC.MUSHA_CARGO = "inoriĻ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_CARGO = "޺õĵһҴ."

end

--------------------------------------------------------

if GetModConfigData("Language") == false then
GLOBAL.STRINGS.CHARACTER_TITLES.inori = "The Character INORI"
GLOBAL.STRINGS.CHARACTER_NAMES.inori = "Inori"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.inori = "*Run and hungry faster \n*Has a robot pet\n*Has exclusive items"
GLOBAL.STRINGS.CHARACTER_QUOTES.inori = "\"A cartoon character who is my favorite\""

GLOBAL.STRINGS.NAMES.XK = "Void"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.XK = "I feel a sense of sadness when holding it. "
GLOBAL.STRINGS.RECIPE_DESC.XK = "Void "

GLOBAL.STRINGS.NAMES.ZXK = "EX.Void"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZXK = "I feel a sense of sadness when holding it. "
GLOBAL.STRINGS.RECIPE_DESC.ZXK = "EX.Void "

GLOBAL.STRINGS.NAMES.SWEET_N_SOUR = "rice ball"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SWEET_N_SOUR = "Make to eat"
GLOBAL.STRINGS.RECIPE_DESC.SWEET_N_SOUR = "Make to eat"

GLOBAL.STRINGS.NAMES.DRESS1 = "Inori's clothes"
GLOBAL.STRINGS.RECIPE_DESC.DRESS1 = "Make Heatstroke Refrigerator"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.DRESS1 = "Is this dress beautiful"

GLOBAL.STRINGS.NAMES.INORIHAT = "Inori's Crown"
GLOBAL.STRINGS.RECIPE_DESC.INORIHAT = "Crown!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.INORIHAT = "It reminds me of him!"

STRINGS.NAMES.INORIHOUSE = "Inori's house"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.INORIHOUSE = "house."
STRINGS.RECIPE_DESC.INORIHOUSE = "bulid here"

STRINGS.NAMES.TURF_ASIA = "NO!!!"
STRINGS.RECIPE_DESC.TURF_ASIA = "NO!NO!!NO!!!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_ASIA = "What the ..."

STRINGS.NAMES.TURF_FLAMEROSE = "Bule"
STRINGS.RECIPE_DESC.TURF_FLAMEROSE = "Bule!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_FLAMEROSE = "it is beautiful floor!"

STRINGS.NAMES.TURF_ORIENT = "China"
STRINGS.RECIPE_DESC.TURF_ORIENT = "China!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_ORIENT = "Wow! Beautiful!"

--Tile
GLOBAL.STRINGS.NAMES.TURF_TILECHECKERBOARD = "blue"
STRINGS.RECIPE_DESC.TURF_TILECHECKERBOARD = "blue."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_TILECHECKERBOARD = "looks strange"

GLOBAL.STRINGS.NAMES.TURF_TILEFROSTY = "snow"
STRINGS.RECIPE_DESC.TURF_TILEFROSTY = "snow~"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_TILEFROSTY = "I like snow"

GLOBAL.STRINGS.NAMES.TURF_TILESQUARES = "Puzzle"
STRINGS.RECIPE_DESC.TURF_TILESQUARES = "6*6.Have direction."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TURF_TILESQUARES = "For INORI's lover"

STRINGS.NAMES.LICKING = "Fyu-Neru"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LICKING = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LICKING.GENERIC = "My Fyu-Neru!"

STRINGS.RECIPE_DESC.LICKING_EYEBONE = "The FirsT EPIC gift from the Sky"
STRINGS.NAMES.LICKING_EYEBONE = "Fyu-Neru"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.LICKING_EYEBONE = "Come on Fyu-Neru~"

STRINGS.NAMES.MUSHA_CARGO = "Inoris cargo ship"
STRINGS.RECIPE_DESC.MUSHA_CARGO = "Inoris cargo ship"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHA_CARGO = "~."

end

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "inori")

---------------------------------------------------------------------------------õ̺
local INORI_TURFS = { [GLOBAL.GROUND.ASIA] = "turf_asia", [GLOBAL.GROUND.ORIENT] = "turf_orient", [GLOBAL.GROUND.FLAMEROSE] = "turf_flamerose", [GLOBAL.GROUND.TILECHECKERBOARD] = "turf_tilecheckerboard", [GLOBAL.GROUND.TILEFROSTY] = "turf_tilefrosty", [GLOBAL.GROUND.TILESQUARES] = "turf_tilesquares", }
AddComponentPostInit("terraformer", function(self)
local function SpawnTurf(turf, pt)
    if turf then
        local loot = GLOBAL.SpawnPrefab(turf)
        loot.Transform:SetPosition(pt.x, pt.y, pt.z)
        if loot.Physics then
            local angle = math.random()*2*GLOBAL.PI
            loot.Physics:SetVel(2*math.cos(angle), 10, 2*math.sin(angle))
        end
    end
end
local _Terraform = self.Terraform
self.Terraform = function(self, pt)
    if self:CanTerraformPoint(pt) == false then
        return false
    end
    local ground = GLOBAL.GetWorld()
    local original_tile_type = ground.Map:GetTileAtPoint(pt.x, pt.y, pt.z)
    local ret = _Terraform(self, pt)
    if ret == true then
        local turf_prefab = INORI_TURFS[original_tile_type] 
        if turf_prefab ~= nil then
            SpawnTurf(turf_prefab, pt) 
        end
        return true
    end
    return false
end end)
--

function AddMap(inst)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( inst.prefab .. ".tex" )
end


AddMinimapAtlas("images/map_icons/inori.xml")
AddMinimapAtlas("images/map_icons/licking_eyebone.xml")
AddMinimapAtlas("images/map_icons/licking.xml")

AddPrefabPostInit("inorihouse", AddMap)
AddMinimapAtlas("images/inventoryimages/inorihouse.xml")

AddPrefabPostInit("sweet_n_sour", AddMap)
AddMinimapAtlas("images/inventoryimages/sweet_n_sour.xml")

AddMinimapAtlas("images/inventoryimages/musha_cargo.xml")

AddModCharacter("inori")

