local assets=
{
	Asset("ANIM", "anim/dress1.zip"),
	Asset("IMAGE", "images/inventoryimages/dress1.tex"),
	Asset("ATLAS", "images/inventoryimages/dress1.xml"),
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "dress1", "swap_body")
	owner.components.inventory:SetOverflow(inst)
    inst.components.container:Open(owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner.components.inventory:SetOverflow(nil)
    inst.components.container:Close(owner)
end

local slotpos = {}

for y = 0, 6 do
    table.insert(slotpos, Vector3(-162, -y*75 + 240 ,0))
	table.insert(slotpos, Vector3(-162 +75, -y*75 + 240 ,0))
end

local function onfinish(inst)
	inst.components.container:DropEverything()
    inst.components.container:Close()
	inst:Remove()
end


local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("torso_rain")
    inst.AnimState:SetBuild("dress1")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddComponent("inspectable")
	inst:AddTag("fridge")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/dress1.xml"

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable.insulated = true
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("armor")
    inst.components.armor:InitCondition(77777777777, 0.77)
	
	local player = GetPlayer()
if not IsDLCEnabled(REIGN_OF_GIANTS) then
    MakeInventoryFloatable(inst, "idle_water", "anim")
    inst.components.equippable.poisonblocker = true
	inst:AddComponent("windproofer")
	inst.components.windproofer:SetEffectiveness(TUNING.WINDPROOFNESS_ABSOLUTE) 
end
	
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_LARGE)
    inst.components.insulator:SetSummer()

	
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_krampusbag_2x8"
    inst.components.container.widgetanimbuild = "ui_krampusbag_2x8"
    inst.components.container.widgetpos = Vector3(-5,-120,0)
    inst.components.container.side_widget = true    
    inst.components.container.type = "pack"
    
    return inst
end

return Prefab( "common/inventory/dress1", fn, assets) 
