
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/willow.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/inori.zip" ),
		-- Don't forget to include your character's custom assets!
       
}

local prefabs = {
        "book_birds",
        "book_tentacles",
        "book_gardening",
        "book_sleep",
        "book_brimstone",
}

local prefabs = {}
--初始物品----------------------------------------------------------------------------------------------------
local start_inv = 
{
	"xk",
	"licking_eyebone",
	
}

--升级代码----------------------------------------------------------------------------------------------------
local function applyupgrades(inst)

	local max_upgrades = 500
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (77 + upgrades * 0.4) --277
	inst.components.health.maxhealth = math.ceil (77 + upgrades * 0.4) --277
	inst.components.sanity.max = math.ceil (177 + upgrades * 0.4) --377
	inst.components.talker:Say(" - -b  Level Up! : ".. (inst.level))
	
	if inst.level >449 then
		inst.components.talker:Say("OTL Level : Max!")
	end

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
	
end

local function oneat(inst, food)
	
	if food and food.components.edible.foodtype == "MEAT" then
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
end

local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end

--专属制作栏----------------------------------------------------------------------------------------------------
local function CustomRecipe()
	--制作栏图标
	    RECIPETABS['INORITAB'] = {str = "INORITAB", sort= 99998127, icon = "inoritab.tex", icon_atlas = "images/tabs/inoritab.xml"}
	--专属食物
	    local sweet_n_sour = Recipe("sweet_n_sour", { Ingredient("berries", 4), Ingredient("seeds_cooked", 3) }, RECIPETABS.INORITAB, TECH.NONE)
        sweet_n_sour.atlas = "images/inventoryimages/sweet_n_sour.xml"
	--虚空大剑
	    local xkRecipe = Recipe("xk", {Ingredient("goldnugget", 1),Ingredient("transistor", 1)}, RECIPETABS.INORITAB, TECH.NONE)
	    xkRecipe.atlas = "images/inventoryimages/xk.xml"
	--真虚空大剑
	    local zxkRecipe = Recipe("zxk", {Ingredient("xk", 1,"images/inventoryimages/xk.xml"),Ingredient("nightsword", 1),Ingredient("cane", 1)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE)
	    zxkRecipe.atlas = "images/inventoryimages/zxk.xml"
	--专属衣服
		local dress1 = Recipe("dress1", {Ingredient("feather_robin", 7),Ingredient("hawaiianshirt", 1),Ingredient("reflectivevest", 1),Ingredient("icehat", 1) }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE)
	    dress1.atlas = "images/inventoryimages/dress1.xml"
	--专属帽子
	    local inorihat = Recipe("inorihat", {Ingredient("goldnugget", 7),Ingredient("transistor", 7),Ingredient("nightmarefuel", 7)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE)
	    inorihat.atlas = "images/inventoryimages/inorihat.xml"
	--专属房子
	    --local inorihouse = Recipe("inorihouse", {Ingredient("boards", 30), Ingredient("cutstone", 30), Ingredient("purplegem", 5)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE)
        --inorihouse.atlas = "images/inventoryimages/inorihouse.xml"
	if IsDLCEnabled(CAPY_DLC) and SaveGameIndex:IsModeShipwrecked() then 
	--专属地皮
		local Turf_Asia = Recipe( "turf_asia", {  Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		Turf_Asia.atlas = "images/inventoryimages/turf_asia.xml"
		local Turf_Orient = Recipe( "turf_orient", {  Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		Turf_Orient.atlas = "images/inventoryimages/turf_orient.xml"
		local Turf_Flame_Rose = Recipe( "turf_flamerose", {  Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		Turf_Flame_Rose.atlas = "images/inventoryimages/turf_flamerose.xml"
	--新专属地皮
	    local turf_tilecheckerboard = Recipe("turf_tilecheckerboard", {Ingredient("limestone", 2), Ingredient("goldnugget", 1)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		turf_tilecheckerboard.atlas = "images/inventoryimages/tilecheckerboard.xml"
		turf_tilecheckerboard.image="tilecheckerboard.tex"

		local turf_tilefrosty = Recipe("turf_tilefrosty", {Ingredient("limestone", 2), Ingredient("goldnugget", 1)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		turf_tilefrosty.atlas = "images/inventoryimages/tilefrosty.xml"
		turf_tilefrosty.image="tilefrosty.tex"

		local turf_tilesquares = Recipe("turf_tilesquares", {Ingredient("limestone", 2), Ingredient("goldnugget", 1)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		turf_tilesquares.atlas = "images/inventoryimages/tilesquares.xml"
		turf_tilesquares.image="tilesquares.tex"
		
		----boat
        local musha_cargo = Recipe("musha_cargo", { Ingredient("livinglog", 10), Ingredient("boards", 8), Ingredient("rope", 6), }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, "musha_cargo_placer", nil, nil, nil, true, 4) 
	    musha_cargo.atlas = "images/inventoryimages/musha_cargo.xml"
		
	else
	--专属地皮
		local Turf_Asia = Recipe( "turf_asia", {  Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		Turf_Asia.atlas = "images/inventoryimages/turf_asia.xml"
		local Turf_Orient = Recipe( "turf_orient", {  Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		Turf_Orient.atlas = "images/inventoryimages/turf_orient.xml"
		local Turf_Flame_Rose = Recipe( "turf_flamerose", {  Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		Turf_Flame_Rose.atlas = "images/inventoryimages/turf_flamerose.xml"
	--新专属地皮
	    local turf_tilecheckerboard = Recipe("turf_tilecheckerboard", {Ingredient("beefalowool", 2), Ingredient("goldnugget", 1)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		turf_tilecheckerboard.atlas = "images/inventoryimages/tilecheckerboard.xml"
		turf_tilecheckerboard.image="tilecheckerboard.tex"

		local turf_tilefrosty = Recipe("turf_tilefrosty", {Ingredient("beefalowool", 2), Ingredient("goldnugget", 1)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		turf_tilefrosty.atlas = "images/inventoryimages/tilefrosty.xml"
		turf_tilefrosty.image="tilefrosty.tex"

		local turf_tilesquares = Recipe("turf_tilesquares", {Ingredient("beefalowool", 2), Ingredient("goldnugget", 1)}, RECIPETABS.INORITAB, TECH.SCIENCE_ONE, nil, nil, nil, 1 )
		turf_tilesquares.atlas = "images/inventoryimages/tilesquares.xml"
		turf_tilesquares.image="tilesquares.tex"
		
	end	

	end

--人物能力----------------------------------------------------------------------------------------------------
local fn = function(inst)
	inst.soundsname = "willow"
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("inori.tex")

	inst.level = 0
	table.insert(inst.components.eater.foodprefs, "MEAT")
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	
	inst.components.health:SetMaxHealth(77)
	inst.components.sanity:SetMax(177)
	inst.components.hunger:SetMax(77)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.2)
	inst.components.combat.damagemultiplier = 1
	inst.components.health:StartRegen(7, 77)
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	inst:AddComponent("reader")
	
	--人物变身----------------------------------------------------------------------------------------------------
	inst:ListenForEvent("sanitydelta", function(inst, data)
        if data.newpercent >= .23 then
        inst.AnimState:SetBuild("inori")
		inst.components.combat.damagemultiplier = 1
		inst.components.locomotor.runspeed = 6
		inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.2)

        else
	    inst.AnimState:SetBuild("inori")
		inst.components.combat.damagemultiplier = 2
	    inst.components.locomotor.runspeed = 12
	    inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*7)
        end
    end)
	
	--图书制作栏----------------------------------------------------------------------------------------------------
	local booktab = {str = STRINGS.TABS.BOOKS, sort=999, icon = "tab_book.tex"}
	inst.components.builder:AddRecipeTab(booktab)

	Recipe("book_birds", {Ingredient("papyrus", 2), Ingredient("bird_egg", 2)}, booktab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	Recipe("book_gardening", {Ingredient("papyrus", 2), Ingredient("seeds", 1), Ingredient("poop", 1)}, booktab, {SCIENCE = 1})
	Recipe("book_sleep", {Ingredient("papyrus", 2), Ingredient("nightmarefuel", 2)}, booktab, {SCIENCE = 1})
	Recipe("book_brimstone", {Ingredient("papyrus", 2), Ingredient("redgem", 1)}, booktab, {SCIENCE = 1})
	Recipe("book_tentacles", {Ingredient("papyrus", 2), Ingredient("tentaclespots", 1)}, booktab, {SCIENCE = 1})
	
	--再次添加专属制作栏----------------------------------------------------------------------------------------------------
	CustomRecipe()
	
	TheInput:AddKeyUpHandler(KEY_F12, function()
	    inst.components.talker:Say(" - -b  Level Up! : ".. (inst.level))
	end)
	
end


return MakePlayerCharacter("inori", prefabs, assets, fn , start_inv)
