require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/inorihouse.zip"),
	Asset("ATLAS", "images/inventoryimages/inorihouse.xml")
}


local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end

local function onfinished(inst)
	inst.AnimState:PlayAnimation("hit")
	inst:ListenForEvent("animover", function(inst, data) inst:Remove() end)
	inst.SoundEmitter:PlaySound("dontstarve/common/tent_dis_pre")
	inst.persists = false
	inst:DoTaskInTime(16*FRAMES, function() inst.SoundEmitter:PlaySound("dontstarve/common/tent_dis_twirl") end)
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:PushAnimation("idle", true)
end

local function onsleep(inst, sleeper)
	
	local hounded = GetWorld().components.hounded

	local danger = FindEntity(inst, 10, function(target) return target:HasTag("monster") or target.components.combat and target.components.combat.target == inst end)
	
	if hounded and (hounded.warning or hounded.timetoattack <= 0) then
		danger = true
	end
	
	if danger then
		if sleeper.components.talker then
			sleeper.components.talker:Say(GetString(sleeper.prefab, "ANNOUNCE_NODANGERSLEEP"))
		end
		return
	end

	if sleeper.components.hunger.current < TUNING.CALORIES_MED then
		sleeper.components.talker:Say(GetString(sleeper.prefab, "ANNOUNCE_NOHUNGERSLEEP"))
		return
	end
	
	sleeper.components.health:SetInvincible(true)
	sleeper.components.playercontroller:Enable(false)

	GetPlayer().HUD:Hide()
	TheFrontEnd:Fade(false,1)

	inst:DoTaskInTime(1.2, function() 
		
		GetPlayer().HUD:Show()
		TheFrontEnd:Fade(true,1) 
		
		if sleeper.components.sanity then
			sleeper.components.sanity:DoDelta(TUNING.SANITY_HUGE)
		end
		
		if sleeper.components.hunger then
			sleeper.components.hunger:DoDelta(-TUNING.CALORIES_MED, false, true)
		end
		
		if sleeper.components.health then
			sleeper.components.health:DoDelta(TUNING.HEALING_HUGE, false, "tent", true)
		end
		
		if sleeper.components.moisture then
		    sleeper.components.moisture:SetMoistureLevel(0) 
		end
		
		if IsDLCEnabled(REIGN_OF_GIANTS) then
		if sleeper.components.temperature and sleeper.components.temperature.current < TUNING.TARGET_SLEEP_TEMP then
			sleeper.components.temperature:SetTemperature(TUNING.TARGET_SLEEP_TEMP)
		end
		
		elseif not IsDLCEnabled(REIGN_OF_GIANTS) then
		--if sleeper.components.temperature then
		--	sleeper.components.temperature:SetTemperature(sleeper.components.temperature.maxtemp)
		--end
		end
		inst.components.finiteuses:Use()
		GetClock():MakeNextDay()
		
		sleeper.components.health:SetInvincible(false)
		sleeper.components.playercontroller:Enable(true)
		sleeper.sg:GoToState("wakeup")	
	end)

end

	local function onturnon(inst)
		if not inst:HasTag("burnt") then
			inst.AnimState:PlayAnimation("proximity_loop", true)
			
			inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_"..soundprefix.."_idle_LP","idlesound")
		end
	end

	local function onturnoff(inst)
		if not inst:HasTag("burnt") then
		    inst.AnimState:PushAnimation("idle", true)
			inst.SoundEmitter:KillSound("idlesound")
		end
	end
	
local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst:AddTag("inorihouse")
	inst:AddTag("tent")
    inst:AddTag("structure")
	
    MakeObstaclePhysics(inst, 1.5)
	
    inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 8, 6 )

    inst:AddTag("structure")
    anim:SetBank("yiyuhouse")
    anim:SetBuild("inorihouse")
    anim:PlayAnimation("idle")
    
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "inorihouse.tex" )

    inst:AddComponent("inspectable")
	inst:AddComponent("prototyper")
	inst.components.prototyper.onturnon = onturnon
	inst.components.prototyper.onturnoff = onturnoff

--		inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES[techtree]
--		inst.components.prototyper.trees = techtree
		inst.components.prototyper.onactivate = function()
			if not inst:HasTag("burnt") then
				inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_"..soundprefix.."_run","sound")

				inst:DoTaskInTime(1.5, function() 
					inst.SoundEmitter:KillSound("sound")
					inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_"..soundprefix.."_ding","sound")		
				end)
			end
		end
				
    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(10)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)

	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(7777777)
    inst.components.finiteuses:SetUses(7777777)
    inst.components.finiteuses:SetOnFinished( onfinished )

	inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("inori")

	inst:AddComponent("sleepingbag")
	inst.components.sleepingbag.onsleep = onsleep
	MakeSnowCovered(inst, .01)
	inst:ListenForEvent( "onbuilt", onbuilt)
    return inst
end

return Prefab( "common/objects/inorihouse", fn, assets),
		MakePlacer( "common/inorihouse_placer", "inorihouse", "inorihouse", "idle" )