
local assets = 
{
	Asset("ANIM", "anim/licking_basic.zip"),
--	Asset("ANIM", "anim/hat_slurper.zip"),
	Asset("SOUND", "sound/slurper.fsb"),
}

ghost9610 = 0
OPTION_FOLLOWING = true

local prefabs = 
{
	"beardhair",
	"licking_eyebone",
	"die_fx",
}

local SLEEP_NEAR_LEADER_DISTANCE = 2
local WAKE_TO_FOLLOW_DISTANCE = 3

local freq = 750

local function ShouldWakeUp(inst)
    return DefaultWakeTest(inst) or not inst.components.follower:IsNearLeader(WAKE_TO_FOLLOW_DISTANCE)
end

local function ShouldSleep(inst)
    return DefaultSleepTest(inst) and not inst.sg:HasStateTag("open") and inst.components.follower:IsNearLeader(SLEEP_NEAR_LEADER_DISTANCE)
end

local function ShouldKeepTarget(inst, target)
    return false 
end

local function OnOpen(inst)
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("open")
		if inst.components.talker then
		inst.SoundEmitter:PlaySound("dontstarve/creatures/slurper/jump")
		ghost9610 = math.random()
		if ghost9610 < 0.5 then
			inst.components.talker:Say(STRINGS.LICKING_TALK_OPEN1)
		else
			inst.components.talker:Say(STRINGS.LICKING_TALK_OPEN2)
		end
		end
    end
end 

local function OnClose(inst) 
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("close")
		if inst.components.talker then
		inst.SoundEmitter:PlaySound("dontstarve/creatures/slurper/jump")
		ghost9610 = math.random()
		if ghost9610 < 0.5 then
			inst.components.talker:Say(STRINGS.LICKING_TALK_CLOSE1)
		else
			inst.components.talker:Say(STRINGS.LICKING_TALK_CLOSE2)
		end
		end
    end
end 

local function OnStopFollowing(inst) 
    inst:RemoveTag("companion")
	if inst.components.talker then inst.components.talker:Say(STRINGS.LICKING_TALK_STOPFOLLOW) end
end

local function OnStartFollowing(inst) 
    inst:AddTag("companion")
	local eyebone = TheSim:FindFirstEntityWithTag("licking_eyebone")
	inst.leader = eyebone

	if inst.components.talker then
	inst.SoundEmitter:PlaySound("dontstarve/creatures/slurper/jump")
	ghost9610 = math.random()
	if ghost9610 < 0.5 then
		inst.components.talker:Say(STRINGS.LICKING_TALK_FOLLOW1)
	else
		inst.components.talker:Say(STRINGS.LICKING_TALK_FOLLOW2)
    end
	end
end

local slotpos_3x4 = {}

for y = 2.5, -0.5, -1 do
    for x = 0, 2 do
        table.insert(slotpos_3x4, Vector3(75*x-75*2+75, 75*y-75*2+75,0))
    end
end

local function Retarget(inst)
	--Too far, don't find a target
    local homePos = inst.components.knownlocations:GetLocation("home")
    local myPos = Vector3(inst.Transform:GetWorldPosition() )
    if (homePos and distsq(homePos, myPos) > 10*10) then
		if inst.components.talker then inst.SoundEmitter:PlaySound("dontstarve/creatures/slurper/jump")
		inst.components.talker:Say(STRINGS.LICKING_TALK_TOOFAR) end
        return
    end
	
local newtarget = nil
	
	if newtarget then
		if newtarget:HasTag("lickings_tribe") then
			newtarget = nil
		else
			if inst.components.talker then
			inst.SoundEmitter:PlaySound("dontstarve/creatures/slurper/jump")
			ghost9610 = math.random()
			if ghost9610 < 0.6 then
				if ghost9610 < 0.3 then
					inst.components.talker:Say(STRINGS.LICKING_TALK_PROTECT1)
				else
					inst.components.talker:Say(STRINGS.LICKING_TALK_PROTECT2)
				end
			else
				inst.components.talker:Say(STRINGS.LICKING_TALK_PROTECT3)
			end
			end
		end
	end

    return newtarget
end

local function KeepTarget(inst, target)
    local homePos = inst.components.knownlocations:GetLocation("home")
    local myPos = Vector3(inst.Transform:GetWorldPosition() )
    if (homePos and distsq(homePos, myPos) > 10*10) then
    	--You've chased too far. Go home.
		if inst.components.talker then inst.components.talker:Say(STRINGS.LICKING_TALK_TOOFAR) end
        return false
    end

    return true
end

local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/creatures/slurper/rumble")
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("licking.tex")

	inst:AddTag("companion")
    inst:AddTag("character")
    inst:AddTag("scarytoprey")
    inst:AddTag("licking")
	inst:AddTag("lickings_tribe")
    inst:AddTag("notraptrigger")
	inst:AddTag("notarget")
	
	inst.entity:AddTransform()
	inst.Transform:SetFourFaced()
	local trans = inst.entity:AddTransform()
	
	local anim = inst.entity:AddAnimState()
	anim:SetBank("miho")
	anim:SetBuild("licking_basic")
	anim:PlayAnimation("idle_loop", true) --idle_loop
	
	local sound = inst.entity:AddSoundEmitter()	
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 2, 1.25 )
	
	inst:AddComponent("inspectable")
	inst.components.inspectable:RecordViews()
	
	MakeCharacterPhysics(inst, 10, 0.5)
    MakeMediumBurnableCharacter(inst)
    MakeMediumFreezableCharacter(inst)
	
	inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)
	
	inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.LICKING_HEALTH)
    inst.components.health.canmurder = false
	inst.components.health:StartRegen(7777777, 7)
	inst.components.health.fire_damage_scale = 0
	inst:AddTag("fridge")
	
    if IsDLCEnabled(CAPY_DLC) then
		MakeAmphibiousCharacterPhysics(inst, 75, .5)
	else
		MakeCharacterPhysics(inst, 75, .5)
		inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
		inst.Physics:ClearCollisionMask()
		inst.Physics:CollidesWith(COLLISION.WORLD)
		inst.Physics:CollidesWith(COLLISION.OBSTACLES)
		inst.Physics:CollidesWith(COLLISION.CHARACTERS)
	end
	
	inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 1 )
    inst.components.locomotor:SetTriggersCreep(false)
    inst.components.locomotor.pathcaps = { ignorecreep = false }
    inst.components.locomotor.walkspeed = TUNING.LICKING_WALK_SPEED

    inst:AddComponent("follower")
    inst:ListenForEvent("stopfollowing", OnStopFollowing)
    inst:ListenForEvent("startfollowing", OnStartFollowing)

    inst:AddComponent("knownlocations")

    inst.cansleep = true
	inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
    inst.components.sleeper.testperiod = GetRandomWithVariance(6, 2)
    inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)

	local brain = require "brains/lickingbrain"
	inst:SetBrain(brain)
	inst:SetStateGraph("SGlicking")

	inst:AddComponent("container")
	
	--删除代码
	local widgetbuttoninfo = {
    text = "Delete",
    position = Vector3(0, -195, 0),
    fn = function(inst)
        inst.components.container:DestroyContents()
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_stone")
    end }
    inst.components.container.widgetbuttoninfo = widgetbuttoninfo
	------------------------------------
	
    inst.components.container:SetNumSlots(#slotpos_3x4)
    
    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose
    
    inst.components.container.widgetslotpos = slotpos_3x4
    inst.components.container.widgetanimbank = "ui_chester_shadow_3x4"
    inst.components.container.widgetanimbuild = "ui_chester_shadow_3x4"
    inst.components.container.widgetpos = Vector3(0,140,0)
    inst.components.container.side_align_tip = 160

	local light = inst.entity:AddLight()
	inst:AddComponent("lighttweener")
    inst.components.lighttweener:StartTween(light, 1, 0.5, 0.7, {237/255, 237/255, 209/255}, 0)
	light:Enable(true)

	inst:AddComponent("periodicspawner")
    inst.components.periodicspawner:SetPrefab("sweet_n_sour")
    inst.components.periodicspawner:SetRandomTimes(478, 2)
    inst.components.periodicspawner:SetDensityInRange(20, 2)
    inst.components.periodicspawner:SetMinimumSpacing(8)
    inst.components.periodicspawner:Start()
	
	

	return inst
end

return Prefab("cave/monsters/licking", fn, assets, prefabs)