local assets=
{
    Asset("ANIM", "anim/xk.zip"),
    Asset("ANIM", "anim/swap_xk.zip"),
  
    Asset("ATLAS", "images/inventoryimages/xk.xml"), 
    Asset("IMAGE", "images/inventoryimages/xk.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_xk", "swap_galientsword")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end
	
--冰冻代码
local function onattack_freezing(inst, attacker, target, skipsanity)
    
    if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end
    if target.components.burnable then
        if target.components.burnable:IsBurning() then
            target.components.burnable:Extinguish()
        elseif target.components.burnable:IsSmoldering() then
            target.components.burnable:SmotherSmolder()
        end
    end

    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
    end

    if target.sg and not target.sg:HasStateTag("frozen") then
        target:PushEvent("attacked", {attacker = attacker, damage = 0})
    end

    if target.components.freezable then
        target.components.freezable:AddColdness(0.7)
        target.components.freezable:SpawnShatterFX()
    end
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("galientsword")
    inst.AnimState:SetBuild("xk")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/xk.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT
	
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 0.5)
	inst.components.tool:SetAction(ACTIONS.MINE, 0.5)
	
if SaveGameIndex:IsModeShipwrecked() then
    inst.components.tool:SetAction(ACTIONS.HACK,1)
	MakeInventoryFloatable(inst, "idle_water", "idle")
end

-------涂鸦-----------
local function cancreatecolour(xk, caster, target, pos)
    return true
end
local function createcolour(xk, target, pos)
    local caster = xk.components.inventoryitem.owner
    if caster.components.sanity then
       caster.components.sanity:DoDelta(7)
    end
    local colours= { {198/255,43/255,43/255}, {79/255,153/255,68/255}, {35/255,105/255,235/255}, {233/255,208/255,69/255}, {109/255,50/255,163/255}, {222/255,126/255,39/255}, }
    inst.colour_idx = math.random(#colours)
    target.AnimState:SetMultColour(colours[inst.colour_idx][1],colours[inst.colour_idx][2],colours[inst.colour_idx][3],1)
end
inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(createcolour)
    inst.components.spellcaster:SetSpellTestFn(cancreatecolour)
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canusefrominventory = false
------------------------------------------------------------------------------------------

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(37)
	inst.components.weapon:SetRange(1.7)
  
    inst:AddTag("sharp")
	
	inst.components.weapon:SetOnAttack(onattack_freezing)
    
	return inst
end


return Prefab( "common/inventory/xk", fn, assets) 
