local assets=
{
    Asset("ANIM", "anim/zxk.zip"),
    Asset("ANIM", "anim/swap_zxk.zip"),
  
    Asset("ATLAS", "images/inventoryimages/zxk.xml"), 
    Asset("IMAGE", "images/inventoryimages/zxk.tex"),
}

local function ShouldAcceptItem(inst, item)
    if item.prefab == "nightmarefuel" then
       return true
    end
    return false
end

local function OnGetItemFromPlayer(inst, giver, item)
    if item.prefab == "nightmarefuel" then
       inst.components.finiteuses.current = inst.components.finiteuses.current + inst.components.finiteuses.total *0.2
    end
    if inst.components.finiteuses.current > inst.components.finiteuses.total then
       inst.components.finiteuses.current = inst.components.finiteuses.total
    end
end

local function onfinished(inst)
	inst:Remove()
end

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_zxk", "swap_galientsword")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end
	
	--冰冻代码
local function onattack_freezing(inst, attacker, target, skipsanity)
    
    if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end
    if target.components.burnable then
        if target.components.burnable:IsBurning() then
            target.components.burnable:Extinguish()
        elseif target.components.burnable:IsSmoldering() then
            target.components.burnable:SmotherSmolder()
        end
    end

    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
    end

    if target.sg and not target.sg:HasStateTag("frozen") then
        target:PushEvent("attacked", {attacker = attacker, damage = 0})
    end

    if target.components.freezable then
        target.components.freezable:AddColdness(0.9)
        target.components.freezable:SpawnShatterFX()
    end
end


local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("galientsword")
    inst.AnimState:SetBuild("zxk")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/zxk.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 5)
	inst.components.tool:SetAction(ACTIONS.MINE, 5)
	
if SaveGameIndex:IsModeShipwrecked() then
    inst.components.tool:SetAction(ACTIONS.HACK,6)
	MakeInventoryFloatable(inst, "idle_water", "idle")
end
	
	inst.components.equippable.walkspeedmult = 1.2

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(77)
	inst.components.weapon:SetRange(2.7)
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(777)
    inst.components.finiteuses:SetUses(777)
	if inst.components.finiteuses.current < 0 then
       inst.components.finiteuses.current = 0
    end
	
	inst.components.finiteuses:SetOnFinished( onfinished )
	
	inst:AddComponent("trader")
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
  
    inst:AddTag("sharp")
	
	inst.components.weapon:SetOnAttack(onattack_freezing)

	return inst
end


return Prefab( "common/inventory/zxk", fn, assets) 
