local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local TECH = GLOBAL.TECH

PrefabFiles = {
	"yasuo",
        "woodsword",
        "trialsword",
        "galesword",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/yasuo.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/yasuo.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/yasuo.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/yasuo.xml" ),

    Asset( "IMAGE", "bigportraits/yasuo.tex" ),
    Asset( "ATLAS", "bigportraits/yasuo.xml" ),
    
    Asset( "IMAGE", "images/map_icons/yasuo.tex" ),
    Asset( "ATLAS", "images/map_icons/yasuo.xml" ),
    	
    Asset( "IMAGE", "images/avatars/avatar_yasuo.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_yasuo.xml" ),

    Asset("IMAGE", "images/inventoryimages/woodsword.tex"),
    Asset("ATLAS", "images/inventoryimages/woodsword.xml"),

    Asset("IMAGE", "images/inventoryimages/trialsword.tex"),
    Asset("ATLAS", "images/inventoryimages/trialsword.xml"),

    Asset("IMAGE", "images/inventoryimages/galesword.tex"),
    Asset("ATLAS", "images/inventoryimages/galesword.xml"),

}

GLOBAL.STRINGS.NAMES.WOODSWORD = "WoodSword"
GLOBAL.STRINGS.RECIPE_DESC.WOODSWORD = "A legendary world!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.WOODSWORD = {"My turn" }

GLOBAL.STRINGS.NAMES.TRIALSWORD = "TrialSword"
GLOBAL.STRINGS.RECIPE_DESC.TRIALSWORD = "An mysterious sword"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TRIALSWORD = {"My turn" }

STRINGS.NAMES.GALESWORD = "Galesword"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GALESWORD = "Fast Wind"
STRINGS.RECIPE_DESC.GALESWORD = "A cool sword!"


GLOBAL.STRINGS.CHARACTER_TITLES.yasuo = "Yasuo"
GLOBAL.STRINGS.CHARACTER_NAMES.yasuo = "Yasuo"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.yasuo = "*Fast-but-easy-to-die \n*An-amazing-sword\n*Sword-can-be-hided"
GLOBAL.STRINGS.CHARACTER_QUOTES.yasuo = "\"Death is like the wind; always by my side\""

function AddMap(inst)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( inst.prefab .. ".tex" )
end
AddPrefabPostInit("woodsword", AddMap)
AddMinimapAtlas("images/inventoryimages/woodsword.xml")
AddPrefabPostInit("trialsword", AddMap)
AddMinimapAtlas("images/inventoryimages/trialsword.xml")
AddPrefabPostInit("galesword", AddMap)
AddMinimapAtlas("images/inventoryimages/galesword.xml")


AddMinimapAtlas("images/map_icons/yasuo.xml")
AddModCharacter("yasuo")

