local assets=
{
    Asset("ANIM", "anim/galesword.zip"),
    Asset("ANIM", "anim/swap_galesword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/galesword.xml"), 
    Asset("IMAGE", "images/inventoryimages/galesword.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_galesword", "swap_batbat")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end


local function doBlindEffect(inst, owner, target)

    local fx = SpawnPrefab("tornado")
    fx.WINDSTAFF_CASTER = owner
    fx.entity:SetParent(target.entity)
    target.blindEffect = fx
end

local function doBlindEffectEndTask(inst, owner, target)
    if target.blindEffectEndTask ~= nil then
        target.blindEffectEndTask:Cancel()
    end
    
    local time = 0.8
  
    target.blindEffectEndTask = target:DoTaskInTime(time, function(target)
        if target.blindEffect ~= nil then
            target.blindEffect:Remove()
            target.blindEffect = nil
        end
    end, target)
    
end






local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("galesword")
    inst.AnimState:SetBuild("galesword")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:PlayAnimation("tornado_pre")
    inst.AnimState:PushAnimation("tornado_loop")

    inst:AddComponent("inspectable")

    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "galesword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/galesword.xml"


	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	

    inst.hasagi = 0
    local function onattack(inst, owner, target)

        inst.hasagi=inst.hasagi +1        
        if inst.hasagi % 3 == 0 then
            if target.blindEffect ~= nil then
           
            doBlindEffectEndTask(inst, owner, target)
            return
            end
        doBlindEffect(inst, owner, target)
        doBlindEffectEndTask(inst, owner, target)
        end
    end

	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(45)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon:SetOnAttack(onattack)

	inst:AddTag("sharp")



	return inst
end
	

return Prefab( "common/inventory/galesword", fn, assets) 
