/* 
 This file was generated by Dashcode.  
 You may edit this file to customize your widget or web page 
 according to the license.txt file included in the project.
 */

// Download by http://sc.xueit.com
// Function: load()
// Called by HTML body element's onload event when the widget is ready to start
//
function load()
{
    dashcode.setupParts();
}

//
// Function: remove()
// Called when the widget has been removed from the Dashboard
//
function remove()
{
    // Stop any timers to prevent CPU usage
    // Remove any preferences as needed
    // widget.setPreferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
}

//
// Function: hide()
// Called when the widget has been hidden
//
function hide()
{
    // Stop any timers to prevent CPU usage
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
    // Restart any timers that were stopped on hide
}

//
// Function: sync()
// Called when the widget has been synchronized with .Mac
function sync()
{
    // Retrieve any preference values that you need to be synchronized here
    // Use this for an instance key's value:
    // instancePreferenceValue = widget.preferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
    //
    // Or this for global key's value:
    // globalPreferenceValue = widget.preferenceForKey(null, "your-key");
}

//
// Function: showBack(event)
// Called when the info button is clicked to show the back of the widget
//
// event: onClick event from the info button
//
function showBack(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToBack");
    }

    front.style.display = "none";
    back.style.display = "block";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

// Function: showFront(event)
// Called when the done button is clicked from the back of the widget
//
// event: onClick event from the done button
//
function showFront(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToFront");
    }

    front.style.display="block";
    back.style.display="none";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
    widget.onsync = sync;
}


$(document).ready(function() {
    // Retrive and apply settings
    var htmlmode = widget.preferenceForKey("htmlmode") === undefined ? false : widget.preferenceForKey("htmlmode");
    if(htmlmode){ $('#wrapslider').css("right", "-55px"); }
    
    
    // Init
    var fadeSpeed = 400,
        activeButton = false,
        lorem = "",
        embedtag = "",
        embedtext = "",
        x, 
        wrapInTag,
        loremType,
        selectID,
        checkoffset;
        
    // IDs
    $("#bParagraph").data("ID", "paragraph");
    $("#bHeader").data("ID", "header");
    $("#bList").data("ID", "list");
    // Max values
    $("#bParagraph").data("max", 500);
    $("#bHeader").data("max", 20);
    $("#bList").data("max", 30);
    // Type names
    $("#bParagraph").data("typeName", "characters");
    $("#bHeader").data("typeName", "characters");
    $("#bList").data("typeName", "characters");
    // Select type
    $("#bParagraph").data("selectType", "words");
    $("#bHeader").data("selectType", "words");
    $("#bList").data("selectType", "list items");
    // Embed tag
    $("#bParagraph").data("embedTag", {0: "p", 1: "pre"});
    $("#bHeader").data("embedTag", {0: "h1", 1: "h2", 2: "h3", 3: "h4", 4: "h5"});
    $("#bList").data("embedTag", {0: "ul", 1: "ol"});
    // Active embed tag
    $("#bParagraph").data("activeTag", 0);
    $("#bHeader").data("activeTag", 1);
    $("#bList").data("activeTag", 0);
    $button = "";
    
    $("#bParagraph, #bHeader, #bList").mouseenter(function(e){
        $button = $(this);
        embedtag = $button.data("embedTag")[$button.data("activeTag")];
        embedtext = htmlmode == true ? "&lt;" + embedtag + "&gt;*&lt;/" + embedtag + "&gt;" : "Plain text";
        
        if(activeButton != $button.data("ID") && activeButton != false && htmlmode == true){ 
            $("#embedtag").stop().animate({opacity: 0}, 250, function(){
              $("#embedtag").html(embedtext).animate({opacity: 1}, 250);
            });
        } else { $("#embedtag").html(embedtext); }
        
        activeButton = $(this).data("ID");
        var selectType = $(this).data("selectType");
        $("#characters").text(selectType);
        $("#placeholderText").stop().animate({opacity: 0}, fadeSpeed);
        $("#copyInfo").stop().animate({opacity: 1}, fadeSpeed);
});
    
    $("#bParagraph, #bHeader, #bList").mousemove(function(e){
        x = Math.pow((e.pageX - this.offsetLeft)/$(this).width(), 2)*$(this).data("max");
        wrapInTag = htmlmode == false ? false : embedtag;
        loremType = $(this).data("typeName");
        selectID  = $(this).data("ID");
        checkoffset = $("#amount").width() + $("#amount")[0].offsetLeft;
        x = Math.round((x+2));
        lorem = getLorem(loremType, x, wrapInTag, selectID);
        $("#amount").text(x);
        $("#check").css("left", checkoffset);
        $("#typeCount").html(lorem.length + " <span>" + $(this).data("typeName") + "</span>");
    });
    
    $("#bParagraph, #bHeader, #bList").click(function(e){
        $("#check").stop().animate({opacity: 1}, 50).delay(400).animate({opacity: 0}, fadeSpeed);
        var obj = widget.system("osascript -e 'set the clipboard to \""+lorem+"\"'", null);
    });
    
    $("#embedtag").click(function(e){
        e.preventDefault;
        nextTag();
    });
    
    $("#wrapsettings").click(function(e){
        e.preventDefault();
        toggleHTML();
    });
    
    $(window).keydown(function(e){
        if(e.keyCode == 16) toggleHTML(e);
        updateWrapper();
    }).keyup(function(e){
        if(e.keyCode == 16) toggleHTML(e);
        else if(e.keyCode == 84) nextTag();
        updateWrapper();
    });
    
    $(window).blur(function(e){
        $("#front").addClass("unactive");
    }).focus(function(e){
        $("#front").removeClass("unactive");
    });
                
    $("#createdbyta").click(function(e){
        widget.openURL("http://tobiasahlin.com/");
    });
    
    function toggleHTML(e){
        htmlmode = htmlmode == false ? true : false;
        var slideroffset = "-" + htmlmode*55 + "px";
        $('#wrapslider').stop().animate({right: slideroffset}, 250);
        widget.setPreferenceForKey(htmlmode,"htmlmode");
        
        if($button){
            embedtag = $button.data("embedTag")[$button.data("activeTag")];
            embedtext = htmlmode == true ? "&lt;" + embedtag + "&gt;*&lt;/" + embedtag + "&gt;" : "Plain text";
            
            if(activeButton != $button.data("ID") && activeButton != false && htmlmode == true){ 
                $("#embedtag").stop().animate({opacity: 0}, 250, function(){
                $("#embedtag").html(embedtext).animate({opacity: 1}, 250);
                });
            } else { $("#embedtag").html(embedtext); }
        }
    }
    
    function updateWrapper(e){
        if($button){
            embedtag = $button.data("embedTag")[$button.data("activeTag")];
            wrapInTag = htmlmode == false ? false : embedtag;
            lorem = getLorem(loremType, x, wrapInTag, selectID);
        }
    }
    
    function nextTag(e){
        if(htmlmode == true && $button){
            var newTag = $button.data("activeTag") + 1;
            newTag = $button.data("embedTag")[newTag] == null ? 0 : newTag;
            $button.data("activeTag", newTag);
            embedtag = $button.data("embedTag")[$button.data("activeTag")];
            embedtext = "&lt;" + embedtag + "&gt;*&lt;/" + embedtag + "&gt;";
            $("#embedtag").html(embedtext);
        }
    }
});


/*function modify(event) {
    widget.openURL("http://tobiasahlin.com/");
}*/
