/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.internal.Base64;
import com.squareup.okhttp.internal.http.HeaderParser;
import com.squareup.okhttp.internal.http.RawHeaders;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpAuthenticator {
    private HttpAuthenticator() {
    }

    public static boolean processAuthHeader(int responseCode, RawHeaders responseHeaders, RawHeaders successorRequestHeaders, Proxy proxy, URL url) throws IOException {
        if (responseCode != 407 && responseCode != 401) {
            throw new IllegalArgumentException();
        }
        String challengeHeader = responseCode == 407 ? "Proxy-Authenticate" : "WWW-Authenticate";
        String credentials = HttpAuthenticator.getCredentials(responseHeaders, challengeHeader, proxy, url);
        if (credentials == null) {
            return false;
        }
        String fieldName = responseCode == 407 ? "Proxy-Authorization" : "Authorization";
        successorRequestHeaders.set(fieldName, credentials);
        return true;
    }

    private static String getCredentials(RawHeaders responseHeaders, String challengeHeader, Proxy proxy, URL url) throws IOException {
        List<Challenge> challenges = HttpAuthenticator.parseChallenges(responseHeaders, challengeHeader);
        if (challenges.isEmpty()) {
            return null;
        }
        for (Challenge challenge : challenges) {
            PasswordAuthentication auth;
            if (responseHeaders.getResponseCode() == 407) {
                InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
                auth = Authenticator.requestPasswordAuthentication(proxyAddress.getHostName(), HttpAuthenticator.getConnectToInetAddress(proxy, url), proxyAddress.getPort(), url.getProtocol(), challenge.realm, challenge.scheme, url, Authenticator.RequestorType.PROXY);
            } else {
                auth = Authenticator.requestPasswordAuthentication(url.getHost(), HttpAuthenticator.getConnectToInetAddress(proxy, url), url.getPort(), url.getProtocol(), challenge.realm, challenge.scheme, url, Authenticator.RequestorType.SERVER);
            }
            if (auth == null) continue;
            String usernameAndPassword = auth.getUserName() + ":" + new String(auth.getPassword());
            byte[] bytes = usernameAndPassword.getBytes("ISO-8859-1");
            String encoded = Base64.encode(bytes);
            return challenge.scheme + " " + encoded;
        }
        return null;
    }

    private static InetAddress getConnectToInetAddress(Proxy proxy, URL url) throws IOException {
        return proxy != null && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(url.getHost());
    }

    private static List<Challenge> parseChallenges(RawHeaders responseHeaders, String challengeHeader) {
        ArrayList<Challenge> result = new ArrayList<Challenge>();
        block0: for (int h = 0; h < responseHeaders.length(); ++h) {
            if (!challengeHeader.equalsIgnoreCase(responseHeaders.getFieldName(h))) continue;
            String value = responseHeaders.getValue(h);
            int pos = 0;
            while (pos < value.length()) {
                int tokenStart = pos;
                pos = HeaderParser.skipUntil(value, pos, " ");
                String scheme = value.substring(tokenStart, pos).trim();
                if (!value.regionMatches(pos = HeaderParser.skipWhitespace(value, pos), "realm=\"", 0, "realm=\"".length())) continue block0;
                int realmStart = pos += "realm=\"".length();
                pos = HeaderParser.skipUntil(value, pos, "\"");
                String realm = value.substring(realmStart, pos);
                ++pos;
                pos = HeaderParser.skipUntil(value, pos, ",");
                ++pos;
                pos = HeaderParser.skipWhitespace(value, pos);
                result.add(new Challenge(scheme, realm));
            }
        }
        return result;
    }

    private static final class Challenge {
        final String scheme;
        final String realm;

        Challenge(String scheme, String realm) {
            this.scheme = scheme;
            this.realm = realm;
        }

        public boolean equals(Object o) {
            return o instanceof Challenge && ((Challenge)o).scheme.equals(this.scheme) && ((Challenge)o).realm.equals(this.realm);
        }

        public int hashCode() {
            return this.scheme.hashCode() + 31 * this.realm.hashCode();
        }
    }
}

