/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cordova.DirectoryManager;
import org.apache.cordova.ExifHelper;
import org.apache.cordova.FileHelper;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;

public class CameraLauncher
extends CordovaPlugin
implements MediaScannerConnection.MediaScannerConnectionClient {
    private static final int DATA_URL = 0;
    private static final int FILE_URI = 1;
    private static final int NATIVE_URI = 2;
    private static final int PHOTOLIBRARY = 0;
    private static final int CAMERA = 1;
    private static final int SAVEDPHOTOALBUM = 2;
    private static final int PICTURE = 0;
    private static final int VIDEO = 1;
    private static final int ALLMEDIA = 2;
    private static final int JPEG = 0;
    private static final int PNG = 1;
    private static final String GET_PICTURE = "Get Picture";
    private static final String GET_VIDEO = "Get Video";
    private static final String GET_All = "Get All";
    private static final String LOG_TAG = "CameraLauncher";
    private int mQuality;
    private int targetWidth;
    private int targetHeight;
    private Uri imageUri;
    private int encodingType;
    private int mediaType;
    private boolean saveToPhotoAlbum;
    private boolean correctOrientation;
    public CallbackContext callbackContext;
    private int numPics;
    private MediaScannerConnection conn;
    private Uri scanMe;

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        this.callbackContext = callbackContext;
        if (action.equals("takePicture")) {
            int srcType = 1;
            int destType = 1;
            this.saveToPhotoAlbum = false;
            this.targetHeight = 0;
            this.targetWidth = 0;
            this.encodingType = 0;
            this.mediaType = 0;
            this.mQuality = 80;
            this.mQuality = args.getInt(0);
            destType = args.getInt(1);
            srcType = args.getInt(2);
            this.targetWidth = args.getInt(3);
            this.targetHeight = args.getInt(4);
            this.encodingType = args.getInt(5);
            this.mediaType = args.getInt(6);
            this.correctOrientation = args.getBoolean(8);
            this.saveToPhotoAlbum = args.getBoolean(9);
            if (this.targetWidth < 1) {
                this.targetWidth = -1;
            }
            if (this.targetHeight < 1) {
                this.targetHeight = -1;
            }
            if (srcType == 1) {
                this.takePicture(destType, this.encodingType);
            } else if (srcType == 0 || srcType == 2) {
                this.getImage(srcType, destType);
            }
            PluginResult r = new PluginResult(PluginResult.Status.NO_RESULT);
            r.setKeepCallback(true);
            callbackContext.sendPluginResult(r);
            return true;
        }
        return false;
    }

    public void takePicture(int returnType, int encodingType) {
        this.numPics = this.queryImgDB(this.whichContentStore()).getCount();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photo = this.createCaptureFile(encodingType);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photo));
        this.imageUri = Uri.fromFile((File)photo);
        if (this.cordova != null) {
            this.cordova.startActivityForResult(this, intent, 32 + returnType + 1);
        }
    }

    private File createCaptureFile(int encodingType) {
        File photo = null;
        if (encodingType == 0) {
            photo = new File(DirectoryManager.getTempDirectoryPath((Context)this.cordova.getActivity()), ".Pic.jpg");
        } else if (encodingType == 1) {
            photo = new File(DirectoryManager.getTempDirectoryPath((Context)this.cordova.getActivity()), ".Pic.png");
        } else {
            throw new IllegalArgumentException("Invalid Encoding Type: " + encodingType);
        }
        return photo;
    }

    public void getImage(int srcType, int returnType) {
        Intent intent = new Intent();
        String title = GET_PICTURE;
        if (this.mediaType == 0) {
            intent.setType("image/*");
        } else if (this.mediaType == 1) {
            intent.setType("video/*");
            title = GET_VIDEO;
        } else if (this.mediaType == 2) {
            intent.setType("*/*");
            title = GET_All;
        }
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        if (this.cordova != null) {
            this.cordova.startActivityForResult(this, Intent.createChooser((Intent)intent, (CharSequence)new String(title)), (srcType + 1) * 16 + returnType + 1);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        int srcType = requestCode / 16 - 1;
        int destType = requestCode % 16 - 1;
        int rotate = 0;
        if (srcType == 1) {
            if (resultCode == -1) {
                try {
                    ExifHelper exif = new ExifHelper();
                    try {
                        if (this.encodingType == 0) {
                            exif.createInFile(DirectoryManager.getTempDirectoryPath((Context)this.cordova.getActivity()) + "/.Pic.jpg");
                            exif.readExifData();
                            rotate = exif.getOrientation();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Bitmap bitmap = null;
                    Uri uri = null;
                    if (destType == 0) {
                        bitmap = this.getScaledBitmap(FileHelper.stripFileProtocol(this.imageUri.toString()));
                        if (bitmap == null) {
                            bitmap = (Bitmap)intent.getExtras().get("data");
                        }
                        if (bitmap == null) {
                            Log.d((String)LOG_TAG, (String)"I either have a null image path or bitmap");
                            this.failPicture("Unable to create bitmap!");
                            return;
                        }
                        if (rotate != 0 && this.correctOrientation) {
                            bitmap = this.getRotatedBitmap(rotate, bitmap, exif);
                        }
                        this.processPicture(bitmap);
                        this.checkForDuplicateImage(0);
                    } else if (destType == 1 || destType == 2) {
                        if (this.saveToPhotoAlbum) {
                            Uri inputUri = this.getUriFromMediaStore();
                            uri = Uri.fromFile((File)new File(FileHelper.getRealPath(inputUri, this.cordova)));
                        } else {
                            uri = Uri.fromFile((File)new File(DirectoryManager.getTempDirectoryPath((Context)this.cordova.getActivity()), System.currentTimeMillis() + ".jpg"));
                        }
                        if (uri == null) {
                            this.failPicture("Error capturing image - no media storage found.");
                        }
                        if (this.targetHeight == -1 && this.targetWidth == -1 && this.mQuality == 100 && !this.correctOrientation) {
                            this.writeUncompressedImage(uri);
                            this.callbackContext.success(uri.toString());
                        } else {
                            bitmap = this.getScaledBitmap(FileHelper.stripFileProtocol(this.imageUri.toString()));
                            if (rotate != 0 && this.correctOrientation) {
                                bitmap = this.getRotatedBitmap(rotate, bitmap, exif);
                            }
                            OutputStream os = this.cordova.getActivity().getContentResolver().openOutputStream(uri);
                            bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, os);
                            os.close();
                            if (this.encodingType == 0) {
                                String exifPath = this.saveToPhotoAlbum ? FileHelper.getRealPath(uri, this.cordova) : uri.getPath();
                                exif.createOutFile(exifPath);
                                exif.writeExifData();
                            }
                        }
                        this.callbackContext.success(uri.toString());
                    }
                    this.cleanup(1, this.imageUri, uri, bitmap);
                    bitmap = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.failPicture("Error capturing image.");
                }
            } else if (resultCode == 0) {
                this.failPicture("Camera cancelled.");
            } else {
                this.failPicture("Did not complete!");
            }
        } else if (srcType == 0 || srcType == 2) {
            if (resultCode == -1) {
                Uri uri = intent.getData();
                if (this.mediaType != 0) {
                    this.callbackContext.success(uri.toString());
                } else if (!(this.targetHeight != -1 || this.targetWidth != -1 || destType != 1 && destType != 2 || this.correctOrientation)) {
                    this.callbackContext.success(uri.toString());
                } else {
                    String uriString = uri.toString();
                    String mimeType = FileHelper.getMimeType(uriString, this.cordova);
                    if (!"image/jpeg".equalsIgnoreCase(mimeType) && !"image/png".equalsIgnoreCase(mimeType)) {
                        Log.d((String)LOG_TAG, (String)"I either have a null image path or bitmap");
                        this.failPicture("Unable to retrieve path to picture!");
                        return;
                    }
                    Bitmap bitmap = null;
                    try {
                        bitmap = this.getScaledBitmap(uriString);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (bitmap == null) {
                        Log.d((String)LOG_TAG, (String)"I either have a null image path or bitmap");
                        this.failPicture("Unable to create bitmap!");
                        return;
                    }
                    if (this.correctOrientation && (rotate = this.getImageOrientation(uri)) != 0) {
                        Matrix matrix = new Matrix();
                        matrix.setRotate((float)rotate);
                        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    }
                    if (destType == 0) {
                        this.processPicture(bitmap);
                    } else if (destType == 1 || destType == 2) {
                        if (this.targetHeight > 0 && this.targetWidth > 0) {
                            try {
                                String resizePath = DirectoryManager.getTempDirectoryPath((Context)this.cordova.getActivity()) + "/resize.jpg";
                                String realPath = FileHelper.getRealPath(uri, this.cordova);
                                ExifHelper exif = new ExifHelper();
                                if (realPath != null && this.encodingType == 0) {
                                    try {
                                        exif.createInFile(realPath);
                                        exif.readExifData();
                                        rotate = exif.getOrientation();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                FileOutputStream os = new FileOutputStream(resizePath);
                                bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, (OutputStream)os);
                                ((OutputStream)os).close();
                                if (realPath != null && this.encodingType == 0) {
                                    exif.createOutFile(resizePath);
                                    exif.writeExifData();
                                }
                                this.callbackContext.success("file://" + resizePath + "?" + System.currentTimeMillis());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.failPicture("Error retrieving image.");
                            }
                        } else {
                            this.callbackContext.success(uri.toString());
                        }
                    }
                    if (bitmap != null) {
                        bitmap.recycle();
                        bitmap = null;
                    }
                    System.gc();
                }
            } else if (resultCode == 0) {
                this.failPicture("Selection cancelled.");
            } else {
                this.failPicture("Selection did not complete!");
            }
        }
    }

    private int getImageOrientation(Uri uri) {
        String[] cols = new String[]{"orientation"};
        Cursor cursor = this.cordova.getActivity().getContentResolver().query(uri, cols, null, null, null);
        int rotate = 0;
        if (cursor != null) {
            cursor.moveToPosition(0);
            rotate = cursor.getInt(0);
            cursor.close();
        }
        return rotate;
    }

    private Bitmap getRotatedBitmap(int rotate, Bitmap bitmap, ExifHelper exif) {
        Matrix matrix = new Matrix();
        if (rotate == 180) {
            matrix.setRotate((float)rotate);
        } else {
            matrix.setRotate((float)rotate, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
        }
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        exif.resetOrientation();
        return bitmap;
    }

    private void writeUncompressedImage(Uri uri) throws FileNotFoundException, IOException {
        int len;
        FileInputStream fis = new FileInputStream(FileHelper.stripFileProtocol(this.imageUri.toString()));
        OutputStream os = this.cordova.getActivity().getContentResolver().openOutputStream(uri);
        byte[] buffer = new byte[4096];
        while ((len = fis.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        os.flush();
        os.close();
        fis.close();
    }

    private Uri getUriFromMediaStore() {
        Uri uri;
        ContentValues values = new ContentValues();
        values.put("mime_type", "image/jpeg");
        try {
            uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        catch (UnsupportedOperationException e) {
            LOG.d(LOG_TAG, "Can't write to external media storage.");
            try {
                uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
            }
            catch (UnsupportedOperationException ex) {
                LOG.d(LOG_TAG, "Can't write to internal media storage.");
                return null;
            }
        }
        return uri;
    }

    private Bitmap getScaledBitmap(String imageUrl) throws IOException {
        if (this.targetWidth <= 0 && this.targetHeight <= 0) {
            return BitmapFactory.decodeStream((InputStream)FileHelper.getInputStreamFromUriString(imageUrl, this.cordova));
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)FileHelper.getInputStreamFromUriString(imageUrl, this.cordova), null, (BitmapFactory.Options)options);
        if (options.outWidth == 0 || options.outHeight == 0) {
            return null;
        }
        int[] widthHeight = this.calculateAspectRatio(options.outWidth, options.outHeight);
        options.inJustDecodeBounds = false;
        options.inSampleSize = CameraLauncher.calculateSampleSize(options.outWidth, options.outHeight, this.targetWidth, this.targetHeight);
        Bitmap unscaledBitmap = BitmapFactory.decodeStream((InputStream)FileHelper.getInputStreamFromUriString(imageUrl, this.cordova), null, (BitmapFactory.Options)options);
        if (unscaledBitmap == null) {
            return null;
        }
        return Bitmap.createScaledBitmap((Bitmap)unscaledBitmap, (int)widthHeight[0], (int)widthHeight[1], (boolean)true);
    }

    public int[] calculateAspectRatio(int origWidth, int origHeight) {
        int newWidth = this.targetWidth;
        int newHeight = this.targetHeight;
        if (newWidth <= 0 && newHeight <= 0) {
            newWidth = origWidth;
            newHeight = origHeight;
        } else if (newWidth > 0 && newHeight <= 0) {
            newHeight = newWidth * origHeight / origWidth;
        } else if (newWidth <= 0 && newHeight > 0) {
            newWidth = newHeight * origWidth / origHeight;
        } else {
            double origRatio = (double)origWidth / (double)origHeight;
            double newRatio = (double)newWidth / (double)newHeight;
            if (origRatio > newRatio) {
                newHeight = newWidth * origHeight / origWidth;
            } else if (origRatio < newRatio) {
                newWidth = newHeight * origWidth / origHeight;
            }
        }
        int[] retval = new int[]{newWidth, newHeight};
        return retval;
    }

    public static int calculateSampleSize(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
        float srcAspect = (float)srcWidth / (float)srcHeight;
        float dstAspect = (float)dstWidth / (float)dstHeight;
        if (srcAspect > dstAspect) {
            return srcWidth / dstWidth;
        }
        return srcHeight / dstHeight;
    }

    private Cursor queryImgDB(Uri contentStore) {
        return this.cordova.getActivity().getContentResolver().query(contentStore, new String[]{"_id"}, null, null, null);
    }

    private void cleanup(int imageType, Uri oldImage, Uri newImage, Bitmap bitmap) {
        if (bitmap != null) {
            bitmap.recycle();
        }
        new File(FileHelper.stripFileProtocol(oldImage.toString())).delete();
        this.checkForDuplicateImage(imageType);
        if (this.saveToPhotoAlbum && newImage != null) {
            this.scanForGallery(newImage);
        }
        System.gc();
    }

    private void checkForDuplicateImage(int type) {
        int diff = 1;
        Uri contentStore = this.whichContentStore();
        Cursor cursor = this.queryImgDB(contentStore);
        int currentNumOfImages = cursor.getCount();
        if (type == 1 && this.saveToPhotoAlbum) {
            diff = 2;
        }
        if (currentNumOfImages - this.numPics == diff) {
            cursor.moveToLast();
            int id = Integer.valueOf(cursor.getString(cursor.getColumnIndex("_id")));
            if (diff == 2) {
                --id;
            }
            Uri uri = Uri.parse((String)(contentStore + "/" + id));
            this.cordova.getActivity().getContentResolver().delete(uri, null, null);
        }
    }

    private Uri whichContentStore() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        return MediaStore.Images.Media.INTERNAL_CONTENT_URI;
    }

    public void processPicture(Bitmap bitmap) {
        ByteArrayOutputStream jpeg_data = new ByteArrayOutputStream();
        try {
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, (OutputStream)jpeg_data)) {
                byte[] code = jpeg_data.toByteArray();
                byte[] output = Base64.encode((byte[])code, (int)0);
                String js_out = new String(output);
                this.callbackContext.success(js_out);
                js_out = null;
                output = null;
                code = null;
            }
        }
        catch (Exception e) {
            this.failPicture("Error compressing image.");
        }
        jpeg_data = null;
    }

    public void failPicture(String err) {
        this.callbackContext.error(err);
    }

    private void scanForGallery(Uri newImage) {
        this.scanMe = newImage;
        if (this.conn != null) {
            this.conn.disconnect();
        }
        this.conn = new MediaScannerConnection(this.cordova.getActivity().getApplicationContext(), (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.conn.connect();
    }

    public void onMediaScannerConnected() {
        try {
            this.conn.scanFile(this.scanMe.toString(), "image/*");
        }
        catch (IllegalStateException e) {
            LOG.e(LOG_TAG, "Can't scan file in MediaScanner after taking picture");
        }
    }

    public void onScanCompleted(String path, Uri uri) {
        this.conn.disconnect();
    }
}

