/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.api;

import android.util.Log;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONObject;

public class CallbackContext {
    private static final String LOG_TAG = "CordovaPlugin";
    private String callbackId;
    private CordovaWebView webView;
    private boolean finished;
    private int changingThreads;

    public CallbackContext(String callbackId, CordovaWebView webView) {
        this.callbackId = callbackId;
        this.webView = webView;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isChangingThreads() {
        return this.changingThreads > 0;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPluginResult(PluginResult pluginResult) {
        CallbackContext callbackContext = this;
        synchronized (callbackContext) {
            if (this.finished) {
                Log.w((String)LOG_TAG, (String)("Attempted to send a second callback for ID: " + this.callbackId + "\nResult was: " + pluginResult.getMessage()));
                return;
            }
            this.finished = !pluginResult.getKeepCallback();
        }
        this.webView.sendPluginResult(pluginResult, this.callbackId);
    }

    public void success(JSONObject message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(String message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(JSONArray message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(byte[] message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(int message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success() {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK));
    }

    public void error(JSONObject message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, message));
    }

    public void error(String message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, message));
    }

    public void error(int message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, message));
    }
}

