/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1GeneralizedTime;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.StreamUtil;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import com.zeroturnaround.bundled.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DERGeneralizedTime
extends ASN1Primitive {
    private byte[] time;

    public static ASN1GeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)object;
        }
        if (object instanceof DERGeneralizedTime) {
            return new ASN1GeneralizedTime(((DERGeneralizedTime)object).time);
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1GeneralizedTime)DERGeneralizedTime.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERGeneralizedTime) {
            return DERGeneralizedTime.getInstance(aSN1Primitive);
        }
        return new ASN1GeneralizedTime(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    public DERGeneralizedTime(String string) {
        this.time = Strings.toByteArray(string);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public DERGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    DERGeneralizedTime(byte[] byArray) {
        this.time = byArray;
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.time);
    }

    public String getTime() {
        String string = Strings.fromByteArray(this.time);
        if (string.charAt(string.length() - 1) == 'Z') {
            return string.substring(0, string.length() - 1) + "GMT+00:00";
        }
        int n2 = string.length() - 5;
        char c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2, n2 + 3) + ":" + string.substring(n2 + 3);
        }
        n2 = string.length() - 3;
        c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2) + ":00";
        }
        return string + this.calculateGMTOffset();
    }

    private String calculateGMTOffset() {
        String string = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n2 = timeZone.getRawOffset();
        if (n2 < 0) {
            string = "-";
            n2 = -n2;
        }
        int n3 = n2 / 3600000;
        int n4 = (n2 - n3 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime() && timeZone.inDaylightTime(this.getDate())) {
                n3 += string.equals("+") ? 1 : -1;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return "GMT" + string + this.convert(n3) + ":" + this.convert(n4);
    }

    private String convert(int n2) {
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string;
        String string2 = string = Strings.fromByteArray(this.time);
        if (string.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (string.indexOf(45) > 0 || string.indexOf(43) > 0) {
            string2 = this.getTime();
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : new SimpleDateFormat("yyyyMMddHHmmssz");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            char c2;
            int n2;
            String string3 = string2.substring(14);
            for (n2 = 1; n2 < string3.length() && '0' <= (c2 = string3.charAt(n2)) && c2 <= '9'; ++n2) {
            }
            if (n2 - 1 > 3) {
                string3 = string3.substring(0, 4) + string3.substring(n2);
                string2 = string2.substring(0, 14) + string3;
            } else if (n2 - 1 == 1) {
                string3 = string3.substring(0, n2) + "00" + string3.substring(n2);
                string2 = string2.substring(0, 14) + string3;
            } else if (n2 - 1 == 2) {
                string3 = string3.substring(0, n2) + "0" + string3.substring(n2);
                string2 = string2.substring(0, 14) + string3;
            }
        }
        return simpleDateFormat.parse(string2);
    }

    private boolean hasFractionalSeconds() {
        for (int i2 = 0; i2 != this.time.length; ++i2) {
            if (this.time[i2] != 46 || i2 != 14) continue;
            return true;
        }
        return false;
    }

    boolean isConstructed() {
        return false;
    }

    int a() {
        int n2 = this.time.length;
        return 1 + StreamUtil.a(n2) + n2;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.a(24, this.time);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERGeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((DERGeneralizedTime)aSN1Primitive).time);
    }

    public int hashCode() {
        return Arrays.hashCode(this.time);
    }
}

