/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.LimitedInputStream;
import com.zeroturnaround.bundled.org.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int _originalLength;
    private int _remaining;

    DefiniteLengthInputStream(InputStream inputStream, int n2) {
        super(inputStream, n2);
        if (n2 < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._originalLength = n2;
        this._remaining = n2;
        if (n2 == 0) {
            this.setParentEofDetect(true);
        }
    }

    int a() {
        return this._remaining;
    }

    public int read() throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n2 = this._in.read();
        if (n2 < 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        if (--this._remaining == 0) {
            this.setParentEofDetect(true);
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n4 = Math.min(n3, this._remaining);
        int n5 = this._in.read(byArray, n2, n4);
        if (n5 < 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        if ((this._remaining -= n5) == 0) {
            this.setParentEofDetect(true);
        }
        return n5;
    }

    byte[] a() throws IOException {
        if (this._remaining == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[this._remaining];
        if ((this._remaining -= Streams.readFully(this._in, byArray)) != 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        this.setParentEofDetect(true);
        return byArray;
    }
}

