/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.cryptopro;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECGOST3410ParamSetParameters
extends ASN1Object {
    ASN1Integer a;
    ASN1Integer b;
    ASN1Integer c;
    ASN1Integer d;
    ASN1Integer e;
    ASN1Integer f;

    public static ECGOST3410ParamSetParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return ECGOST3410ParamSetParameters.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static ECGOST3410ParamSetParameters getInstance(Object object) {
        if (object == null || object instanceof ECGOST3410ParamSetParameters) {
            return (ECGOST3410ParamSetParameters)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ECGOST3410ParamSetParameters((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid GOST3410Parameter: " + object.getClass().getName());
    }

    public ECGOST3410ParamSetParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n2, BigInteger bigInteger5) {
        this.c = new ASN1Integer(bigInteger);
        this.d = new ASN1Integer(bigInteger2);
        this.a = new ASN1Integer(bigInteger3);
        this.b = new ASN1Integer(bigInteger4);
        this.e = new ASN1Integer(n2);
        this.f = new ASN1Integer(bigInteger5);
    }

    public ECGOST3410ParamSetParameters(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.c = (ASN1Integer)enumeration.nextElement();
        this.d = (ASN1Integer)enumeration.nextElement();
        this.a = (ASN1Integer)enumeration.nextElement();
        this.b = (ASN1Integer)enumeration.nextElement();
        this.e = (ASN1Integer)enumeration.nextElement();
        this.f = (ASN1Integer)enumeration.nextElement();
    }

    public BigInteger getP() {
        return this.a.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.b.getPositiveValue();
    }

    public BigInteger getA() {
        return this.c.getPositiveValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        return new DERSequence(aSN1EncodableVector);
    }
}

