/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.dvcs;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1GeneralizedTime;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.dvcs.DVCSTime;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.dvcs.ServiceType;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Extensions;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.GeneralNames;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.PolicyInformation;
import java.math.BigInteger;

public class DVCSRequestInformation
extends ASN1Object {
    private int version = 1;
    private ServiceType service;
    private BigInteger nonce;
    private DVCSTime requestTime;
    private GeneralNames requester;
    private PolicyInformation requestPolicy;
    private GeneralNames dvcs;
    private GeneralNames dataLocations;
    private Extensions extensions;
    private static final int DEFAULT_VERSION = 1;
    private static final int TAG_REQUESTER = 0;
    private static final int TAG_REQUEST_POLICY = 1;
    private static final int TAG_DVCS = 2;
    private static final int TAG_DATA_LOCATIONS = 3;
    private static final int TAG_EXTENSIONS = 4;

    private DVCSRequestInformation(ASN1Sequence aSN1Sequence) {
        ASN1Encodable aSN1Encodable;
        int n2 = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            aSN1Encodable = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n2++));
            this.version = aSN1Encodable.getValue().intValue();
        } else {
            this.version = 1;
        }
        this.service = ServiceType.getInstance(aSN1Sequence.getObjectAt(n2++));
        while (n2 < aSN1Sequence.size()) {
            aSN1Encodable = aSN1Sequence.getObjectAt(n2);
            if (aSN1Encodable instanceof ASN1Integer) {
                this.nonce = ASN1Integer.getInstance(aSN1Encodable).getValue();
            } else if (aSN1Encodable instanceof ASN1GeneralizedTime) {
                this.requestTime = DVCSTime.getInstance(aSN1Encodable);
            } else if (aSN1Encodable instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
                int n3 = aSN1TaggedObject.getTagNo();
                switch (n3) {
                    case 0: {
                        this.requester = GeneralNames.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 1: {
                        this.requestPolicy = PolicyInformation.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, false));
                        break;
                    }
                    case 2: {
                        this.dvcs = GeneralNames.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 3: {
                        this.dataLocations = GeneralNames.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 4: {
                        this.extensions = Extensions.getInstance(aSN1TaggedObject, false);
                    }
                }
            } else {
                this.requestTime = DVCSTime.getInstance(aSN1Encodable);
            }
            ++n2;
        }
    }

    public static DVCSRequestInformation getInstance(Object object) {
        if (object instanceof DVCSRequestInformation) {
            return (DVCSRequestInformation)object;
        }
        if (object != null) {
            return new DVCSRequestInformation(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static DVCSRequestInformation getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DVCSRequestInformation.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.version != 1) {
            aSN1EncodableVector.add(new ASN1Integer(this.version));
        }
        aSN1EncodableVector.add(this.service);
        if (this.nonce != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.nonce));
        }
        if (this.requestTime != null) {
            aSN1EncodableVector.add(this.requestTime);
        }
        int[] nArray = new int[]{0, 1, 2, 3, 4};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{this.requester, this.requestPolicy, this.dvcs, this.dataLocations, this.extensions};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            ASN1Encodable aSN1Encodable = aSN1EncodableArray[i2];
            if (aSN1Encodable == null) continue;
            aSN1EncodableVector.add(new DERTaggedObject(false, n2, aSN1Encodable));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DVCSRequestInformation {\n");
        if (this.version != 1) {
            stringBuffer.append("version: " + this.version + "\n");
        }
        stringBuffer.append("service: " + this.service + "\n");
        if (this.nonce != null) {
            stringBuffer.append("nonce: " + this.nonce + "\n");
        }
        if (this.requestTime != null) {
            stringBuffer.append("requestTime: " + this.requestTime + "\n");
        }
        if (this.requester != null) {
            stringBuffer.append("requester: " + this.requester + "\n");
        }
        if (this.requestPolicy != null) {
            stringBuffer.append("requestPolicy: " + this.requestPolicy + "\n");
        }
        if (this.dvcs != null) {
            stringBuffer.append("dvcs: " + this.dvcs + "\n");
        }
        if (this.dataLocations != null) {
            stringBuffer.append("dataLocations: " + this.dataLocations + "\n");
        }
        if (this.extensions != null) {
            stringBuffer.append("extensions: " + this.extensions + "\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public ServiceType getService() {
        return this.service;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public DVCSTime getRequestTime() {
        return this.requestTime;
    }

    public GeneralNames getRequester() {
        return this.requester;
    }

    public PolicyInformation getRequestPolicy() {
        return this.requestPolicy;
    }

    public GeneralNames getDVCS() {
        return this.dvcs;
    }

    public GeneralNames getDataLocations() {
        return this.dataLocations;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }
}

