/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class DHParameter
extends ASN1Object {
    ASN1Integer a;
    ASN1Integer b;
    ASN1Integer c;

    public DHParameter(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        this.a = new ASN1Integer(bigInteger);
        this.b = new ASN1Integer(bigInteger2);
        this.c = n2 != 0 ? new ASN1Integer(n2) : null;
    }

    public static DHParameter getInstance(Object object) {
        if (object instanceof DHParameter) {
            return (DHParameter)object;
        }
        if (object != null) {
            return new DHParameter(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private DHParameter(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = ASN1Integer.getInstance(enumeration.nextElement());
        this.c = enumeration.hasMoreElements() ? (ASN1Integer)enumeration.nextElement() : null;
    }

    public BigInteger getP() {
        return this.a.getPositiveValue();
    }

    public BigInteger getG() {
        return this.b.getPositiveValue();
    }

    public BigInteger getL() {
        if (this.c == null) {
            return null;
        }
        return this.c.getPositiveValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.getL() != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

