/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.ua;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x9.X9IntegerConverter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECDomainParameters;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSTU4145ECBinary
extends ASN1Object {
    BigInteger a;
    DSTU4145BinaryField a;
    ASN1Integer a;
    ASN1OctetString a = BigInteger.valueOf(0L);
    ASN1Integer b;
    ASN1OctetString b;

    public DSTU4145ECBinary(ECDomainParameters eCDomainParameters) {
        if (!(eCDomainParameters.getCurve() instanceof ECCurve$F2m)) {
            throw new IllegalArgumentException("only binary domain is possible");
        }
        ECCurve$F2m eCCurve$F2m = (ECCurve$F2m)eCDomainParameters.getCurve();
        this.a = new DSTU4145BinaryField(eCCurve$F2m.getM(), eCCurve$F2m.getK1(), eCCurve$F2m.getK2(), eCCurve$F2m.getK3());
        this.a = new ASN1Integer(eCCurve$F2m.getA().toBigInteger());
        X9IntegerConverter x9IntegerConverter = new X9IntegerConverter();
        this.a = new DEROctetString(x9IntegerConverter.integerToBytes(eCCurve$F2m.getB().toBigInteger(), x9IntegerConverter.getByteLength(eCCurve$F2m)));
        this.b = new ASN1Integer(eCDomainParameters.getN());
        this.b = new DEROctetString(DSTU4145PointEncoder.encodePoint(eCDomainParameters.getG()));
    }

    private DSTU4145ECBinary(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        if (aSN1Sequence.getObjectAt(n2) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n2);
            if (aSN1TaggedObject.isExplicit() && 0 == aSN1TaggedObject.getTagNo()) {
                this.a = ASN1Integer.getInstance(aSN1TaggedObject.getLoadedObject()).getValue();
                ++n2;
            } else {
                throw new IllegalArgumentException("object parse error");
            }
        }
        this.a = DSTU4145BinaryField.getInstance(aSN1Sequence.getObjectAt(n2));
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(++n2));
        this.a = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(++n2));
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(++n2));
        this.b = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(++n2));
    }

    public static DSTU4145ECBinary getInstance(Object object) {
        if (object instanceof DSTU4145ECBinary) {
            return (DSTU4145ECBinary)object;
        }
        if (object != null) {
            return new DSTU4145ECBinary(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DSTU4145BinaryField getField() {
        return this.a;
    }

    public BigInteger getA() {
        return this.a.getValue();
    }

    public byte[] getB() {
        return Arrays.clone(this.a.getOctets());
    }

    public BigInteger getN() {
        return this.b.getValue();
    }

    public byte[] getG() {
        return Arrays.clone(this.b.getOctets());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (0 != this.a.compareTo(BigInteger.valueOf(0L))) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, new ASN1Integer(this.a)));
        }
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

