/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x500.X500Name;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.TBSCertificate;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Time;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Certificate
extends ASN1Object {
    ASN1Sequence a;
    TBSCertificate a;
    AlgorithmIdentifier a;
    DERBitString a;

    public static Certificate getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return Certificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static Certificate getInstance(Object object) {
        if (object instanceof Certificate) {
            return (Certificate)object;
        }
        if (object != null) {
            return new Certificate(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private Certificate(ASN1Sequence aSN1Sequence) {
        this.a = aSN1Sequence;
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for a certificate");
        }
        this.a = TBSCertificate.getInstance(aSN1Sequence.getObjectAt(0));
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.a = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public TBSCertificate getTBSCertificate() {
        return this.a;
    }

    public ASN1Integer getVersion() {
        return this.a.getVersion();
    }

    public int getVersionNumber() {
        return this.a.getVersionNumber();
    }

    public ASN1Integer getSerialNumber() {
        return this.a.getSerialNumber();
    }

    public X500Name getIssuer() {
        return this.a.getIssuer();
    }

    public Time getStartDate() {
        return this.a.getStartDate();
    }

    public Time getEndDate() {
        return this.a.getEndDate();
    }

    public X500Name getSubject() {
        return this.a.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.a.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.a;
    }

    public DERBitString getSignature() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

