/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x500.X500Name;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.TBSCertList;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.TBSCertList$CRLEntry;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Time;
import java.util.Enumeration;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CertificateList
extends ASN1Object {
    TBSCertList a;
    AlgorithmIdentifier a;
    DERBitString a;

    public static CertificateList getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return CertificateList.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static CertificateList getInstance(Object object) {
        if (object instanceof CertificateList) {
            return (CertificateList)object;
        }
        if (object != null) {
            return new CertificateList(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertificateList(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for CertificateList");
        }
        this.a = TBSCertList.getInstance(aSN1Sequence.getObjectAt(0));
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.a = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public TBSCertList getTBSCertList() {
        return this.a;
    }

    public TBSCertList$CRLEntry[] getRevokedCertificates() {
        return this.a.getRevokedCertificates();
    }

    public Enumeration getRevokedCertificateEnumeration() {
        return this.a.getRevokedCertificateEnumeration();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.a;
    }

    public DERBitString getSignature() {
        return this.a;
    }

    public int getVersionNumber() {
        return this.a.getVersionNumber();
    }

    public X500Name getIssuer() {
        return this.a.getIssuer();
    }

    public Time getThisUpdate() {
        return this.a.getThisUpdate();
    }

    public Time getNextUpdate() {
        return this.a.getNextUpdate();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        return new DERSequence(aSN1EncodableVector);
    }
}

