/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Enumerated;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ObjectDigestInfo
extends ASN1Object {
    public static final int publicKey = 0;
    public static final int publicKeyCert = 1;
    public static final int otherObjectDigest = 2;
    ASN1Enumerated a;
    ASN1ObjectIdentifier a;
    AlgorithmIdentifier a;
    DERBitString a;

    public static ObjectDigestInfo getInstance(Object object) {
        if (object instanceof ObjectDigestInfo) {
            return (ObjectDigestInfo)object;
        }
        if (object != null) {
            return new ObjectDigestInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static ObjectDigestInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return ObjectDigestInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public ObjectDigestInfo(int n2, ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.a = new ASN1Enumerated(n2);
        if (n2 == 2) {
            this.a = aSN1ObjectIdentifier;
        }
        this.a = algorithmIdentifier;
        this.a = new DERBitString(byArray);
    }

    private ObjectDigestInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 4 || aSN1Sequence.size() < 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.a = ASN1Enumerated.getInstance(aSN1Sequence.getObjectAt(0));
        int n2 = 0;
        if (aSN1Sequence.size() == 4) {
            this.a = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            ++n2;
        }
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1 + n2));
        this.a = DERBitString.getInstance(aSN1Sequence.getObjectAt(2 + n2));
    }

    public ASN1Enumerated getDigestedObjectType() {
        return this.a;
    }

    public ASN1ObjectIdentifier getOtherObjectTypeID() {
        return this.a;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.a;
    }

    public DERBitString getObjectDigest() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        return new DERSequence(aSN1EncodableVector);
    }
}

