/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x500.X500Name;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Extensions;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Time;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TBSCertificate
extends ASN1Object {
    ASN1Sequence a;
    ASN1Integer a;
    ASN1Integer b;
    AlgorithmIdentifier a;
    X500Name a;
    Time a;
    Time b;
    X500Name b;
    SubjectPublicKeyInfo a;
    DERBitString a;
    DERBitString b;
    Extensions a;

    public static TBSCertificate getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return TBSCertificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static TBSCertificate getInstance(Object object) {
        if (object instanceof TBSCertificate) {
            return (TBSCertificate)object;
        }
        if (object != null) {
            return new TBSCertificate(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private TBSCertificate(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        this.a = aSN1Sequence;
        if (aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject) {
            this.a = ASN1Integer.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), true);
        } else {
            n2 = -1;
            this.a = new ASN1Integer(0L);
        }
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n2 + 1));
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2 + 2));
        this.a = X500Name.getInstance(aSN1Sequence.getObjectAt(n2 + 3));
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(n2 + 4);
        this.a = Time.getInstance(aSN1Sequence2.getObjectAt(0));
        this.b = Time.getInstance(aSN1Sequence2.getObjectAt(1));
        this.b = X500Name.getInstance(aSN1Sequence.getObjectAt(n2 + 5));
        this.a = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(n2 + 6));
        block5: for (int i2 = aSN1Sequence.size() - (n2 + 6) - 1; i2 > 0; --i2) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(n2 + 6 + i2);
            switch (dERTaggedObject.getTagNo()) {
                case 1: {
                    this.a = DERBitString.getInstance(dERTaggedObject, false);
                    continue block5;
                }
                case 2: {
                    this.b = DERBitString.getInstance(dERTaggedObject, false);
                    continue block5;
                }
                case 3: {
                    this.a = Extensions.getInstance(ASN1Sequence.getInstance(dERTaggedObject, true));
                }
            }
        }
    }

    public int getVersionNumber() {
        return this.a.getValue().intValue() + 1;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public ASN1Integer getSerialNumber() {
        return this.b;
    }

    public AlgorithmIdentifier getSignature() {
        return this.a;
    }

    public X500Name getIssuer() {
        return this.a;
    }

    public Time getStartDate() {
        return this.a;
    }

    public Time getEndDate() {
        return this.b;
    }

    public X500Name getSubject() {
        return this.b;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.a;
    }

    public DERBitString getIssuerUniqueId() {
        return this.a;
    }

    public DERBitString getSubjectUniqueId() {
        return this.b;
    }

    public Extensions getExtensions() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

