/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.GeneralNames;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.IssuerSerial;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.ObjectDigestInfo;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class V2Form
extends ASN1Object {
    GeneralNames a;
    IssuerSerial a;
    ObjectDigestInfo a;

    public static V2Form getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return V2Form.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static V2Form getInstance(Object object) {
        if (object instanceof V2Form) {
            return (V2Form)object;
        }
        if (object != null) {
            return new V2Form(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public V2Form(GeneralNames generalNames) {
        this(generalNames, null, null);
    }

    public V2Form(GeneralNames generalNames, IssuerSerial issuerSerial) {
        this(generalNames, issuerSerial, null);
    }

    public V2Form(GeneralNames generalNames, ObjectDigestInfo objectDigestInfo) {
        this(generalNames, null, objectDigestInfo);
    }

    public V2Form(GeneralNames generalNames, IssuerSerial issuerSerial, ObjectDigestInfo objectDigestInfo) {
        this.a = generalNames;
        this.a = issuerSerial;
        this.a = objectDigestInfo;
    }

    public V2Form(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        int n2 = 0;
        if (!(aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject)) {
            ++n2;
            this.a = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
        }
        for (int i2 = n2; i2 != aSN1Sequence.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(i2));
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.a = IssuerSerial.getInstance(aSN1TaggedObject, false);
                continue;
            }
            if (aSN1TaggedObject.getTagNo() == 1) {
                this.a = ObjectDigestInfo.getInstance(aSN1TaggedObject, false);
                continue;
            }
            throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public GeneralNames getIssuerName() {
        return this.a;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.a;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
        }
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.a));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

