/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x500.X500Name;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.TBSCertificateStructure;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Time;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class X509CertificateStructure
extends ASN1Object
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    ASN1Sequence a;
    TBSCertificateStructure a;
    AlgorithmIdentifier a;
    DERBitString a;

    public static X509CertificateStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return X509CertificateStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static X509CertificateStructure getInstance(Object object) {
        if (object instanceof X509CertificateStructure) {
            return (X509CertificateStructure)object;
        }
        if (object != null) {
            return new X509CertificateStructure(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X509CertificateStructure(ASN1Sequence aSN1Sequence) {
        this.a = aSN1Sequence;
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for a certificate");
        }
        this.a = TBSCertificateStructure.getInstance(aSN1Sequence.getObjectAt(0));
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.a = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public TBSCertificateStructure getTBSCertificate() {
        return this.a;
    }

    public int getVersion() {
        return this.a.getVersion();
    }

    public ASN1Integer getSerialNumber() {
        return this.a.getSerialNumber();
    }

    public X500Name getIssuer() {
        return this.a.getIssuer();
    }

    public Time getStartDate() {
        return this.a.getStartDate();
    }

    public Time getEndDate() {
        return this.a.getEndDate();
    }

    public X500Name getSubject() {
        return this.a.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.a.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.a;
    }

    public DERBitString getSignature() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

