/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.qualified;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Choice;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERPrintableString;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Iso4217CurrencyCode
extends ASN1Object
implements ASN1Choice {
    final int a = 3;
    final int b = 1;
    final int c = 999;
    ASN1Encodable a = 3;

    public static Iso4217CurrencyCode getInstance(Object object) {
        if (object == null || object instanceof Iso4217CurrencyCode) {
            return (Iso4217CurrencyCode)object;
        }
        if (object instanceof ASN1Integer) {
            ASN1Integer aSN1Integer = ASN1Integer.getInstance(object);
            int n2 = aSN1Integer.getValue().intValue();
            return new Iso4217CurrencyCode(n2);
        }
        if (object instanceof DERPrintableString) {
            DERPrintableString dERPrintableString = DERPrintableString.getInstance(object);
            return new Iso4217CurrencyCode(dERPrintableString.getString());
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public Iso4217CurrencyCode(int n2) {
        if (n2 > 999 || n2 < 1) {
            throw new IllegalArgumentException("wrong size in numeric code : not in (1..999)");
        }
        this.a = new ASN1Integer(n2);
    }

    public Iso4217CurrencyCode(String string) {
        if (string.length() > 3) {
            throw new IllegalArgumentException("wrong size in alphabetic code : max size is 3");
        }
        this.a = new DERPrintableString(string);
    }

    public boolean isAlphabetic() {
        return this.a instanceof DERPrintableString;
    }

    public String getAlphabetic() {
        return ((DERPrintableString)this.a).getString();
    }

    public int getNumeric() {
        return ((ASN1Integer)this.a).getValue().intValue();
    }

    public ASN1Primitive toASN1Primitive() {
        return this.a.toASN1Primitive();
    }
}

