/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.ec;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.ec.ECEncryptor;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.ec.ECPair;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.ec.ECUtil;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECElGamalEncryptor
implements ECEncryptor {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = new SecureRandom();
        }
    }

    public ECPair encrypt(ECPoint eCPoint) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalEncryptor not initialised");
        }
        BigInteger bigInteger = this.key.getParameters().getN();
        BigInteger bigInteger2 = ECUtil.a(bigInteger, this.random);
        ECPoint eCPoint2 = this.key.getParameters().getG();
        ECPoint eCPoint3 = eCPoint2.multiply(bigInteger2);
        ECPoint eCPoint4 = this.key.getQ().multiply(bigInteger2).add(eCPoint);
        return new ECPair(eCPoint3, eCPoint4);
    }
}

