/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.engines;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BasicAgreement;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.BufferedBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DerivationFunction;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.EphemeralKeyPair;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.InvalidCipherTextException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.KeyParser;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Mac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.IESParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.IESWithCipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KDFParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.util.Pack;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import com.zeroturnaround.bundled.org.bouncycastle.util.BigIntegers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IESEngine {
    BasicAgreement a;
    DerivationFunction a;
    Mac a;
    BufferedBlockCipher a;
    byte[] a;
    boolean a;
    CipherParameters a;
    CipherParameters b;
    IESParameters a;
    byte[] b;
    private EphemeralKeyPairGenerator keyPairGenerator;
    private KeyParser keyParser;

    public IESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac) {
        this.a = basicAgreement;
        this.a = derivationFunction;
        this.a = mac;
        this.a = new byte[mac.getMacSize()];
        this.a = null;
    }

    public IESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac, BufferedBlockCipher bufferedBlockCipher) {
        this.a = basicAgreement;
        this.a = derivationFunction;
        this.a = mac;
        this.a = new byte[mac.getMacSize()];
        this.a = bufferedBlockCipher;
    }

    public void init(boolean bl2, CipherParameters cipherParameters, CipherParameters cipherParameters2, CipherParameters cipherParameters3) {
        this.a = bl2;
        this.a = cipherParameters;
        this.b = cipherParameters2;
        this.a = (IESParameters)cipherParameters3;
        this.b = new byte[0];
    }

    public void init(AsymmetricKeyParameter asymmetricKeyParameter, CipherParameters cipherParameters, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.a = true;
        this.b = asymmetricKeyParameter;
        this.a = (IESParameters)cipherParameters;
        this.keyPairGenerator = ephemeralKeyPairGenerator;
    }

    public void init(AsymmetricKeyParameter asymmetricKeyParameter, CipherParameters cipherParameters, KeyParser keyParser) {
        this.a = false;
        this.a = asymmetricKeyParameter;
        this.a = (IESParameters)cipherParameters;
        this.keyParser = keyParser;
    }

    public BufferedBlockCipher getCipher() {
        return this.a;
    }

    public Mac getMac() {
        return this.a;
    }

    private byte[] encryptBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        if (this.a == null) {
            byArray4 = new byte[n3];
            byArray5 = new byte[this.a.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.a.generateBytes(byArray3, 0, byArray3.length);
            if (this.b.length != 0) {
                System.arraycopy(byArray3, 0, byArray5, 0, byArray5.length);
                System.arraycopy(byArray3, byArray5.length, byArray4, 0, byArray4.length);
            } else {
                System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
                System.arraycopy(byArray3, n3, byArray5, 0, byArray5.length);
            }
            byArray2 = new byte[n3];
            for (int i2 = 0; i2 != n3; ++i2) {
                byArray2[i2] = (byte)(byArray[n2 + i2] ^ byArray4[i2]);
            }
            n4 = n3;
        } else {
            byArray4 = new byte[((IESWithCipherParameters)this.a).getCipherKeySize() / 8];
            byArray5 = new byte[this.a.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.a.generateBytes(byArray3, 0, byArray3.length);
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            System.arraycopy(byArray3, byArray4.length, byArray5, 0, byArray5.length);
            this.a.init(true, new KeyParameter(byArray4));
            byArray2 = new byte[this.a.getOutputSize(n3)];
            n4 = this.a.processBytes(byArray, n2, n3, byArray2, 0);
            n4 += this.a.doFinal(byArray2, n4);
        }
        byte[] byArray6 = this.a.getEncodingV();
        byte[] byArray7 = new byte[4];
        if (this.b.length != 0 && byArray6 != null) {
            Pack.intToBigEndian(byArray6.length * 8, byArray7, 0);
        }
        byte[] byArray8 = new byte[this.a.getMacSize()];
        this.a.init(new KeyParameter(byArray5));
        this.a.update(byArray2, 0, byArray2.length);
        if (byArray6 != null) {
            this.a.update(byArray6, 0, byArray6.length);
        }
        if (this.b.length != 0) {
            this.a.update(byArray7, 0, byArray7.length);
        }
        this.a.doFinal(byArray8, 0);
        byte[] byArray9 = new byte[this.b.length + n4 + byArray8.length];
        System.arraycopy(this.b, 0, byArray9, 0, this.b.length);
        System.arraycopy(byArray2, 0, byArray9, this.b.length, n4);
        System.arraycopy(byArray8, 0, byArray9, this.b.length + n4, byArray8.length);
        return byArray9;
    }

    private byte[] decryptBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        if (this.a == null) {
            byArray4 = new byte[n3 - this.b.length - this.a.getMacSize()];
            byArray5 = new byte[this.a.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.a.generateBytes(byArray3, 0, byArray3.length);
            if (this.b.length != 0) {
                System.arraycopy(byArray3, 0, byArray5, 0, byArray5.length);
                System.arraycopy(byArray3, byArray5.length, byArray4, 0, byArray4.length);
            } else {
                System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
                System.arraycopy(byArray3, byArray4.length, byArray5, 0, byArray5.length);
            }
            byArray2 = new byte[byArray4.length];
            for (int i2 = 0; i2 != byArray4.length; ++i2) {
                byArray2[i2] = (byte)(byArray[n2 + this.b.length + i2] ^ byArray4[i2]);
            }
            n4 = byArray4.length;
        } else {
            byArray4 = new byte[((IESWithCipherParameters)this.a).getCipherKeySize() / 8];
            byArray5 = new byte[this.a.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.a.generateBytes(byArray3, 0, byArray3.length);
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            System.arraycopy(byArray3, byArray4.length, byArray5, 0, byArray5.length);
            this.a.init(false, new KeyParameter(byArray4));
            byArray2 = new byte[this.a.getOutputSize(n3 - this.b.length - this.a.getMacSize())];
            n4 = this.a.processBytes(byArray, n2 + this.b.length, n3 - this.b.length - this.a.getMacSize(), byArray2, 0);
            n4 += this.a.doFinal(byArray2, n4);
        }
        byte[] byArray6 = this.a.getEncodingV();
        byte[] byArray7 = new byte[4];
        if (this.b.length != 0 && byArray6 != null) {
            Pack.intToBigEndian(byArray6.length * 8, byArray7, 0);
        }
        int n5 = n2 + n3;
        byte[] byArray8 = Arrays.copyOfRange(byArray, n5 - this.a.getMacSize(), n5);
        byte[] byArray9 = new byte[byArray8.length];
        this.a.init(new KeyParameter(byArray5));
        this.a.update(byArray, n2 + this.b.length, n3 - this.b.length - byArray9.length);
        if (byArray6 != null) {
            this.a.update(byArray6, 0, byArray6.length);
        }
        if (this.b.length != 0) {
            this.a.update(byArray7, 0, byArray7.length);
        }
        this.a.doFinal(byArray9, 0);
        if (!Arrays.constantTimeAreEqual(byArray8, byArray9)) {
            throw new InvalidCipherTextException("Invalid MAC.");
        }
        return Arrays.copyOfRange(byArray2, 0, n4);
    }

    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2;
        Object object;
        if (this.a) {
            if (this.keyPairGenerator != null) {
                object = this.keyPairGenerator.generate();
                this.a = ((EphemeralKeyPair)object).getKeyPair().getPrivate();
                this.b = ((EphemeralKeyPair)object).getEncodedPublicKey();
            }
        } else if (this.keyParser != null) {
            object = new ByteArrayInputStream(byArray, n2, n3);
            try {
                this.b = this.keyParser.readKey((InputStream)object);
            }
            catch (IOException iOException) {
                throw new InvalidCipherTextException("unable to recover ephemeral public key: " + iOException.getMessage(), iOException);
            }
            int n4 = n3 - ((ByteArrayInputStream)object).available();
            this.b = Arrays.copyOfRange(byArray, n2, n2 + n4);
        }
        this.a.init(this.a);
        object = this.a.calculateAgreement(this.b);
        byte[] byArray3 = BigIntegers.asUnsignedByteArray(this.a.getFieldSize(), (BigInteger)object);
        if (this.b.length != 0) {
            byArray2 = new byte[this.b.length + byArray3.length];
            System.arraycopy(this.b, 0, byArray2, 0, this.b.length);
            System.arraycopy(byArray3, 0, byArray2, this.b.length, byArray3.length);
        } else {
            byArray2 = byArray3;
        }
        KDFParameters kDFParameters = new KDFParameters(byArray2, this.a.getDerivationV());
        this.a.init(kDFParameters);
        return this.a ? this.encryptBlock(byArray, n2, n3) : this.decryptBlock(byArray, n2, n3);
    }
}

