/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.prng;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Mac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.prng.EntropySourceProvider;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.prng.SP800SecureRandom;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.prng.SP800SecureRandomBuilder$CTRDRBGProvider;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.prng.SP800SecureRandomBuilder$DualECDRBGProvider;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.prng.SP800SecureRandomBuilder$HMacDRBGProvider;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.prng.SP800SecureRandomBuilder$HashDRBGProvider;
import java.security.SecureRandom;

public class SP800SecureRandomBuilder {
    private final SecureRandom random;
    private final EntropySourceProvider entropySourceProvider;
    private byte[] personalizationString;
    private int securityStrength = 256;
    private int entropyBitsRequired = 256;

    public SP800SecureRandomBuilder() {
        this(new SecureRandom(), false);
    }

    public SP800SecureRandomBuilder(SecureRandom secureRandom, boolean bl2) {
        this.random = secureRandom;
        this.entropySourceProvider = new BasicEntropySourceProvider(this.random, bl2);
    }

    public SP800SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.random = null;
        this.entropySourceProvider = entropySourceProvider;
    }

    public SP800SecureRandomBuilder setPersonalizationString(byte[] byArray) {
        this.personalizationString = byArray;
        return this;
    }

    public SP800SecureRandomBuilder setSecurityStrength(int n2) {
        this.securityStrength = n2;
        return this;
    }

    public SP800SecureRandomBuilder setEntropyBitsRequired(int n2) {
        this.entropyBitsRequired = n2;
        return this;
    }

    public SP800SecureRandom buildHash(Digest digest, byte[] byArray, boolean bl2) {
        return new SP800SecureRandom(this.random, this.entropySourceProvider.get(this.entropyBitsRequired), new SP800SecureRandomBuilder$HashDRBGProvider(digest, byArray, this.personalizationString, this.securityStrength), bl2);
    }

    public SP800SecureRandom buildCTR(BlockCipher blockCipher, int n2, byte[] byArray, boolean bl2) {
        return new SP800SecureRandom(this.random, this.entropySourceProvider.get(this.entropyBitsRequired), new SP800SecureRandomBuilder$CTRDRBGProvider(blockCipher, n2, byArray, this.personalizationString, this.securityStrength), bl2);
    }

    public SP800SecureRandom buildHMAC(Mac mac, byte[] byArray, boolean bl2) {
        return new SP800SecureRandom(this.random, this.entropySourceProvider.get(this.entropyBitsRequired), new SP800SecureRandomBuilder$HMacDRBGProvider(mac, byArray, this.personalizationString, this.securityStrength), bl2);
    }

    public SP800SecureRandom buildDualEC(Digest digest, byte[] byArray, boolean bl2) {
        return new SP800SecureRandom(this.random, this.entropySourceProvider.get(this.entropyBitsRequired), new SP800SecureRandomBuilder$DualECDRBGProvider(digest, byArray, this.personalizationString, this.securityStrength), bl2);
    }
}

